/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;

public final class ColumnSummaryPanel
extends JPanel {
    private ColumnSummaryPanel(ColumnSummaryModel model) {
        this.setLayout(new BorderLayout());
        this.add((Component)ColumnSummaryPanel.createSummaryField(Objects.requireNonNull(model, "model")), "Center");
    }

    public static ColumnSummaryPanel columnSummaryPanel(ColumnSummaryModel columnSummaryModel) {
        return new ColumnSummaryPanel(columnSummaryModel);
    }

    private static JTextField createSummaryField(final ColumnSummaryModel model) {
        final JPopupMenu popupMenu = ColumnSummaryPanel.createPopupMenu(model);
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)Components.stringField().linkedValue((ValueObserver<String>)model.summaryText())).horizontalAlignment(4).editable(false)).focusable(false)).popupMenu(summaryField -> popupMenu)).mouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!((Boolean)model.locked().get()).booleanValue()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY() - popupMenu.getPreferredSize().height);
                }
            }
        })).build();
    }

    private static JPopupMenu createPopupMenu(ColumnSummaryModel model) {
        JPopupMenu popupMenu = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        for (ColumnSummaryModel.Summary summary : model.summaries()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem((Action)Control.builder(() -> model.summary().set((Object)summary)).name(summary.toString()).build());
            model.summary().addDataListener(newSummary -> item.setSelected(newSummary.equals(summary)));
            item.setSelected(((ColumnSummaryModel.Summary)model.summary().get()).equals(summary));
            group.add(item);
            popupMenu.add(item);
        }
        return popupMenu;
    }
}

