/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.i18n.Messages;
import is.codion.common.item.Item;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.combobox.ItemComboBoxModel;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableSearchModel;
import is.codion.swing.common.model.component.table.FilteredTableSelectionModel;
import is.codion.swing.common.model.component.table.FilteredTableSortModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.ColumnSelectionPanel;
import is.codion.swing.common.ui.component.table.FilteredTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilteredTableCellRendererFactory;
import is.codion.swing.common.ui.component.table.FilteredTableConditionPanel;
import is.codion.swing.common.ui.component.table.FilteredTableHeaderRenderer;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class FilteredTable<R, C>
extends JTable {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(FilteredTable.class.getName());
    public static final PropertyValue<Integer> AUTO_RESIZE_MODE = Configuration.integerValue((String)"is.codion.swing.common.ui.component.table.FilteredTable.autoResizeMode", (int)0);
    public static final PropertyValue<Boolean> ALLOW_COLUMN_REORDERING = Configuration.booleanValue((String)"is.codion.swing.common.ui.component.table.FilteredTable.allowColumnReordering", (boolean)true);
    public static final KeyboardShortcuts<KeyboardShortcut> DEFAULT_KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, FilteredTable::defaultKeyStroke);
    private static final String SELECT = "select";
    private static final String SELECT_COLUMNS = "select_columns";
    private static final String RESET = "reset";
    private static final String RESET_COLUMNS_DESCRIPTION = "reset_columns_description";
    private static final String SINGLE_SELECTION_MODE = "single_selection_mode";
    private static final String AUTO_RESIZE = "auto_resize";
    private static final String RESIZE_OFF = "resize_off";
    private static final String RESIZE_NEXT_COLUMN = "resize_next_column";
    private static final String RESIZE_SUBSEQUENT_COLUMNS = "resize_subsequent_columns";
    private static final String RESIZE_LAST_COLUMN = "resize_last_column";
    private static final String RESIZE_ALL_COLUMNS = "resize_all_columns";
    private static final int SEARCH_FIELD_MINIMUM_WIDTH = 100;
    private static final int COLUMN_RESIZE_AMOUNT = 10;
    private static final List<Integer> RESIZE_KEYS = Arrays.asList(521, 107, 45, 109);
    private final FilteredTableModel<R, C> tableModel;
    private final ColumnConditionPanel.Factory<C> filterPanelFactory;
    private final Event<MouseEvent> doubleClickEvent = Event.event();
    private final Value<Action> doubleClickAction;
    private final State sortingEnabled;
    private final State scrollToSelectedItem;
    private final Value<CenterOnScroll> centerOnScroll;
    private FilteredTableConditionPanel<C> filterPanel;
    private JTextField searchField;

    private FilteredTable(DefaultBuilder<R, C> builder) {
        super((TableModel)builder.tableModel, (TableColumnModel)builder.tableModel.columnModel(), (ListSelectionModel)builder.tableModel.selectionModel());
        this.tableModel = builder.tableModel;
        this.filterPanelFactory = builder.filterPanelFactory;
        this.centerOnScroll = Value.value((Object)((Object)builder.centerOnScroll), (Object)((Object)CenterOnScroll.NEITHER));
        this.doubleClickAction = Value.value((Object)builder.doubleClickAction);
        this.scrollToSelectedItem = State.state((boolean)builder.scrollToSelectedItem);
        this.sortingEnabled = State.state((boolean)builder.sortingEnabled);
        this.autoStartsEdit(builder.autoStartsEdit);
        this.setSelectionMode(builder.selectionMode);
        this.setAutoResizeMode(builder.autoResizeMode);
        this.configureColumns(builder.cellRendererFactory);
        this.configureTableHeader(builder.columnReorderingAllowed, builder.columnResizingAllowed);
        this.bindEvents();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI(this.getTableHeader(), this.searchField, this.filterPanel);
        Utilities.updateUI(this.getModel().columnModel().hidden().stream().flatMap(FilteredTable::columnComponents).collect(Collectors.toList()));
    }

    public FilteredTableModel<R, C> getModel() {
        return (FilteredTableModel)super.getModel();
    }

    public FilteredTableColumnModel<C> getColumnModel() {
        return (FilteredTableColumnModel)super.getColumnModel();
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (this.tableModel != null) {
            throw new IllegalStateException("Table model has already been set");
        }
        if (!(dataModel instanceof FilteredTableModel)) {
            throw new IllegalArgumentException("FilteredTable model must be a FilteredTableModel instance");
        }
        List selection = ((FilteredTableModel)dataModel).selectionModel().getSelectedItems();
        super.setModel(dataModel);
        if (!selection.isEmpty()) {
            ((FilteredTableModel)dataModel).selectionModel().setSelectedItems((Collection)selection);
        }
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        if (this.columnModel != null) {
            throw new IllegalStateException("Column model has already been set");
        }
        if (!(columnModel instanceof FilteredTableColumnModel)) {
            throw new IllegalArgumentException("FilteredTable column model must be a FilteredTableColumnModel instance");
        }
        super.setColumnModel(columnModel);
    }

    @Override
    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (this.selectionModel != null) {
            throw new IllegalStateException("Selection model has already been set");
        }
        if (!(selectionModel instanceof FilteredTableSelectionModel)) {
            throw new IllegalArgumentException("FilteredTable selection model must be a FilteredTableSelectionModel instance");
        }
        super.setSelectionModel(selectionModel);
    }

    public FilteredTableConditionPanel<C> filterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = FilteredTableConditionPanel.filteredTableConditionPanel(this.tableModel.filterModel(), this.tableModel.columnModel(), this.filterPanelFactory);
        }
        return this.filterPanel;
    }

    public JTextField searchField() {
        if (this.searchField == null) {
            this.searchField = this.createSearchField();
        }
        return this.searchField;
    }

    public Value<Action> doubleClickAction() {
        return this.doubleClickAction;
    }

    public State sortingEnabled() {
        return this.sortingEnabled;
    }

    public State scrollToSelectedItem() {
        return this.scrollToSelectedItem;
    }

    public Value<CenterOnScroll> centerOnScroll() {
        return this.centerOnScroll;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.tableModel.selectionModel().setSelectionMode(selectionMode);
    }

    public void selectColumns() {
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(this.tableModel.columnModel());
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog(columnSelectionPanel).owner(this.getParent())).title(MESSAGES.getString(SELECT_COLUMNS))).onShown(dialog -> columnSelectionPanel.requestColumnPanelFocus())).onOk(columnSelectionPanel::applyChanges).show();
    }

    public void selectAutoResizeMode() {
        ItemComboBoxModel<Integer> autoResizeComboBoxModel = this.createAutoResizeModeComboBoxModel();
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog(((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)Components.itemComboBox(autoResizeComboBoxModel).build()).border(Borders.emptyBorder())).build()).owner(this.getParent())).title(MESSAGES.getString(AUTO_RESIZE))).onOk(() -> this.setAutoResizeMode((Integer)((Item)autoResizeComboBoxModel.selectedValue()).get())).show();
    }

    public boolean cellVisible(int row, int column) {
        JViewport viewport = Utilities.parentOfType(JViewport.class, this);
        return viewport != null && this.cellVisible(viewport, row, column);
    }

    public void scrollToColumn(C columnIdentifier) {
        Objects.requireNonNull(columnIdentifier);
        JViewport viewport = Utilities.parentOfType(JViewport.class, this);
        if (viewport != null) {
            this.scrollToRowColumn(viewport, this.rowAtPoint(viewport.getViewPosition()), this.getModel().columnModel().getColumnIndex(columnIdentifier), CenterOnScroll.NEITHER);
        }
    }

    public void scrollToCoordinate(int row, int column, CenterOnScroll centerOnScroll) {
        Objects.requireNonNull(centerOnScroll);
        JViewport viewport = Utilities.parentOfType(JViewport.class, this);
        if (viewport != null) {
            this.scrollToRowColumn(viewport, row, column, centerOnScroll);
        }
    }

    public void copySelectedCell() {
        int selectedRow = this.getSelectedRow();
        int selectedColumn = this.getSelectedColumn();
        if (selectedRow >= 0 && selectedColumn >= 0) {
            FilteredTableColumn column = this.getModel().columnModel().getColumn(selectedColumn);
            Utilities.setClipboard(this.getModel().getStringAt(selectedRow, column.getIdentifier()));
        }
    }

    public void copyRowsAsTabDelimitedString() {
        Utilities.setClipboard(this.tableModel.rowsAsDelimitedString('\t'));
    }

    public Control createSelectColumnsControl() {
        return Control.builder(this::selectColumns).name(MESSAGES.getString(SELECT) + "...").enabled(this.tableModel.columnModel().locked().not()).description(MESSAGES.getString(SELECT_COLUMNS)).build();
    }

    public Controls createToggleColumnsControls() {
        return (Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString(SELECT))).enabled(this.tableModel.columnModel().locked().not())).controls((Control[])this.tableModel.columnModel().columns().stream().sorted(new ColumnComparator()).map(this::createToggleColumnControl).toArray(ToggleControl[]::new)).build();
    }

    public Control createResetColumnsControl() {
        return Control.builder(() -> ((FilteredTableColumnModel)this.getModel().columnModel()).resetColumns()).name(MESSAGES.getString(RESET)).enabled(this.tableModel.columnModel().locked().not()).description(MESSAGES.getString(RESET_COLUMNS_DESCRIPTION)).build();
    }

    public Control createAutoResizeModeControl() {
        return Control.builder(this::selectAutoResizeMode).name(MESSAGES.getString(AUTO_RESIZE) + "...").enabled(this.tableModel.columnModel().locked().not()).build();
    }

    public ToggleControl createSingleSelectionModeControl() {
        return (ToggleControl)ToggleControl.builder(this.tableModel.selectionModel().singleSelectionMode()).name(MESSAGES.getString(SINGLE_SELECTION_MODE)).build();
    }

    public void autoStartsEdit(boolean autoStartsEdit) {
        this.putClientProperty("JTable.autoStartsEdit", autoStartsEdit);
    }

    public void addDoubleClickListener(Consumer<MouseEvent> listener) {
        this.doubleClickEvent.addDataListener(listener);
    }

    public void removeDoubleClickListener(Consumer<MouseEvent> listener) {
        this.doubleClickEvent.removeDataListener(listener);
    }

    public static <R, C> Builder<R, C> builder(FilteredTableModel<R, C> tableModel) {
        return new DefaultBuilder<R, C>(tableModel);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new FilteredTableHeader(this.columnModel);
    }

    private JTextField createSearchField() {
        Control nextResult = Control.control(() -> this.selectSearchResult(false, true));
        Control selectNextResult = Control.control(() -> this.selectSearchResult(true, true));
        Control previousResult = Control.control(() -> this.selectSearchResult(false, false));
        Control selectPreviousResult = Control.control(() -> this.selectSearchResult(true, false));
        Control requestTableFocus = Control.control(this::requestFocusInWindow);
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)Components.stringField((Value<String>)this.tableModel.searchModel().searchString()).minimumWidth(100)).selectAllOnFocusGained(true)).keyEvent(KeyEvents.builder(10).action(nextResult))).keyEvent(KeyEvents.builder(10).modifiers(64).action(selectNextResult))).keyEvent(KeyEvents.builder(40).action(nextResult))).keyEvent(KeyEvents.builder(40).modifiers(64).action(selectNextResult))).keyEvent(KeyEvents.builder(38).action(previousResult))).keyEvent(KeyEvents.builder(38).modifiers(64).action(selectPreviousResult))).keyEvent(KeyEvents.builder(27).action(requestTableFocus))).popupMenuControls(textField -> this.searchFieldPopupMenuControls())).hintText(Messages.find() + "...").onTextChanged(this::onSearchTextChanged)).onBuild(field -> KeyEvents.builder(70).modifiers(128).action(Control.control(field::requestFocusInWindow)).condition(1).enable(this))).build();
    }

    private void selectSearchResult(boolean addToSelection, boolean next) {
        this.searchResult(addToSelection, next).ifPresent(rowColumn -> {
            if (!addToSelection) {
                this.setColumnSelectionInterval(rowColumn.column(), rowColumn.column());
            }
            this.scrollToCoordinate(rowColumn.row(), rowColumn.column(), (CenterOnScroll)((Object)((Object)this.centerOnScroll.get())));
        });
    }

    private Optional<FilteredTableSearchModel.RowColumn> searchResult(boolean addToSelection, boolean next) {
        FilteredTableSearchModel searchModel = this.tableModel.searchModel();
        if (next) {
            return addToSelection ? searchModel.selectNextResult() : searchModel.nextResult();
        }
        return addToSelection ? searchModel.selectPreviousResult() : searchModel.previousResult();
    }

    private void onSearchTextChanged(String searchText) {
        if (!searchText.isEmpty()) {
            this.tableModel.searchModel().nextResult();
        }
    }

    private void toggleColumnSorting(int selectedColumn, boolean add) {
        if (selectedColumn != -1) {
            Object columnIdentifier = this.tableModel.columnModel().getColumn(selectedColumn).getIdentifier();
            FilteredTableSortModel sortModel = this.tableModel.sortModel();
            if (sortModel.isSortingEnabled(columnIdentifier)) {
                if (add) {
                    sortModel.addSortOrder(columnIdentifier, FilteredTableSortModel.nextSortOrder((SortOrder)sortModel.sortOrder(columnIdentifier)));
                } else {
                    sortModel.setSortOrder(columnIdentifier, FilteredTableSortModel.nextSortOrder((SortOrder)sortModel.sortOrder(columnIdentifier)));
                }
            }
        }
    }

    private Controls searchFieldPopupMenuControls() {
        return (Controls)Controls.builder().control((Control.Builder<?, ?>)ToggleControl.builder(this.tableModel.searchModel().caseSensitive()).name(MESSAGES.getString("case_sensitive_search"))).controls(new Control.Builder[]{ToggleControl.builder(this.tableModel.searchModel().regularExpression()).name(MESSAGES.getString("regular_expression_search"))}).build();
    }

    private boolean cellVisible(JViewport viewport, int row, int column) {
        Rectangle cellRect = this.getCellRect(row, column, true);
        Point viewPosition = viewport.getViewPosition();
        cellRect.setLocation(cellRect.x - viewPosition.x, cellRect.y - viewPosition.y);
        return new Rectangle(viewport.getExtentSize()).contains(cellRect);
    }

    private void scrollToRowColumn(JViewport viewport, int row, int column, CenterOnScroll centerOnScroll) {
        Rectangle cellRectangle = this.getCellRect(row, column, true);
        Rectangle viewRectangle = viewport.getViewRect();
        cellRectangle.setLocation(cellRectangle.x - viewRectangle.x, cellRectangle.y - viewRectangle.y);
        int x = cellRectangle.x;
        int y = cellRectangle.y;
        if (centerOnScroll != CenterOnScroll.NEITHER) {
            if ((centerOnScroll == CenterOnScroll.COLUMN || centerOnScroll == CenterOnScroll.BOTH) && cellRectangle.x < (x = (viewRectangle.width - cellRectangle.width) / 2)) {
                x = -x;
            }
            if ((centerOnScroll == CenterOnScroll.ROW || centerOnScroll == CenterOnScroll.BOTH) && cellRectangle.y < (y = (viewRectangle.height - cellRectangle.height) / 2)) {
                y = -y;
            }
            cellRectangle.translate(x, y);
        }
        viewport.scrollRectToVisible(cellRectangle);
    }

    private ToggleControl createToggleColumnControl(FilteredTableColumn<C> column) {
        return (ToggleControl)ToggleControl.builder(this.tableModel.columnModel().visible(column.getIdentifier())).name(String.valueOf(column.getHeaderValue())).description(column.toolTipText()).build();
    }

    private void configureColumns(FilteredTableCellRendererFactory<C> cellRendererFactory) {
        this.tableModel.columnModel().columns().stream().filter(column -> column.getCellRenderer() == null).forEach(column -> column.setCellRenderer(cellRendererFactory.tableCellRenderer((FilteredTableColumn)column)));
        this.tableModel.columnModel().columns().stream().filter(column -> column.getHeaderRenderer() == null).forEach(column -> column.setHeaderRenderer(new FilteredTableHeaderRenderer(this, column)));
    }

    private void configureTableHeader(boolean reorderingAllowed, boolean columnResizingAllowed) {
        JTableHeader header = this.getTableHeader();
        header.setFocusable(false);
        header.setReorderingAllowed(reorderingAllowed);
        header.setResizingAllowed(columnResizingAllowed);
        header.setAutoscrolls(true);
        header.addMouseMotionListener(new ColumnDragMouseHandler());
        header.addMouseListener(new MouseSortHandler());
    }

    private ItemComboBoxModel<Integer> createAutoResizeModeComboBoxModel() {
        ItemComboBoxModel autoResizeComboBoxModel = ItemComboBoxModel.itemComboBoxModel(Arrays.asList(Item.item((Object)0, (String)MESSAGES.getString(RESIZE_OFF)), Item.item((Object)1, (String)MESSAGES.getString(RESIZE_NEXT_COLUMN)), Item.item((Object)2, (String)MESSAGES.getString(RESIZE_SUBSEQUENT_COLUMNS)), Item.item((Object)3, (String)MESSAGES.getString(RESIZE_LAST_COLUMN)), Item.item((Object)4, (String)MESSAGES.getString(RESIZE_ALL_COLUMNS))));
        autoResizeComboBoxModel.setSelectedItem((Object)Item.item((Object)this.getAutoResizeMode()));
        return autoResizeComboBoxModel;
    }

    private void bindEvents() {
        this.tableModel.selectionModel().addSelectedIndexesListener((Consumer)new ScrollToSelectedListener());
        this.tableModel.filterModel().addChangeListener(this.getTableHeader()::repaint);
        this.tableModel.searchModel().addCurrentResultListener(rowColumn -> this.repaint());
        this.tableModel.sortModel().addSortingChangedListener(columnIdentifier -> this.getTableHeader().repaint());
        this.addMouseListener(new FilteredTableMouseListener());
        this.addKeyListener(new MoveResizeColumnKeyListener());
        KeyEvents.builder((KeyStroke)DEFAULT_KEYBOARD_SHORTCUTS.keyStroke(KeyboardShortcut.COPY_CELL).get()).action(Control.control(this::copySelectedCell)).enable(this);
        KeyEvents.builder((KeyStroke)DEFAULT_KEYBOARD_SHORTCUTS.keyStroke(KeyboardShortcut.TOGGLE_SORT_COLUMN_ADD).get()).action(Control.control(() -> this.toggleColumnSorting(this.getSelectedColumn(), true))).enable(this);
        KeyEvents.builder((KeyStroke)DEFAULT_KEYBOARD_SHORTCUTS.keyStroke(KeyboardShortcut.TOGGLE_SORT_COLUMN).get()).action(Control.control(() -> this.toggleColumnSorting(this.getSelectedColumn(), false))).enable(this);
    }

    private static Stream<JComponent> columnComponents(FilteredTableColumn<?> column) {
        ArrayList<JComponent> components = new ArrayList<JComponent>(3);
        FilteredTable.addIfComponent(components, column.getCellRenderer());
        FilteredTable.addIfComponent(components, column.getCellEditor());
        FilteredTable.addIfComponent(components, column.getHeaderRenderer());
        return components.stream();
    }

    private static void addIfComponent(Collection<JComponent> components, Object object) {
        if (object instanceof JComponent) {
            components.add((JComponent)object);
        }
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        switch (shortcut) {
            case COPY_CELL: {
                return KeyboardShortcuts.keyStroke(67, 640);
            }
            case TOGGLE_SORT_COLUMN: {
                return KeyboardShortcuts.keyStroke(40, 512);
            }
            case TOGGLE_SORT_COLUMN_ADD: {
                return KeyboardShortcuts.keyStroke(38, 512);
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class DefaultBuilder<R, C>
    extends AbstractComponentBuilder<Void, FilteredTable<R, C>, Builder<R, C>>
    implements Builder<R, C> {
        private final FilteredTableModel<R, C> tableModel;
        private ColumnConditionPanel.Factory<C> filterPanelFactory;
        private FilteredTableCellRendererFactory<C> cellRendererFactory;
        private boolean autoStartsEdit = false;
        private CenterOnScroll centerOnScroll = CenterOnScroll.NEITHER;
        private Action doubleClickAction;
        private boolean scrollToSelectedItem = true;
        private boolean sortingEnabled = true;
        private int selectionMode = 2;
        private boolean columnReorderingAllowed = (Boolean)ALLOW_COLUMN_REORDERING.get();
        private boolean columnResizingAllowed = true;
        private int autoResizeMode = (Integer)AUTO_RESIZE_MODE.get();

        private DefaultBuilder(FilteredTableModel<R, C> tableModel) {
            this.tableModel = Objects.requireNonNull(tableModel);
            this.filterPanelFactory = new DefaultFilterPanelFactory();
            this.cellRendererFactory = new DefaultFilteredTableCellRendererFactory<R, C>(tableModel);
        }

        @Override
        public Builder<R, C> filterPanelFactory(ColumnConditionPanel.Factory<C> filterPanelFactory) {
            this.filterPanelFactory = Objects.requireNonNull(filterPanelFactory);
            return this;
        }

        @Override
        public Builder<R, C> cellRendererFactory(FilteredTableCellRendererFactory<C> cellRendererFactory) {
            this.cellRendererFactory = Objects.requireNonNull(cellRendererFactory);
            return this;
        }

        @Override
        public Builder<R, C> autoStartsEdit(boolean autoStartsEdit) {
            this.autoStartsEdit = autoStartsEdit;
            return this;
        }

        @Override
        public Builder<R, C> centerOnScroll(CenterOnScroll centerOnScroll) {
            this.centerOnScroll = Objects.requireNonNull(centerOnScroll);
            return this;
        }

        @Override
        public Builder<R, C> doubleClickAction(Action doubleClickAction) {
            this.doubleClickAction = Objects.requireNonNull(doubleClickAction);
            return this;
        }

        @Override
        public Builder<R, C> scrollToSelectedItem(boolean scrollToSelectedItem) {
            this.scrollToSelectedItem = scrollToSelectedItem;
            return this;
        }

        @Override
        public Builder<R, C> sortingEnabled(boolean sortingEnabled) {
            this.sortingEnabled = sortingEnabled;
            return this;
        }

        @Override
        public Builder<R, C> selectionMode(int selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        @Override
        public Builder<R, C> columnReorderingAllowed(boolean columnReorderingAllowed) {
            this.columnReorderingAllowed = columnReorderingAllowed;
            return this;
        }

        @Override
        public Builder<R, C> columnResizingAllowed(boolean columnResizingAllowed) {
            this.columnResizingAllowed = columnResizingAllowed;
            return this;
        }

        @Override
        public Builder<R, C> autoResizeMode(int autoResizeMode) {
            this.autoResizeMode = autoResizeMode;
            return this;
        }

        @Override
        protected FilteredTable<R, C> createComponent() {
            return new FilteredTable(this);
        }

        @Override
        protected ComponentValue<Void, FilteredTable<R, C>> createComponentValue(FilteredTable<R, C> component) {
            throw new UnsupportedOperationException("A ComponentValue can not be based on a FilteredTable");
        }

        @Override
        protected void setInitialValue(FilteredTable<R, C> component, Void initialValue) {
        }
    }

    public static enum CenterOnScroll {
        COLUMN,
        ROW,
        BOTH,
        NEITHER;

    }

    static final class ColumnComparator
    implements Comparator<TableColumn> {
        private final Comparator<String> collator = Text.collator();

        ColumnComparator() {
        }

        @Override
        public int compare(TableColumn col1, TableColumn col2) {
            return this.collator.compare(String.valueOf(col1.getHeaderValue()), String.valueOf(col2.getHeaderValue()));
        }
    }

    private static final class FilteredTableHeader
    extends JTableHeader {
        private FilteredTableHeader(TableColumnModel columnModel) {
            super(columnModel);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int index = this.columnModel.getColumnIndexAtX(event.getPoint().x);
            if (index != -1) {
                return ((FilteredTableColumn)this.columnModel.getColumn(index)).toolTipText();
            }
            return null;
        }
    }

    private final class ColumnDragMouseHandler
    extends MouseMotionAdapter {
        private ColumnDragMouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            FilteredTable.this.scrollRectToVisible(new Rectangle(e.getX(), FilteredTable.this.getVisibleRect().y, 1, 1));
        }
    }

    private final class MouseSortHandler
    extends MouseAdapter {
        private MouseSortHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!((Boolean)FilteredTable.this.sortingEnabled.get()).booleanValue() || e.getButton() != 1 || e.isAltDown()) {
                return;
            }
            FilteredTableColumnModel columnModel = FilteredTable.this.tableModel.columnModel();
            int index = columnModel.getColumnIndexAtX(e.getX());
            if (index >= 0) {
                if (!FilteredTable.this.getSelectionModel().isSelectionEmpty()) {
                    FilteredTable.this.setColumnSelectionInterval(index, index);
                }
                Object columnIdentifier = columnModel.getColumn(index).getIdentifier();
                if (FilteredTable.this.tableModel.sortModel().isSortingEnabled(columnIdentifier)) {
                    FilteredTableSortModel sortModel = FilteredTable.this.tableModel.sortModel();
                    SortOrder nextSortOrder = FilteredTableSortModel.nextSortOrder((SortOrder)sortModel.sortOrder(columnIdentifier));
                    if (e.isControlDown()) {
                        sortModel.addSortOrder(columnIdentifier, nextSortOrder);
                    } else {
                        sortModel.setSortOrder(columnIdentifier, nextSortOrder);
                    }
                }
            }
        }
    }

    private final class ScrollToSelectedListener
    implements Consumer<List<Integer>> {
        private ScrollToSelectedListener() {
        }

        @Override
        public void accept(List<Integer> selectedRowIndexes) {
            if (((Boolean)FilteredTable.this.scrollToSelectedItem.get()).booleanValue() && !selectedRowIndexes.isEmpty() && this.noRowVisible(selectedRowIndexes)) {
                FilteredTable.this.scrollToCoordinate(selectedRowIndexes.get(0), FilteredTable.this.getSelectedColumn(), (CenterOnScroll)((Object)FilteredTable.this.centerOnScroll.get()));
            }
        }

        private boolean noRowVisible(List<Integer> rows) {
            JViewport viewport = Utilities.parentOfType(JViewport.class, FilteredTable.this);
            if (viewport != null) {
                return rows.stream().noneMatch(row -> this.rowVisible(viewport, (int)row));
            }
            return false;
        }

        private boolean rowVisible(JViewport viewport, int row) {
            int topRow = FilteredTable.this.rowAtPoint(viewport.getViewPosition());
            int visibleRows = viewport.getExtentSize().height / FilteredTable.this.getRowHeight();
            return row >= topRow && row <= topRow + visibleRows;
        }
    }

    private final class FilteredTableMouseListener
    extends MouseAdapter {
        private FilteredTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (FilteredTable.this.doubleClickAction.isNotNull()) {
                    ((Action)FilteredTable.this.doubleClickAction.get()).actionPerformed(new ActionEvent(this, 1001, "doubleClick"));
                }
                FilteredTable.this.doubleClickEvent.accept((Object)e);
            }
        }
    }

    private final class MoveResizeColumnKeyListener
    extends KeyAdapter {
        private MoveResizeColumnKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() && e.isShiftDown() && (e.getKeyCode() == 37 || e.getKeyCode() == 39)) {
                this.moveSelectedColumn(e.getKeyCode() == 37);
                e.consume();
            } else if (e.isControlDown() && RESIZE_KEYS.contains(e.getKeyCode())) {
                this.resizeSelectedColumn(e.getKeyCode() == 521 || e.getKeyCode() == 107);
                e.consume();
            }
        }

        private void moveSelectedColumn(boolean left) {
            int selectedColumnIndex = FilteredTable.this.getSelectedColumn();
            if (selectedColumnIndex != -1) {
                int columnCount = FilteredTable.this.getColumnModel().getColumnCount();
                int newIndex = left ? (selectedColumnIndex == 0 ? columnCount - 1 : selectedColumnIndex - 1) : (selectedColumnIndex == columnCount - 1 ? 0 : selectedColumnIndex + 1);
                FilteredTable.this.moveColumn(selectedColumnIndex, newIndex);
                FilteredTable.this.scrollRectToVisible(FilteredTable.this.getCellRect(FilteredTable.this.getSelectedRow(), newIndex, true));
            }
        }

        private void resizeSelectedColumn(boolean enlarge) {
            int selectedColumnIndex = FilteredTable.this.getSelectedColumn();
            if (selectedColumnIndex != -1) {
                FilteredTableColumn column = FilteredTable.this.getColumnModel().getColumn(selectedColumnIndex);
                FilteredTable.this.tableHeader.setResizingColumn((TableColumn)column);
                column.setWidth(column.getWidth() + (enlarge ? 10 : -10));
            }
        }
    }

    public static enum KeyboardShortcut {
        COPY_CELL,
        TOGGLE_SORT_COLUMN,
        TOGGLE_SORT_COLUMN_ADD;

    }

    private static final class DefaultFilteredTableCellRendererFactory<R, C>
    implements FilteredTableCellRendererFactory<C> {
        private final FilteredTableModel<R, C> tableModel;

        private DefaultFilteredTableCellRendererFactory(FilteredTableModel<R, C> tableModel) {
            this.tableModel = tableModel;
        }

        @Override
        public TableCellRenderer tableCellRenderer(FilteredTableColumn<C> column) {
            return FilteredTableCellRenderer.builder(this.tableModel, column.getIdentifier(), column.columnClass()).build();
        }
    }

    private static final class DefaultFilterPanelFactory<C>
    implements ColumnConditionPanel.Factory<C> {
        private DefaultFilterPanelFactory() {
        }

        @Override
        public <T> Optional<ColumnConditionPanel<C, T>> createConditionPanel(ColumnConditionModel<C, T> filterModel) {
            return ColumnConditionPanel.columnConditionPanel(filterModel);
        }
    }

    public static interface Builder<R, C>
    extends ComponentBuilder<Void, FilteredTable<R, C>, Builder<R, C>> {
        public Builder<R, C> filterPanelFactory(ColumnConditionPanel.Factory<C> var1);

        public Builder<R, C> cellRendererFactory(FilteredTableCellRendererFactory<C> var1);

        public Builder<R, C> autoStartsEdit(boolean var1);

        public Builder<R, C> centerOnScroll(CenterOnScroll var1);

        public Builder<R, C> doubleClickAction(Action var1);

        public Builder<R, C> scrollToSelectedItem(boolean var1);

        public Builder<R, C> sortingEnabled(boolean var1);

        public Builder<R, C> selectionMode(int var1);

        public Builder<R, C> columnReorderingAllowed(boolean var1);

        public Builder<R, C> columnResizingAllowed(boolean var1);

        public Builder<R, C> autoResizeMode(int var1);
    }
}

