/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.layout.FlexibleGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;

public final class FilteredTableColumnComponentPanel<C, T extends JComponent>
extends JPanel {
    private final FilteredTableColumnModel<C> columnModel;
    private final Collection<FilteredTableColumn<C>> columns;
    private final Box.Filler scrollBarFiller;
    private final JPanel basePanel;
    private final Map<C, T> components;
    private final Map<C, JPanel> nullComponents = new HashMap<C, JPanel>(0);

    private FilteredTableColumnComponentPanel(FilteredTableColumnModel<C> columnModel, Map<C, T> components) {
        this.columnModel = Objects.requireNonNull(columnModel);
        this.columns = columnModel.columns();
        Objects.requireNonNull(components).forEach((columnIdentifier, component) -> {
            if (!columnModel.containsColumn(columnIdentifier)) {
                throw new IllegalArgumentException("Column " + columnIdentifier + " is not part of column model");
            }
        });
        this.components = Collections.unmodifiableMap(components);
        this.basePanel = new JPanel(FlexibleGridLayout.builder().rows(1).build());
        Dimension fillerSize = new Dimension(UIManager.getInt("ScrollBar.width"), 0);
        this.scrollBarFiller = new Box.Filler(fillerSize, fillerSize, fillerSize);
        this.setLayout(new BorderLayout());
        this.add((Component)this.basePanel, "West");
        this.bindColumnAndComponentSizes();
        this.resetPanel();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI(this.scrollBarFiller, this.basePanel);
        if (this.components != null) {
            Utilities.updateUI(this.components.values());
        }
        if (this.nullComponents != null) {
            Utilities.updateUI(this.nullComponents.values());
        }
    }

    public Map<C, T> components() {
        return this.components;
    }

    public static <C, T extends JComponent> FilteredTableColumnComponentPanel<C, T> filteredTableColumnComponentPanel(FilteredTableColumnModel<C> columnModel, Map<C, T> columnComponents) {
        return new FilteredTableColumnComponentPanel<C, T>(columnModel, columnComponents);
    }

    private void resetPanel() {
        Component childFocusOwner = this.childFocusOwner();
        if (childFocusOwner != null) {
            this.basePanel.requestFocusInWindow();
        }
        this.basePanel.removeAll();
        this.columnModel.visible().stream().map(this::columnComponent).forEach(this.basePanel::add);
        this.basePanel.add(this.scrollBarFiller);
        this.syncPanelWidths();
        this.repaint();
        if (childFocusOwner != null && childFocusOwner.isShowing()) {
            childFocusOwner.requestFocusInWindow();
        }
    }

    private Component childFocusOwner() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (Utilities.parentOfType(FilteredTableColumnComponentPanel.class, focusOwner) == this) {
            return focusOwner;
        }
        return null;
    }

    private void bindColumnAndComponentSizes() {
        this.columnModel.addColumnModelListener((TableColumnModelListener)new SyncColumnModelListener());
        for (FilteredTableColumn<C> column : this.columns) {
            JComponent component = this.columnComponent(column);
            component.setPreferredSize(new Dimension(column.getWidth(), component.getPreferredSize().height));
            column.addPropertyChangeListener((PropertyChangeListener)new SyncListener(component, (TableColumn)column));
        }
    }

    private void syncPanelWidths() {
        for (FilteredTableColumn<C> column : this.columns) {
            FilteredTableColumnComponentPanel.syncPanelWidth(this.columnComponent(column), column);
        }
    }

    private JComponent columnComponent(FilteredTableColumn<C> column) {
        return this.components.getOrDefault(column.getIdentifier(), (JComponent)this.nullComponents.computeIfAbsent(column.getIdentifier(), c -> new JPanel()));
    }

    private static void syncPanelWidth(JComponent component, TableColumn column) {
        component.setPreferredSize(new Dimension(column.getWidth(), component.getPreferredSize().height));
        component.revalidate();
    }

    private final class SyncColumnModelListener
    implements TableColumnModelListener {
        private SyncColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            FilteredTableColumnComponentPanel.this.resetPanel();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            FilteredTableColumnComponentPanel.this.resetPanel();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() != e.getToIndex()) {
                FilteredTableColumnComponentPanel.this.resetPanel();
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private static final class SyncListener
    implements PropertyChangeListener {
        private final JComponent component;
        private final TableColumn column;

        private SyncListener(JComponent component, TableColumn column) {
            this.component = component;
            this.column = column;
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            if ("width".equals(changeEvent.getPropertyName())) {
                FilteredTableColumnComponentPanel.syncPanelWidth(this.component, this.column);
            }
        }
    }
}

