/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.i18n.Messages;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.state.State;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilteredTableColumnComponentPanel;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JPanel;

public final class FilteredTableConditionPanel<C>
extends JPanel {
    private final TableConditionModel<C> conditionModel;
    private final FilteredTableColumnComponentPanel<C, ColumnConditionPanel<C, ?>> componentPanel;
    private final State advanced = State.state();

    private FilteredTableConditionPanel(TableConditionModel<C> conditionModel, FilteredTableColumnModel<C> columnModel, ColumnConditionPanel.Factory<C> conditionPanelFactory) {
        this.conditionModel = Objects.requireNonNull(conditionModel);
        this.componentPanel = FilteredTableColumnComponentPanel.filteredTableColumnComponentPanel(Objects.requireNonNull(columnModel), this.createConditionPanels(columnModel, Objects.requireNonNull(conditionPanelFactory)));
        this.setLayout(new BorderLayout());
        this.add(this.componentPanel, "Center");
        this.advanced.addDataListener(this::onAdvancedChanged);
    }

    public Collection<ColumnConditionPanel<C, ?>> conditionPanels() {
        return this.componentPanel.components().values();
    }

    public State advanced() {
        return this.advanced;
    }

    public <T> Optional<ColumnConditionPanel<C, T>> conditionPanel(C columnIdentifier) {
        return Optional.ofNullable(this.componentPanel.components().get(Objects.requireNonNull(columnIdentifier)));
    }

    public Controls controls() {
        return (Controls)Controls.builder().control((Control.Builder<?, ?>)ToggleControl.builder(this.advanced).name(Messages.advanced())).control((Control.Builder<?, ?>)Control.builder(this::clearConditions).name(Messages.clear())).build();
    }

    public void addFocusGainedListener(Consumer<C> listener) {
        this.componentPanel.components().values().forEach(panel -> panel.addFocusGainedListener(listener));
    }

    public static <C> FilteredTableConditionPanel<C> filteredTableConditionPanel(TableConditionModel<C> conditionModel, FilteredTableColumnModel<C> columnModel, ColumnConditionPanel.Factory<C> conditionPanelFactory) {
        return new FilteredTableConditionPanel<C>(conditionModel, columnModel, conditionPanelFactory);
    }

    private void clearConditions() {
        this.componentPanel.components().values().stream().map(ColumnConditionPanel::model).forEach(ColumnConditionModel::clear);
    }

    private void onAdvancedChanged(boolean advancedView) {
        this.componentPanel.components().forEach((column, panel) -> panel.advanced().set((Object)advancedView));
    }

    private Map<C, ColumnConditionPanel<C, ?>> createConditionPanels(FilteredTableColumnModel<C> columnModel, ColumnConditionPanel.Factory<C> conditionPanelFactory) {
        return columnModel.columns().stream().map(column -> (ColumnConditionModel)this.conditionModel.conditionModels().get(column.getIdentifier())).filter(Objects::nonNull).map(conditionPanelFactory::createConditionPanel).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(conditionPanel -> conditionPanel.model().columnIdentifier(), Function.identity()));
    }
}

