/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.swing.common.ui.component.text.DefaultParseResult;
import is.codion.swing.common.ui.component.text.Parser;
import is.codion.swing.common.ui.component.text.ValidationDocumentFilter;
import java.util.Objects;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class ParsingDocumentFilter<T>
extends ValidationDocumentFilter<T> {
    static final Parser<String> STRING_PARSER = new StringParser();
    private final Parser<T> parser;

    public ParsingDocumentFilter(Parser<T> parser) {
        this.parser = Objects.requireNonNull(parser, "parser");
    }

    @Override
    public final void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String string, AttributeSet attributeSet) throws BadLocationException {
        String transformedString = this.transform(string);
        transformedString = transformedString == null ? "" : transformedString;
        Document document = filterBypass.getDocument();
        StringBuilder builder = new StringBuilder(document.getText(0, document.getLength()));
        builder.insert(offset, transformedString);
        Parser.ParseResult<T> parseResult = this.parser.parse(builder.toString());
        if (parseResult.successful()) {
            if (parseResult.value() != null) {
                this.validate(parseResult.value());
            }
            super.insertString(filterBypass, offset, transformedString, attributeSet);
        }
    }

    @Override
    public final void remove(DocumentFilter.FilterBypass filterBypass, int offset, int length) throws BadLocationException {
        Document document = filterBypass.getDocument();
        StringBuilder builder = new StringBuilder(document.getText(0, document.getLength()));
        builder.replace(offset, offset + length, "");
        Parser.ParseResult<T> parseResult = this.parser.parse(builder.toString());
        if (parseResult.successful()) {
            if (parseResult.value() != null) {
                this.validate(parseResult.value());
            }
            super.remove(filterBypass, offset, length);
        }
    }

    @Override
    public final void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String string, AttributeSet attributeSet) throws BadLocationException {
        String transformedString = this.transform(string);
        transformedString = transformedString == null ? "" : transformedString;
        Document document = filterBypass.getDocument();
        StringBuilder builder = new StringBuilder(document.getText(0, document.getLength()));
        builder.replace(offset, offset + length, transformedString);
        Parser.ParseResult<T> parseResult = this.parser.parse(builder.toString());
        if (parseResult.successful()) {
            if (parseResult.value() != null) {
                this.validate(parseResult.value());
            }
            super.replace(filterBypass, offset, length, transformedString, attributeSet);
        }
    }

    protected String transform(String string) {
        return string;
    }

    private static final class StringParser
    implements Parser<String> {
        private StringParser() {
        }

        @Override
        public Parser.ParseResult<String> parse(String text) {
            return new DefaultParseResult<String>(text, text, true);
        }
    }
}

