/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.text.DocumentAdapter;
import is.codion.swing.common.ui.component.calendar.CalendarPanel;
import is.codion.swing.common.ui.component.text.DefaultTextFieldBuilder;
import is.codion.swing.common.ui.component.text.MaskFormatterBuilder;
import is.codion.swing.common.ui.component.text.TemporalFieldValue;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.CalendarDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;

public final class TemporalField<T extends Temporal>
extends JFormattedTextField {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(TemporalField.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, TemporalField::defaultKeyStroke);
    private static final char DAY = 'd';
    private static final char MONTH = 'M';
    private static final char YEAR = 'y';
    private static final char HOUR = 'H';
    private static final char MINUTE = 'm';
    private static final char SECOND = 's';
    private final Class<T> temporalClass;
    private final DateTimeFormatter formatter;
    private final DateTimeParser<T> dateTimeParser;
    private final Value<T> value = Value.value();
    private final State valueNull = State.state();
    private final String dateTimePattern;
    private final ImageIcon calendarIcon;
    private final Control calendarControl;

    private TemporalField(DefaultBuilder<T> builder) {
        super(TemporalField.createFormatter(builder.mask));
        this.setToolTipText(builder.dateTimePattern);
        this.temporalClass = builder.temporalClass;
        this.formatter = builder.dateTimeFormatter;
        this.dateTimeParser = builder.dateTimeParser;
        this.dateTimePattern = builder.dateTimePattern;
        this.calendarIcon = builder.calendarIcon;
        this.setFocusLostBehavior(builder.focusLostBehaviour);
        this.getDocument().addDocumentListener((DocumentListener)((Object)new TemporalDocumentListener()));
        if (builder.incrementDecrementEnabled) {
            KeyEvents.builder((KeyStroke)builder.keyboardShortcuts.keyStroke(KeyboardShortcut.INCREMENT).get()).action((Action)Control.builder(this::increment).enabled(this.valueNull.not()).build()).enable(this);
            KeyEvents.builder((KeyStroke)builder.keyboardShortcuts.keyStroke(KeyboardShortcut.DECREMENT).get()).action((Action)Control.builder(this::decrement).enabled(this.valueNull.not()).build()).enable(this);
        }
        this.calendarControl = this.createCalendarControl();
        if (this.calendarControl != null) {
            KeyEvents.builder((KeyStroke)builder.keyboardShortcuts.keyStroke(KeyboardShortcut.DISPLAY_CALENDAR).get()).action(this.calendarControl).enable(this);
        }
    }

    public Optional<Control> calendarControl() {
        return Optional.ofNullable(this.calendarControl);
    }

    public Class<T> temporalClass() {
        return this.temporalClass;
    }

    public Optional<T> optional() {
        return Optional.ofNullable(this.getTemporal());
    }

    public T getTemporal() {
        try {
            return this.dateTimeParser.parse(this.getText(), this.formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public void setTemporal(Temporal temporal) {
        this.setText(temporal == null ? "" : this.formatter.format(temporal));
    }

    public void addListener(Consumer<T> listener) {
        this.value.addDataListener(listener);
    }

    public static <T extends Temporal> Builder<T> builder(Class<T> temporalClass, String dateTimePattern) {
        return new DefaultBuilder<T>(temporalClass, dateTimePattern, null);
    }

    public static <T extends Temporal> Builder<T> builder(Class<T> temporalClass, String dateTimePattern, Value<T> linkedValue) {
        return new DefaultBuilder<T>(temporalClass, dateTimePattern, Objects.requireNonNull(linkedValue));
    }

    private void increment() {
        this.increment(1);
    }

    private void decrement() {
        this.increment(-1);
    }

    private void increment(int amount) {
        char patternCharacter;
        ChronoUnit chronoUnit;
        int caretPosition = this.getCaretPosition();
        T temporal = this.getTemporal();
        if (temporal != null && caretPosition <= this.dateTimePattern.length() && (chronoUnit = TemporalField.chronoUnit(patternCharacter = caretPosition == this.dateTimePattern.length() ? this.dateTimePattern.charAt(this.dateTimePattern.length() - 1) : this.dateTimePattern.charAt(caretPosition))) != null) {
            this.setTemporal(temporal.plus(amount, chronoUnit));
            this.setCaretPosition(caretPosition);
        }
    }

    private static ChronoUnit chronoUnit(char patternCharacter) {
        switch (patternCharacter) {
            case 'd': {
                return ChronoUnit.DAYS;
            }
            case 'M': {
                return ChronoUnit.MONTHS;
            }
            case 'y': {
                return ChronoUnit.YEARS;
            }
            case 'H': {
                return ChronoUnit.HOURS;
            }
            case 'm': {
                return ChronoUnit.MINUTES;
            }
            case 's': {
                return ChronoUnit.SECONDS;
            }
        }
        return null;
    }

    private Control createCalendarControl() {
        if (CalendarPanel.supportedTypes().contains(this.temporalClass)) {
            return Control.builder(this::displayCalendar).name(this.calendarIcon == null ? "..." : null).smallIcon(this.calendarIcon).description(MESSAGES.getString("display_calendar")).enabled(this.calendarEnabledState()).build();
        }
        return null;
    }

    private StateObserver calendarEnabledState() {
        State enabledState = State.state((boolean)this.isEnabled());
        this.addPropertyChangeListener("enabled", event -> enabledState.set((Object)((Boolean)event.getNewValue())));
        return enabledState.observer();
    }

    private void displayCalendar() {
        if (LocalDate.class.equals(this.temporalClass())) {
            ((CalendarDialogBuilder)((CalendarDialogBuilder)Dialogs.calendarDialog().owner(this)).icon(this.calendarIcon)).initialValue((LocalDate)this.getTemporal()).selectLocalDate().ifPresent(this::setTemporal);
        } else if (LocalDateTime.class.equals(this.temporalClass())) {
            ((CalendarDialogBuilder)((CalendarDialogBuilder)Dialogs.calendarDialog().owner(this)).icon(this.calendarIcon)).initialValue((LocalDateTime)this.getTemporal()).selectLocalDateTime().ifPresent(this::setTemporal);
        } else {
            throw new IllegalArgumentException("Unsupported temporal type: " + this.temporalClass());
        }
    }

    private static MaskFormatter createFormatter(String mask) {
        try {
            return MaskFormatterBuilder.builder().mask(mask).placeholderCharacter('_').valueContainsLiteralCharacters(true).commitsOnValidEdit(true).build();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        switch (shortcut) {
            case DISPLAY_CALENDAR: {
                return KeyboardShortcuts.keyStroke(155);
            }
            case INCREMENT: {
                return KeyboardShortcuts.keyStroke(38);
            }
            case DECREMENT: {
                return KeyboardShortcuts.keyStroke(40);
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class DefaultBuilder<T extends Temporal>
    extends DefaultTextFieldBuilder<T, TemporalField<T>, Builder<T>>
    implements Builder<T> {
        private final Class<T> temporalClass;
        private final String dateTimePattern;
        private final String mask;
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private DateTimeFormatter dateTimeFormatter;
        private DateTimeParser<T> dateTimeParser;
        private int focusLostBehaviour = 0;
        private ImageIcon calendarIcon;
        private boolean incrementDecrementEnabled = true;

        private DefaultBuilder(Class<T> temporalClass, String dateTimePattern, Value<T> linkedValue) {
            super(temporalClass, linkedValue);
            this.temporalClass = temporalClass;
            this.dateTimePattern = Objects.requireNonNull(dateTimePattern);
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern).withZone(ZoneId.systemDefault());
            this.mask = DefaultBuilder.createMask(dateTimePattern);
            this.dateTimeParser = DefaultBuilder.createDateTimeParser(temporalClass);
        }

        @Override
        public Builder<T> dateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = Objects.requireNonNull(dateTimeFormatter);
            return this;
        }

        @Override
        public Builder<T> dateTimeParser(DateTimeParser<T> dateTimeParser) {
            this.dateTimeParser = Objects.requireNonNull(dateTimeParser);
            return this;
        }

        @Override
        public Builder<T> focusLostBehaviour(int focusLostBehaviour) {
            this.focusLostBehaviour = focusLostBehaviour;
            return this;
        }

        @Override
        public Builder<T> calendarIcon(ImageIcon calendarIcon) {
            this.calendarIcon = calendarIcon;
            return this;
        }

        @Override
        public Builder<T> incrementDecrementEnabled(boolean incrementDecrementEnabled) {
            this.incrementDecrementEnabled = incrementDecrementEnabled;
            return this;
        }

        @Override
        public Builder<T> keyStroke(KeyboardShortcut keyboardShortcut, KeyStroke keyStroke) {
            this.keyboardShortcuts.keyStroke(keyboardShortcut).set((Object)keyStroke);
            return this;
        }

        @Override
        protected TemporalField<T> createTextField() {
            if (this.dateTimeParser == null) {
                throw new IllegalStateException("dateTimeParser must be specified");
            }
            return new TemporalField(this);
        }

        @Override
        protected ComponentValue<T, TemporalField<T>> createComponentValue(TemporalField<T> component) {
            return new TemporalFieldValue<T>(component, this.updateOn);
        }

        @Override
        protected void setInitialValue(TemporalField<T> component, T initialValue) {
            component.setTemporal((Temporal)initialValue);
        }

        private static <T extends Temporal> DateTimeParser<T> createDateTimeParser(Class<T> valueClass) {
            if (valueClass.equals(LocalTime.class)) {
                return new LocalTimeParser();
            }
            if (valueClass.equals(LocalDate.class)) {
                return new LocalDateParser();
            }
            if (valueClass.equals(LocalDateTime.class)) {
                return new LocalDateTimeParser();
            }
            if (valueClass.equals(OffsetDateTime.class)) {
                return new OffsetDateTimeParser();
            }
            return null;
        }

        private static String createMask(String dateTimePattern) {
            Objects.requireNonNull(dateTimePattern, "dateTimePattern");
            StringBuilder stringBuilder = new StringBuilder(dateTimePattern.length());
            char[] cArray = dateTimePattern.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character character = Character.valueOf(cArray[i]);
                stringBuilder.append(Character.isLetter(character.charValue()) ? "#" : character);
            }
            return stringBuilder.toString();
        }
    }

    public static interface DateTimeParser<T extends Temporal> {
        public T parse(CharSequence var1, DateTimeFormatter var2);
    }

    private final class TemporalDocumentListener
    implements DocumentAdapter {
        private TemporalDocumentListener() {
        }

        public void contentsChanged(DocumentEvent e) {
            Object temporal = TemporalField.this.getTemporal();
            if (temporal != null || e.getType() == DocumentEvent.EventType.INSERT) {
                TemporalField.this.value.set(temporal);
                TemporalField.this.valueNull.set((Object)(temporal == null ? 1 : 0));
            }
        }
    }

    public static enum KeyboardShortcut {
        DISPLAY_CALENDAR,
        INCREMENT,
        DECREMENT;

    }

    private static final class OffsetDateTimeParser
    implements DateTimeParser<OffsetDateTime> {
        private OffsetDateTimeParser() {
        }

        @Override
        public OffsetDateTime parse(CharSequence text, DateTimeFormatter formatter) {
            try {
                return OffsetDateTime.parse(text, formatter);
            }
            catch (DateTimeException e) {
                ZoneId zone = formatter.getZone();
                if (zone == null) {
                    zone = ZoneId.systemDefault();
                }
                return LocalDateTime.parse(text, formatter).atZone(zone).toOffsetDateTime();
            }
        }
    }

    private static final class LocalDateTimeParser
    implements DateTimeParser<LocalDateTime> {
        private LocalDateTimeParser() {
        }

        @Override
        public LocalDateTime parse(CharSequence text, DateTimeFormatter formatter) {
            return LocalDateTime.parse(text, formatter);
        }
    }

    private static final class LocalDateParser
    implements DateTimeParser<LocalDate> {
        private LocalDateParser() {
        }

        @Override
        public LocalDate parse(CharSequence text, DateTimeFormatter formatter) {
            return LocalDate.parse(text, formatter);
        }
    }

    private static final class LocalTimeParser
    implements DateTimeParser<LocalTime> {
        private LocalTimeParser() {
        }

        @Override
        public LocalTime parse(CharSequence text, DateTimeFormatter formatter) {
            return LocalTime.parse(text, formatter);
        }
    }

    public static interface Builder<T extends Temporal>
    extends TextFieldBuilder<T, TemporalField<T>, Builder<T>> {
        public Builder<T> dateTimeFormatter(DateTimeFormatter var1);

        public Builder<T> dateTimeParser(DateTimeParser<T> var1);

        public Builder<T> focusLostBehaviour(int var1);

        public Builder<T> calendarIcon(ImageIcon var1);

        public Builder<T> incrementDecrementEnabled(boolean var1);

        public Builder<T> keyStroke(KeyboardShortcut var1, KeyStroke var2);
    }
}

