/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.value;

import is.codion.common.value.AbstractValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractComponentValue<T, C extends JComponent>
extends AbstractValue<T>
implements ComponentValue<T, C> {
    private final C component;

    protected AbstractComponentValue(C component) {
        this(component, null);
    }

    protected AbstractComponentValue(C component, T nullValue) {
        super(nullValue);
        this.component = (JComponent)Objects.requireNonNull(component, "component");
    }

    public final T get() {
        return this.getComponentValue();
    }

    @Override
    public final C component() {
        return this.component;
    }

    protected final void setValue(T value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setComponentValue(value);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> this.setComponentValue(value));
        }
        catch (Exception ex) {
            AbstractComponentValue.handleInvokeAndWaitException(ex);
        }
    }

    protected abstract T getComponentValue();

    protected abstract void setComponentValue(T var1);

    private static void handleInvokeAndWaitException(Exception exception) {
        Throwable cause = exception;
        if (exception instanceof InvocationTargetException) {
            cause = exception.getCause();
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }
}

