/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.control.AbstractControl;
import is.codion.swing.common.ui.control.Controls;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;

final class DefaultControls
extends AbstractControl
implements Controls {
    private static final String CONTROLS_PARAMETER = "controls";
    private final List<Action> actions = new ArrayList<Action>();

    DefaultControls(String name, StateObserver enabledState, List<Action> controls) {
        super(name, enabledState);
        for (Action control : controls) {
            if (control == SEPARATOR) {
                this.addSeparator();
                continue;
            }
            this.add(control);
        }
    }

    @Override
    public List<Action> actions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public Controls add(Action action) {
        this.actions.add(Objects.requireNonNull(action, "action"));
        return this;
    }

    @Override
    public Controls addAt(int index, Action action) {
        this.actions.add(index, Objects.requireNonNull(action, "action"));
        return this;
    }

    @Override
    public Controls remove(Action action) {
        this.actions.remove(action);
        return this;
    }

    @Override
    public Controls removeAll() {
        this.actions.clear();
        return this;
    }

    @Override
    public int size() {
        return this.actions.size();
    }

    @Override
    public boolean empty() {
        return this.actions.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return !this.empty();
    }

    @Override
    public Action get(int index) {
        return this.actions.get(index);
    }

    @Override
    public Controls add(Controls controls) {
        this.actions.add(Objects.requireNonNull(controls, CONTROLS_PARAMETER));
        return this;
    }

    @Override
    public Controls addAt(int index, Controls controls) {
        this.actions.add(index, Objects.requireNonNull(controls, CONTROLS_PARAMETER));
        return this;
    }

    @Override
    public Controls addSeparator() {
        this.actions.add(SEPARATOR);
        return this;
    }

    @Override
    public Controls addSeparatorAt(int index) {
        this.actions.add(index, SEPARATOR);
        return this;
    }

    @Override
    public Controls addAll(Controls controls) {
        this.actions.addAll(Objects.requireNonNull(controls, CONTROLS_PARAMETER).actions());
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    static final class DefaultSeparator
    implements Action {
        private static final String CONTROLS_SEPARATOR = "Separator";

        DefaultSeparator() {
        }

        @Override
        public Object getValue(String key) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void setEnabled(boolean b) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }
    }
}

