/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.NullOrEmpty;
import is.codion.common.model.CancelException;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultSelectionDialogBuilder;
import is.codion.swing.common.ui.dialog.FileSelectionDialogBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

final class DefaultFileSelectionDialogBuilder
extends AbstractDialogBuilder<FileSelectionDialogBuilder>
implements FileSelectionDialogBuilder {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(DefaultFileSelectionDialogBuilder.class.getName());
    private static JFileChooser fileChooserOpen;
    private static JFileChooser fileChooserSave;
    private final List<FileFilter> fileFilters = new ArrayList<FileFilter>();
    private String startDirectory;
    private boolean confirmOverwrite = true;
    private boolean selectStartDirectory = false;

    DefaultFileSelectionDialogBuilder() {
    }

    @Override
    public FileSelectionDialogBuilder startDirectory(String startDirectory) {
        this.startDirectory = startDirectory;
        return this;
    }

    @Override
    public FileSelectionDialogBuilder selectStartDirectory(boolean selectStartDirectory) {
        this.selectStartDirectory = selectStartDirectory;
        return this;
    }

    @Override
    public FileSelectionDialogBuilder confirmOverwrite(boolean confirmOverwrite) {
        this.confirmOverwrite = confirmOverwrite;
        return this;
    }

    @Override
    public FileSelectionDialogBuilder fileFilter(FileFilter fileFilter) {
        this.fileFilters.add(Objects.requireNonNull(fileFilter));
        return this;
    }

    @Override
    public File selectFile() {
        return this.selectFile(MESSAGES.getString("select_file"));
    }

    @Override
    public List<File> selectFiles() {
        return this.selectFilesOrDirectories(FilesOrDirectories.FILES, MESSAGES.getString("select_files"), false);
    }

    @Override
    public File selectDirectory() {
        return this.selectDirectory(MESSAGES.getString("select_directory"));
    }

    @Override
    public List<File> selectDirectories() {
        return this.selectFilesOrDirectories(FilesOrDirectories.DIRECTORIES, MESSAGES.getString("select_directories"), false);
    }

    @Override
    public File selectFileOrDirectory() {
        return this.selectFileOrDirectory(FilesOrDirectories.BOTH, MESSAGES.getString("select_file_or_directory"));
    }

    @Override
    public List<File> selectFilesOrDirectories() {
        return this.selectFilesOrDirectories(FilesOrDirectories.BOTH, MESSAGES.getString("select_files_or_directories"), false);
    }

    @Override
    public File selectFileToSave() {
        return this.selectFileToSave(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File selectFileToSave(String defaultFileName) {
        Class<DefaultSelectionDialogBuilder> clazz = DefaultSelectionDialogBuilder.class;
        synchronized (DefaultSelectionDialogBuilder.class) {
            if (fileChooserSave == null) {
                if (this.owner != null) {
                    this.owner.setCursor(Cursors.WAIT);
                }
                try {
                    fileChooserSave = new JFileChooser();
                }
                finally {
                    if (this.owner != null) {
                        this.owner.setCursor(Cursors.DEFAULT);
                    }
                }
            }
            fileChooserSave.setSelectedFiles(new File[]{new File("")});
            fileChooserSave.setFileSelectionMode(0);
            fileChooserSave.removeChoosableFileFilter(fileChooserSave.getFileFilter());
            fileChooserSave.setMultiSelectionEnabled(false);
            File startDirectory = !NullOrEmpty.nullOrEmpty((String)this.startDirectory) && new File(this.startDirectory).exists() ? new File(this.startDirectory) : fileChooserSave.getCurrentDirectory();
            File selectedFile = new File(startDirectory.getAbsolutePath() + (String)(defaultFileName != null ? File.separator + defaultFileName : ""));
            boolean fileChosen = false;
            while (!fileChosen) {
                if (selectedFile.isDirectory()) {
                    fileChooserSave.setCurrentDirectory(selectedFile);
                } else {
                    fileChooserSave.setSelectedFile(selectedFile);
                }
                int option = fileChooserSave.showSaveDialog(this.owner);
                if (option == 0) {
                    selectedFile = fileChooserSave.getSelectedFile();
                    if (selectedFile.exists() && this.confirmOverwrite) {
                        option = JOptionPane.showConfirmDialog(this.owner, MESSAGES.getString("overwrite_file"), MESSAGES.getString("file_exists"), 1);
                        if (option == 0) {
                            fileChosen = true;
                            continue;
                        }
                        if (option != 2) continue;
                        throw new CancelException();
                    }
                    fileChosen = true;
                    continue;
                }
                throw new CancelException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return selectedFile;
        }
    }

    private File selectDirectory(String defaultDialogTitle) {
        return this.selectFileOrDirectory(FilesOrDirectories.DIRECTORIES, defaultDialogTitle);
    }

    private File selectFile(String defaultDialogTitle) {
        return this.selectFileOrDirectory(FilesOrDirectories.FILES, defaultDialogTitle);
    }

    private File selectFileOrDirectory(FilesOrDirectories filesOrDirectories, String defaultDialogTitle) {
        return this.selectFilesOrDirectories(filesOrDirectories, defaultDialogTitle, false).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> selectFilesOrDirectories(FilesOrDirectories filesOrDirectories, String defaultDialogTitle, boolean singleSelection) {
        Class<DefaultSelectionDialogBuilder> clazz = DefaultSelectionDialogBuilder.class;
        synchronized (DefaultSelectionDialogBuilder.class) {
            List<File> selectedFiles;
            int option;
            String dialogTitle;
            if (fileChooserOpen == null) {
                if (this.owner != null) {
                    this.owner.setCursor(Cursors.WAIT);
                }
                try {
                    fileChooserOpen = new JFileChooser(new File(this.startDirectory == null ? System.getProperty("user.home") : this.startDirectory));
                }
                finally {
                    if (this.owner != null) {
                        this.owner.setCursor(Cursors.DEFAULT);
                    }
                }
            }
            switch (filesOrDirectories) {
                case FILES: {
                    fileChooserOpen.setFileSelectionMode(0);
                    break;
                }
                case DIRECTORIES: {
                    fileChooserOpen.setFileSelectionMode(1);
                    break;
                }
                case BOTH: {
                    fileChooserOpen.setFileSelectionMode(2);
                }
            }
            fileChooserOpen.setSelectedFiles(new File[]{this.initialSelection(filesOrDirectories)});
            fileChooserOpen.resetChoosableFileFilters();
            if (!this.fileFilters.isEmpty()) {
                fileChooserOpen.removeChoosableFileFilter(fileChooserOpen.getFileFilter());
            }
            this.fileFilters.forEach(fileChooserOpen::addChoosableFileFilter);
            fileChooserOpen.setMultiSelectionEnabled(!singleSelection);
            if (!NullOrEmpty.nullOrEmpty((String)this.startDirectory) && new File(this.startDirectory).exists()) {
                fileChooserOpen.setCurrentDirectory(new File(this.startDirectory));
            }
            String string = dialogTitle = this.titleProvider == null ? defaultDialogTitle : (String)this.titleProvider.get();
            if (dialogTitle != null) {
                fileChooserOpen.setDialogTitle(dialogTitle);
            }
            if ((option = fileChooserOpen.showOpenDialog(this.owner)) == 0 && !(selectedFiles = singleSelection ? Collections.singletonList(fileChooserOpen.getSelectedFile()) : Arrays.asList(fileChooserOpen.getSelectedFiles())).isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return selectedFiles;
            }
            throw new CancelException();
        }
    }

    private File initialSelection(FilesOrDirectories filesOrDirectories) {
        if (filesOrDirectories == FilesOrDirectories.DIRECTORIES && this.selectStartDirectory && !NullOrEmpty.nullOrEmpty((String)this.startDirectory)) {
            return new File(this.startDirectory);
        }
        return new File("");
    }

    static {
        UIManager.addPropertyChangeListener(new LookAndFeelChangeListener());
    }

    private static enum FilesOrDirectories {
        FILES,
        DIRECTORIES,
        BOTH;

    }

    private static final class LookAndFeelChangeListener
    implements PropertyChangeListener {
        private static final String LOOK_AND_FEEL_PROPERTY = "lookAndFeel";

        private LookAndFeelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (LOOK_AND_FEEL_PROPERTY.equals(evt.getPropertyName())) {
                if (fileChooserOpen != null) {
                    fileChooserOpen.updateUI();
                }
                if (fileChooserSave != null) {
                    fileChooserSave.updateUI();
                }
            }
        }
    }
}

