/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.state.State;
import is.codion.swing.common.ui.dialog.DisposeDialogAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;

final class DisposeDialogOnEscapeAction
extends AbstractAction {
    private final JDialog dialog;
    private final Consumer<State> confirmCloseListener;

    DisposeDialogOnEscapeAction(JDialog dialog, Consumer<State> confirmCloseListener) {
        super("DisposeDialogOnEscapeAction");
        this.dialog = dialog;
        this.confirmCloseListener = confirmCloseListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Window> heavyWeightWindows = Arrays.stream(this.dialog.getOwnedWindows()).filter(window -> window.getClass().getName().endsWith("Popup$HeavyWeightWindow") && window.isVisible()).collect(Collectors.toList());
        if (!heavyWeightWindows.isEmpty()) {
            heavyWeightWindows.forEach(Window::dispose);
            return;
        }
        List<JPopupMenu> popupMenus = DisposeDialogOnEscapeAction.componentsOfType(this.dialog.getContentPane(), JPopupMenu.class);
        if (popupMenus.isEmpty()) {
            DisposeDialogAction.closeIfConfirmed(this.dialog, this.confirmCloseListener);
        } else {
            popupMenus.forEach(popupMenu -> popupMenu.setVisible(false));
        }
    }

    static <T extends Component> List<T> componentsOfType(Container container, Class<T> clazz) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Component component : container.getComponents()) {
            if (clazz.isAssignableFrom(component.getClass())) {
                components.add(component);
            }
            if (!(component instanceof Container)) continue;
            components.addAll(DisposeDialogOnEscapeAction.componentsOfType((Container)component, clazz));
        }
        return components;
    }
}

