/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.key;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.KeyStroke;

final class DefaultKeyboardShortcuts<T extends Enum<T>>
implements KeyboardShortcuts<T> {
    private final Class<T> shortcutsClass;
    private final Map<T, Value<KeyStroke>> keyStrokes;

    DefaultKeyboardShortcuts(Class<T> shortcutsClass, Function<T, KeyStroke> defaultKeystrokes) {
        this(Objects.requireNonNull(shortcutsClass), Stream.of((Enum[])shortcutsClass.getEnumConstants()).collect(Collectors.toMap(Function.identity(), shortcutKey -> DefaultKeyboardShortcuts.keyStrokeValue(defaultKeystrokes, shortcutKey))));
    }

    private DefaultKeyboardShortcuts(Class<T> shortcutsClass, Map<T, Value<KeyStroke>> keyStrokes) {
        this.shortcutsClass = shortcutsClass;
        this.keyStrokes = keyStrokes;
    }

    @Override
    public Value<KeyStroke> keyStroke(T keyboardShortcut) {
        return this.keyStrokes.get(Objects.requireNonNull(keyboardShortcut));
    }

    @Override
    public KeyboardShortcuts<T> copy() {
        return new DefaultKeyboardShortcuts<Enum>(this.shortcutsClass, this.keyStrokes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Value.value((Object)((KeyStroke)((Value)entry.getValue()).get()), (Object)((KeyStroke)((Value)entry.getValue()).get())))));
    }

    private static <T extends Enum<T>> Value<KeyStroke> keyStrokeValue(Function<T, KeyStroke> defaultKeystrokes, T shortcutKey) {
        KeyStroke keyStroke = Objects.requireNonNull(defaultKeystrokes).apply(shortcutKey);
        if (keyStroke == null) {
            throw new IllegalStateException("No default keystroke provided for shortcut key: " + shortcutKey);
        }
        return Value.value((Object)keyStroke, (Object)keyStroke);
    }
}

