/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.button.ControlPanelBuilder;
import is.codion.swing.common.ui.component.button.RadioButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonType;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Controls;
import java.awt.Dimension;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.JComponent;

abstract class AbstractControlPanelBuilder<C extends JComponent, B extends ControlPanelBuilder<C, B>>
extends AbstractComponentBuilder<Void, C, B>
implements ControlPanelBuilder<C, B> {
    private final Controls.ControlsBuilder builder = Controls.builder();
    private final ButtonBuilder<?, ?, ?> buttonBuilder = ButtonBuilder.builder();
    private final ToggleButtonBuilder<?, ?> toggleButtonBuilder = ToggleButtonBuilder.builder();
    private final CheckBoxBuilder checkBoxBuilder = CheckBoxBuilder.builder();
    private final RadioButtonBuilder radioButtonBuilder = RadioButtonBuilder.builder();
    private int orientation = 0;
    private ToggleButtonType toggleButtonType = ToggleButtonType.BUTTON;

    protected AbstractControlPanelBuilder(Controls controls) {
        if (controls != null) {
            this.builder.actions(controls.actions());
        }
    }

    @Override
    public final B orientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("Unknown orientation value: " + orientation);
        }
        this.orientation = orientation;
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B action(Action action) {
        this.builder.action(Objects.requireNonNull(action));
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B controls(Controls controls) {
        this.builder.actions(Objects.requireNonNull(controls).actions());
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B separator() {
        this.builder.separator();
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B includeButtonText(boolean includeButtonText) {
        this.buttonBuilder.includeText(includeButtonText);
        this.toggleButtonBuilder.includeText(includeButtonText);
        this.checkBoxBuilder.includeText(includeButtonText);
        this.radioButtonBuilder.includeText(includeButtonText);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B preferredButtonSize(Dimension preferredButtonSize) {
        this.buttonBuilder.preferredSize(preferredButtonSize);
        this.toggleButtonBuilder.preferredSize(preferredButtonSize);
        this.checkBoxBuilder.preferredSize(preferredButtonSize);
        this.radioButtonBuilder.preferredSize(preferredButtonSize);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B buttonsFocusable(boolean buttonsFocusable) {
        this.buttonBuilder.focusable(buttonsFocusable);
        this.toggleButtonBuilder.focusable(buttonsFocusable);
        this.checkBoxBuilder.focusable(buttonsFocusable);
        this.radioButtonBuilder.focusable(buttonsFocusable);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B toggleButtonType(ToggleButtonType toggleButtonType) {
        this.toggleButtonType = Objects.requireNonNull(toggleButtonType);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B buttonBuilder(Consumer<ButtonBuilder<?, ?, ?>> buttonBuilder) {
        Objects.requireNonNull(buttonBuilder).accept(this.buttonBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B toggleButtonBuilder(Consumer<ToggleButtonBuilder<?, ?>> toggleButtonBuilder) {
        Objects.requireNonNull(toggleButtonBuilder).accept(this.toggleButtonBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B checkBoxBuilder(Consumer<CheckBoxBuilder> checkBoxBuilder) {
        Objects.requireNonNull(checkBoxBuilder).accept(this.checkBoxBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B radioButtonBuilder(Consumer<RadioButtonBuilder> radioButtonBuilder) {
        Objects.requireNonNull(radioButtonBuilder).accept(this.radioButtonBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    protected final ComponentValue<Void, C> createComponentValue(C component) {
        return new PanelComponentValue<C>(component);
    }

    @Override
    protected final void setInitialValue(C component, Void initialValue) {
    }

    protected final Controls controls() {
        return (Controls)this.builder.build();
    }

    protected final int orientation() {
        return this.orientation;
    }

    protected final ButtonBuilder<?, ?, ?> buttonBuilder() {
        return this.buttonBuilder;
    }

    protected final ToggleButtonBuilder<?, ?> toggleButtonBuilder() {
        switch (this.toggleButtonType) {
            case CHECKBOX: {
                return this.checkBoxBuilder;
            }
            case BUTTON: {
                return this.toggleButtonBuilder;
            }
            case RADIO_BUTTON: {
                return this.radioButtonBuilder;
            }
        }
        throw new IllegalArgumentException("Unknown toggle button type: " + this.toggleButtonType);
    }

    private static final class PanelComponentValue<C extends JComponent>
    extends AbstractComponentValue<Void, C> {
        private PanelComponentValue(C component) {
            super(component);
        }

        @Override
        protected Void getComponentValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setComponentValue(Void value) {
            throw new UnsupportedOperationException();
        }
    }
}

