/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.button.AbstractControlPanelBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.button.ControlHandler;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class DefaultButtonPanelBuilder
extends AbstractControlPanelBuilder<JPanel, ButtonPanelBuilder>
implements ButtonPanelBuilder {
    private int buttonGap = (Integer)Layouts.GAP.get();

    DefaultButtonPanelBuilder(Action ... actions) {
        this(Controls.controls(actions));
    }

    DefaultButtonPanelBuilder(Controls controls) {
        super(controls);
    }

    @Override
    public ButtonPanelBuilder buttonGap(int buttonGap) {
        this.buttonGap = buttonGap;
        return this;
    }

    @Override
    protected JPanel createComponent() {
        JPanel panel = this.createPanel();
        new ButtonControlHandler(panel, this.controls(), this.buttonBuilder(), this.toggleButtonBuilder());
        return panel;
    }

    private JPanel createPanel() {
        return new JPanel(this.orientation() == 0 ? new GridLayout(1, 0, this.buttonGap, 0) : new GridLayout(0, 1, 0, this.buttonGap));
    }

    private final class ButtonControlHandler
    extends ControlHandler {
        private final JPanel panel;
        private final ButtonBuilder<?, ?, ?> buttonBuilder;
        private final ToggleButtonBuilder<?, ?> toggleButtonBuilder;

        private ButtonControlHandler(JPanel panel, Controls controls, ButtonBuilder<?, ?, ?> buttonBuilder, ToggleButtonBuilder<?, ?> toggleButtonBuilder) {
            this.panel = panel;
            this.buttonBuilder = buttonBuilder;
            this.toggleButtonBuilder = toggleButtonBuilder;
            controls.actions().forEach(this);
        }

        @Override
        void onSeparator() {
            this.panel.add(new JLabel());
        }

        @Override
        void onControl(Control control) {
            this.onAction(control);
        }

        @Override
        void onToggleControl(ToggleControl toggleControl) {
            this.panel.add((Component)this.toggleButtonBuilder.toggleControl(toggleControl).build());
        }

        @Override
        void onControls(Controls controls) {
            JPanel controlPanel = DefaultButtonPanelBuilder.this.createPanel();
            new ButtonControlHandler(controlPanel, controls, this.buttonBuilder, this.toggleButtonBuilder);
            this.panel.add(controlPanel);
        }

        @Override
        void onAction(Action action) {
            this.panel.add((Component)this.buttonBuilder.action(action).build());
        }
    }
}

