/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.button.CheckBoxMenuItemBuilder;
import is.codion.swing.common.ui.component.button.ControlHandler;
import is.codion.swing.common.ui.component.button.DefaultMenuItemBuilder;
import is.codion.swing.common.ui.component.button.MenuBuilder;
import is.codion.swing.common.ui.component.button.MenuItemBuilder;
import is.codion.swing.common.ui.component.button.ToggleMenuItemBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuListener;

final class DefaultMenuBuilder
extends DefaultMenuItemBuilder<JMenu, MenuBuilder>
implements MenuBuilder {
    private final Controls.ControlsBuilder controlsBuilder;
    private final List<MenuListener> menuListeners = new ArrayList<MenuListener>();
    private final List<PopupMenuListener> popupMenuListeners = new ArrayList<PopupMenuListener>();
    private MenuItemBuilder<?, ?> menuItemBuilder = MenuItemBuilder.builder();
    private ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder = CheckBoxMenuItemBuilder.builder();

    DefaultMenuBuilder(Controls controls) {
        super(controls);
        this.controlsBuilder = controls == null ? Controls.builder() : controls.copy();
    }

    @Override
    public MenuBuilder controls(Controls controls) {
        this.controlsBuilder.control(Objects.requireNonNull(controls));
        return this;
    }

    @Override
    public MenuBuilder separator() {
        this.controlsBuilder.separator();
        return this;
    }

    @Override
    public MenuBuilder menuListener(MenuListener menuListener) {
        this.menuListeners.add(Objects.requireNonNull(menuListener));
        return this;
    }

    @Override
    public MenuBuilder popupMenuListener(PopupMenuListener popupMenuListener) {
        this.popupMenuListeners.add(Objects.requireNonNull(popupMenuListener));
        return this;
    }

    @Override
    public MenuBuilder menuItemBuilder(MenuItemBuilder<?, ?> menuItemBuilder) {
        this.menuItemBuilder = Objects.requireNonNull(menuItemBuilder);
        return this;
    }

    @Override
    public MenuBuilder toggleMenuItemBuilder(ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder) {
        this.toggleMenuItemBuilder = Objects.requireNonNull(toggleMenuItemBuilder);
        return this;
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = ((JMenu)this.createComponent()).getPopupMenu();
        this.popupMenuListeners.forEach(new AddPopupMenuListener(popupMenu));
        return popupMenu;
    }

    @Override
    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        ((Controls)this.controlsBuilder.build()).actions().stream().filter(new IsControlsInstance()).map(new CastToControls()).filter(new IsNotEmptyControls()).forEach(new AddControlsToMenu(menuBar));
        return menuBar;
    }

    @Override
    protected JMenu createButton() {
        Controls controls = (Controls)this.controlsBuilder.build();
        JMenu menu = new JMenu(controls);
        this.menuListeners.forEach(new AddMenuListener(menu));
        new MenuControlHandler(menu, controls, this.menuItemBuilder, this.toggleMenuItemBuilder);
        return menu;
    }

    private static final class AddPopupMenuListener
    implements Consumer<PopupMenuListener> {
        private final JPopupMenu popupMenu;

        private AddPopupMenuListener(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        @Override
        public void accept(PopupMenuListener popupMenuListener) {
            this.popupMenu.addPopupMenuListener(popupMenuListener);
        }
    }

    private static final class IsControlsInstance
    implements Predicate<Action> {
        private IsControlsInstance() {
        }

        @Override
        public boolean test(Action action) {
            return action instanceof Controls;
        }
    }

    private static final class CastToControls
    implements Function<Action, Controls> {
        private CastToControls() {
        }

        @Override
        public Controls apply(Action action) {
            return (Controls)action;
        }
    }

    private static final class IsNotEmptyControls
    implements Predicate<Controls> {
        private IsNotEmptyControls() {
        }

        @Override
        public boolean test(Controls controls) {
            return controls.notEmpty();
        }
    }

    private static final class AddControlsToMenu
    implements Consumer<Controls> {
        private final JMenuBar menuBar;

        private AddControlsToMenu(JMenuBar menuBar) {
            this.menuBar = menuBar;
        }

        @Override
        public void accept(Controls controls) {
            this.menuBar.add((JMenu)new DefaultMenuBuilder(controls).createComponent());
        }
    }

    private static final class AddMenuListener
    implements Consumer<MenuListener> {
        private final JMenu menu;

        private AddMenuListener(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void accept(MenuListener menuListener) {
            this.menu.addMenuListener(menuListener);
        }
    }

    private static final class MenuControlHandler
    extends ControlHandler {
        private final JMenu menu;
        private final MenuItemBuilder<?, ?> menuItemBuilder;
        private final ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder;

        private MenuControlHandler(JMenu menu, Controls controls, MenuItemBuilder<?, ?> menuItemBuilder, ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder) {
            this.menu = menu;
            this.menuItemBuilder = menuItemBuilder;
            this.toggleMenuItemBuilder = toggleMenuItemBuilder;
            controls.actions().forEach(this);
        }

        @Override
        void onSeparator() {
            this.menu.addSeparator();
        }

        @Override
        void onControl(Control control) {
            this.menu.add((JMenuItem)((MenuItemBuilder)this.menuItemBuilder.control(control)).build());
        }

        @Override
        void onToggleControl(ToggleControl toggleControl) {
            this.menu.add((JMenuItem)this.toggleMenuItemBuilder.toggleControl(toggleControl).build());
        }

        @Override
        void onControls(Controls controls) {
            JMenu subMenu = new JMenu(controls);
            new MenuControlHandler(subMenu, controls, this.menuItemBuilder, this.toggleMenuItemBuilder);
            this.menu.add(subMenu);
        }

        @Override
        void onAction(Action action) {
            this.menu.add(action);
        }
    }
}

