/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.button.AbstractControlPanelBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ControlHandler;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JToolBar;

final class DefaultToolBarBuilder
extends AbstractControlPanelBuilder<JToolBar, ToolBarBuilder>
implements ToolBarBuilder {
    private boolean floatable = true;
    private boolean rollover = false;
    private boolean borderPainted = true;

    DefaultToolBarBuilder(Controls controls) {
        super(controls);
        this.includeButtonText(false);
    }

    @Override
    public ToolBarBuilder floatable(boolean floatable) {
        this.floatable = floatable;
        return this;
    }

    @Override
    public ToolBarBuilder rollover(boolean rollover) {
        this.rollover = rollover;
        return this;
    }

    @Override
    public ToolBarBuilder borderPainted(boolean borderPainted) {
        this.borderPainted = borderPainted;
        return this;
    }

    @Override
    protected JToolBar createComponent() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(this.floatable);
        toolBar.setOrientation(this.orientation());
        toolBar.setRollover(this.rollover);
        toolBar.setBorderPainted(this.borderPainted);
        new ToolBarControlHandler(toolBar, this.controls(), this.buttonBuilder(), this.toggleButtonBuilder());
        return toolBar;
    }

    private static final class ToolBarControlHandler
    extends ControlHandler {
        private final JToolBar toolBar;
        private final ButtonBuilder<?, ?, ?> buttonBuilder;
        private final ToggleButtonBuilder<?, ?> toggleButtonBuilder;

        private ToolBarControlHandler(JToolBar toolBar, Controls controls, ButtonBuilder<?, ?, ?> buttonBuilder, ToggleButtonBuilder<?, ?> toggleButtonBuilder) {
            this.toolBar = toolBar;
            this.buttonBuilder = buttonBuilder;
            this.toggleButtonBuilder = toggleButtonBuilder;
            controls.actions().forEach(this);
        }

        @Override
        void onSeparator() {
            this.toolBar.addSeparator();
        }

        @Override
        void onControl(Control control) {
            this.onAction(control);
        }

        @Override
        void onToggleControl(ToggleControl toggleControl) {
            this.toolBar.add((Component)this.toggleButtonBuilder.toggleControl(toggleControl).build());
        }

        @Override
        void onControls(Controls controls) {
            new ToolBarControlHandler(this.toolBar, controls, this.buttonBuilder, this.toggleButtonBuilder);
        }

        @Override
        void onAction(Action action) {
            this.toolBar.add((Component)this.buttonBuilder.action(action).build());
        }
    }
}

