/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import is.codion.common.i18n.Messages;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxMouseWheelListener;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.combobox.CopyEditorActionsListener;
import is.codion.swing.common.ui.component.combobox.FocusableComboBox;
import is.codion.swing.common.ui.component.combobox.MoveCaretToStart;
import is.codion.swing.common.ui.component.combobox.SelectedValue;
import is.codion.swing.common.ui.component.combobox.SteppedComboBoxUI;
import is.codion.swing.common.ui.component.text.TextComponents;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;

public class DefaultComboBoxBuilder<T, C extends JComboBox<T>, B extends ComboBoxBuilder<T, C, B>>
extends AbstractComponentBuilder<T, C, B>
implements ComboBoxBuilder<T, C, B> {
    protected final ComboBoxModel<T> comboBoxModel;
    private final List<ItemListener> itemListeners = new ArrayList<ItemListener>();
    private boolean editable = false;
    private Completion.Mode completionMode = (Completion.Mode)((Object)Completion.COMBO_BOX_COMPLETION_MODE.get());
    private ListCellRenderer<T> renderer;
    private ComboBoxEditor editor;
    private boolean mouseWheelScrolling = true;
    private boolean mouseWheelScrollingWithWrapAround = false;
    private int maximumRowCount = -1;
    private boolean moveCaretToFrontOnSelection = true;
    private int popupWidth = 0;

    protected DefaultComboBoxBuilder(ComboBoxModel<T> comboBoxModel, Value<T> linkedValue) {
        super(linkedValue);
        this.comboBoxModel = Objects.requireNonNull(comboBoxModel);
        this.initialValue(comboBoxModel.getSelectedItem());
        this.preferredHeight(TextComponents.preferredTextFieldHeight());
        if (comboBoxModel instanceof FilterComboBoxModel) {
            this.popupMenuControl(comboBox -> ((CommandControl.CommandControlBuilder)Control.builder().command(new RefreshCommand((FilterComboBoxModel)comboBoxModel)).name(Messages.refresh())).build());
        }
    }

    @Override
    public final B editable(boolean editable) {
        this.editable = editable;
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B completionMode(Completion.Mode completionMode) {
        this.completionMode = Objects.requireNonNull(completionMode);
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B renderer(ListCellRenderer<T> renderer) {
        this.renderer = Objects.requireNonNull(renderer);
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B editor(ComboBoxEditor editor) {
        this.editor = Objects.requireNonNull(editor);
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B mouseWheelScrolling(boolean mouseWheelScrolling) {
        this.mouseWheelScrolling = mouseWheelScrolling;
        if (mouseWheelScrolling) {
            this.mouseWheelScrollingWithWrapAround = false;
        }
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B mouseWheelScrollingWithWrapAround(boolean mouseWheelScrollingWithWrapAround) {
        this.mouseWheelScrollingWithWrapAround = mouseWheelScrollingWithWrapAround;
        if (mouseWheelScrollingWithWrapAround) {
            this.mouseWheelScrolling = false;
        }
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B maximumRowCount(int maximumRowCount) {
        this.maximumRowCount = maximumRowCount;
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B moveCaretToFrontOnSelection(boolean moveCaretToFrontOnSelection) {
        this.moveCaretToFrontOnSelection = moveCaretToFrontOnSelection;
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B popupWidth(int popupWidth) {
        this.popupWidth = popupWidth;
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    public final B itemListener(ItemListener itemListener) {
        this.itemListeners.add(Objects.requireNonNull(itemListener));
        return (B)((ComboBoxBuilder)this.self());
    }

    @Override
    protected final C createComponent() {
        C comboBox = this.createComboBox();
        if (this.editable) {
            ((JComboBox)comboBox).setEditable(true);
        }
        if (!this.editable && this.editor == null) {
            Completion.enable(comboBox, this.completionMode);
        }
        if (this.comboBoxModel instanceof FilterComboBoxModel && ((JComboBox)comboBox).isEditable() && this.moveCaretToFrontOnSelection) {
            ((FilterComboBoxModel)this.comboBoxModel).selectedItem().addConsumer(new MoveCaretToStart(comboBox));
        }
        if (this.renderer != null) {
            ((JComboBox)comboBox).setRenderer(this.renderer);
        }
        if (this.editor != null) {
            ((JComboBox)comboBox).setEditor(this.editor);
        }
        if (this.mouseWheelScrolling) {
            ((Component)comboBox).addMouseWheelListener(new ComboBoxMouseWheelListener(this.comboBoxModel, false));
        }
        if (this.mouseWheelScrollingWithWrapAround) {
            ((Component)comboBox).addMouseWheelListener(new ComboBoxMouseWheelListener(this.comboBoxModel, true));
        }
        if (this.maximumRowCount >= 0) {
            ((JComboBox)comboBox).setMaximumRowCount(this.maximumRowCount);
        }
        this.itemListeners.forEach(new AddItemListener((JComboBox<?>)comboBox));
        if (Utilities.systemOrCrossPlatformLookAndFeelEnabled()) {
            new SteppedComboBoxUI((JComboBox<?>)comboBox, this.popupWidth);
        }
        ((Container)comboBox).addPropertyChangeListener("editor", new CopyEditorActionsListener());
        return comboBox;
    }

    @Override
    protected final ComponentValue<T, C> createComponentValue(C component) {
        return new SelectedValue(component);
    }

    @Override
    protected final void setInitialValue(C component, T initialValue) {
        ((JComboBox)component).setSelectedItem(initialValue);
    }

    protected C createComboBox() {
        return (C)new FocusableComboBox<T>(this.comboBoxModel);
    }

    private static final class AddItemListener
    implements Consumer<ItemListener> {
        private final JComboBox<?> comboBox;

        private AddItemListener(JComboBox<?> comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void accept(ItemListener listener) {
            this.comboBox.addItemListener(listener);
        }
    }

    private static final class RefreshCommand
    implements Control.Command {
        private final FilterComboBoxModel<?> comboBoxModel;

        private RefreshCommand(FilterComboBoxModel<?> comboBoxModel) {
            this.comboBoxModel = comboBoxModel;
        }

        @Override
        public void execute() {
            this.comboBoxModel.refresh();
        }
    }
}

