/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

final class SteppedComboBoxUI
extends MetalComboBoxUI {
    private int popupWidth = 0;

    SteppedComboBoxUI(JComboBox<?> comboBox, int popupWidth) {
        Objects.requireNonNull(comboBox).setUI(this);
        this.popupWidth = popupWidth;
    }

    @Override
    protected ComboPopup createPopup() {
        return new SteppedComboBoxPopup(this.comboBox, this);
    }

    private static final class SteppedComboBoxPopup
    extends BasicComboPopup {
        private final SteppedComboBoxUI comboBoxUI;

        private SteppedComboBoxPopup(JComboBox comboBox, SteppedComboBoxUI comboBoxUI) {
            super(comboBox);
            this.comboBoxUI = comboBoxUI;
            this.getAccessibleContext().setAccessibleParent(comboBox);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                Dimension popupSize = this.popupSize(this.comboBox);
                popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                this.scroller.setMaximumSize(popupBounds.getSize());
                this.scroller.setPreferredSize(popupBounds.getSize());
                this.scroller.setMinimumSize(popupBounds.getSize());
                this.getList().invalidate();
                int selectedIndex = this.comboBox.getSelectedIndex();
                if (selectedIndex == -1) {
                    this.getList().clearSelection();
                } else {
                    this.getList().setSelectedIndex(selectedIndex);
                }
                this.getList().ensureIndexIsVisible(this.getList().getSelectedIndex());
                this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            }
            super.setVisible(visible);
        }

        private Dimension popupSize(JComboBox<?> comboBox) {
            Dimension displaySize = this.comboBoxUI.getDisplaySize();
            Dimension size = comboBox.getSize();
            return new Dimension(Math.max(size.width, this.comboBoxUI.popupWidth <= 0 ? displaySize.width : this.comboBoxUI.popupWidth), size.height);
        }
    }
}

