/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.list;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.list.DefaultListItemsBuilder;
import is.codion.swing.common.ui.component.list.DefaultListSelectedItemBuilder;
import is.codion.swing.common.ui.component.list.DefaultListSelectedItemsBuilder;
import is.codion.swing.common.ui.component.list.ListBuilder;
import java.util.List;
import java.util.Objects;
import javax.swing.ListModel;

final class DefaultListBuilderFactory<T>
implements ListBuilder.Factory<T> {
    private final ListModel<T> listModel;

    DefaultListBuilderFactory(ListModel<T> listModel) {
        this.listModel = Objects.requireNonNull(listModel);
    }

    @Override
    public ListBuilder.Items<T> items() {
        return new DefaultListItemsBuilder<T>(this.listModel, null);
    }

    @Override
    public ListBuilder.Items<T> items(Value<List<T>> linkedValue) {
        return new DefaultListItemsBuilder<T>(this.listModel, linkedValue);
    }

    @Override
    public ListBuilder.SelectedItems<T> selectedItems() {
        return new DefaultListSelectedItemsBuilder<T>(this.listModel, null);
    }

    @Override
    public ListBuilder.SelectedItems<T> selectedItems(Value<List<T>> linkedValue) {
        return new DefaultListSelectedItemsBuilder<T>(this.listModel, linkedValue);
    }

    @Override
    public ListBuilder.SelectedItem<T> selectedItem() {
        return new DefaultListSelectedItemBuilder<T>(this.listModel, null);
    }

    @Override
    public ListBuilder.SelectedItem<T> selectedItem(Value<T> linkedValue) {
        return new DefaultListSelectedItemBuilder<T>(this.listModel, linkedValue);
    }
}

