/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.panel;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class DefaultBorderLayoutPanelBuilder
extends AbstractComponentBuilder<Void, JPanel, BorderLayoutPanelBuilder>
implements BorderLayoutPanelBuilder {
    private final BorderLayout layout;
    private JComponent centerComponent;
    private JComponent northComponent;
    private JComponent southComponent;
    private JComponent eastComponent;
    private JComponent westComponent;

    DefaultBorderLayoutPanelBuilder(BorderLayout layout) {
        this.layout = Objects.requireNonNull(layout);
    }

    @Override
    public BorderLayoutPanelBuilder centerComponent(JComponent centerComponent) {
        this.centerComponent = Objects.requireNonNull(centerComponent);
        return this;
    }

    @Override
    public BorderLayoutPanelBuilder northComponent(JComponent northComponent) {
        this.northComponent = Objects.requireNonNull(northComponent);
        return this;
    }

    @Override
    public BorderLayoutPanelBuilder southComponent(JComponent southComponent) {
        this.southComponent = Objects.requireNonNull(southComponent);
        return this;
    }

    @Override
    public BorderLayoutPanelBuilder eastComponent(JComponent eastComponent) {
        this.eastComponent = Objects.requireNonNull(eastComponent);
        return this;
    }

    @Override
    public BorderLayoutPanelBuilder westComponent(JComponent westComponent) {
        this.westComponent = Objects.requireNonNull(westComponent);
        return this;
    }

    @Override
    protected JPanel createComponent() {
        JPanel component = new JPanel(this.layout);
        if (this.centerComponent != null) {
            component.add((Component)this.centerComponent, "Center");
        }
        if (this.northComponent != null) {
            component.add((Component)this.northComponent, "North");
        }
        if (this.southComponent != null) {
            component.add((Component)this.southComponent, "South");
        }
        if (this.eastComponent != null) {
            component.add((Component)this.eastComponent, "East");
        }
        if (this.westComponent != null) {
            component.add((Component)this.westComponent, "West");
        }
        return component;
    }

    @Override
    protected ComponentValue<Void, JPanel> createComponentValue(JPanel component) {
        return new PanelComponentValue(component);
    }

    @Override
    protected void setInitialValue(JPanel component, Void initialValue) {
    }

    private static final class PanelComponentValue
    extends AbstractComponentValue<Void, JPanel> {
        private PanelComponentValue(JPanel component) {
            super(component);
        }

        @Override
        protected Void getComponentValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setComponentValue(Void value) {
            throw new UnsupportedOperationException();
        }
    }
}

