/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.panel;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class DefaultPanelBuilder
extends AbstractComponentBuilder<Void, JPanel, PanelBuilder>
implements PanelBuilder {
    private final JPanel panel;
    private final List<ComponentConstraints> componentConstraints = new ArrayList<ComponentConstraints>();
    private LayoutManager layout;

    DefaultPanelBuilder(JPanel panel) {
        this.panel = Objects.requireNonNull(panel);
    }

    DefaultPanelBuilder(LayoutManager layout) {
        this.layout = layout;
        this.panel = null;
    }

    @Override
    public PanelBuilder layout(LayoutManager layoutManager) {
        this.layout = Objects.requireNonNull(layoutManager);
        return this;
    }

    @Override
    public PanelBuilder add(JComponent component) {
        this.componentConstraints.add(new ComponentConstraints(Objects.requireNonNull(component)));
        return this;
    }

    @Override
    public PanelBuilder add(JComponent component, Object constraints) {
        if (constraints instanceof JComponent) {
            throw new IllegalArgumentException("Use addAll() when adding multiple components");
        }
        this.componentConstraints.add(new ComponentConstraints(Objects.requireNonNull(component), Objects.requireNonNull(constraints)));
        return this;
    }

    @Override
    public PanelBuilder addAll(JComponent ... components) {
        this.addAll(Arrays.asList(components));
        return this;
    }

    @Override
    public PanelBuilder addAll(Collection<? extends JComponent> components) {
        Objects.requireNonNull(components).forEach(new AddComponents(this.componentConstraints));
        return this;
    }

    @Override
    protected JPanel createComponent() {
        JPanel component;
        JPanel jPanel = component = this.panel == null ? new JPanel() : this.panel;
        if (this.layout != null) {
            component.setLayout(this.layout);
        }
        this.componentConstraints.forEach(new AddToPanel(component));
        return component;
    }

    @Override
    protected ComponentValue<Void, JPanel> createComponentValue(JPanel component) {
        return new PanelComponentValue(component);
    }

    @Override
    protected void setInitialValue(JPanel component, Void initialValue) {
    }

    private static final class ComponentConstraints {
        private final JComponent component;
        private final Object constraints;

        private ComponentConstraints(JComponent component) {
            this(component, null);
        }

        private ComponentConstraints(JComponent component, Object constraints) {
            this.component = component;
            this.constraints = constraints;
        }
    }

    private static final class AddComponents
    implements Consumer<JComponent> {
        private final List<ComponentConstraints> componentConstraints;

        private AddComponents(List<ComponentConstraints> componentConstraints) {
            this.componentConstraints = componentConstraints;
        }

        @Override
        public void accept(JComponent component) {
            this.componentConstraints.add(new ComponentConstraints(Objects.requireNonNull(component)));
        }
    }

    private static final class AddToPanel
    implements Consumer<ComponentConstraints> {
        private final JPanel panel;

        private AddToPanel(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public void accept(ComponentConstraints componentConstraint) {
            if (componentConstraint.constraints != null) {
                this.panel.add((Component)componentConstraint.component, componentConstraint.constraints);
            } else {
                this.panel.add(componentConstraint.component);
            }
        }
    }

    private static final class PanelComponentValue
    extends AbstractComponentValue<Void, JPanel> {
        private PanelComponentValue(JPanel component) {
            super(component);
        }

        @Override
        protected Void getComponentValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setComponentValue(Void value) {
            throw new UnsupportedOperationException();
        }
    }
}

