/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.progressbar;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.progressbar.ProgressBarBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JProgressBar;

final class DefaultProgressBarBuilder
extends AbstractComponentBuilder<Integer, JProgressBar, ProgressBarBuilder>
implements ProgressBarBuilder {
    private final BoundedRangeModel boundedRangeModel;
    private boolean borderPainted;
    private boolean stringPainted;
    private int orientation;
    private boolean indeterminate;
    private String string;

    DefaultProgressBarBuilder(BoundedRangeModel boundedRangeModel) {
        this.indeterminate = boundedRangeModel == null;
        this.boundedRangeModel = boundedRangeModel == null ? new DefaultBoundedRangeModel() : boundedRangeModel;
    }

    @Override
    public ProgressBarBuilder string(String string) {
        this.string = string;
        return this;
    }

    @Override
    public ProgressBarBuilder borderPainted(boolean borderPainted) {
        this.borderPainted = borderPainted;
        return this;
    }

    @Override
    public ProgressBarBuilder stringPainted(boolean stringPainted) {
        this.stringPainted = stringPainted;
        return this;
    }

    @Override
    public ProgressBarBuilder orientation(int orientation) {
        this.orientation = orientation;
        return this;
    }

    @Override
    public ProgressBarBuilder indeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        return this;
    }

    @Override
    protected JProgressBar createComponent() {
        JProgressBar progressBar = new JProgressBar(this.boundedRangeModel);
        progressBar.setBorderPainted(this.borderPainted);
        progressBar.setString(this.string);
        progressBar.setStringPainted(this.stringPainted);
        progressBar.setOrientation(this.orientation);
        progressBar.setIndeterminate(this.indeterminate);
        return progressBar;
    }

    @Override
    protected ComponentValue<Integer, JProgressBar> createComponentValue(JProgressBar component) {
        return new IntegerProgressBarValue(component);
    }

    @Override
    protected void setInitialValue(JProgressBar component, Integer initialValue) {
        if (!component.isIndeterminate()) {
            component.setValue(initialValue == null ? 0 : initialValue);
        }
    }

    private static final class IntegerProgressBarValue
    extends AbstractComponentValue<Integer, JProgressBar> {
        private IntegerProgressBarValue(JProgressBar progressBar) {
            super(progressBar, 0);
            progressBar.getModel().addChangeListener(e -> this.notifyListeners());
        }

        @Override
        protected Integer getComponentValue() {
            return ((JProgressBar)this.component()).getValue();
        }

        @Override
        protected void setComponentValue(Integer value) {
            ((JProgressBar)this.component()).setValue(value == null ? 0 : value);
        }
    }
}

