/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.scrollpane;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

final class DefaultScrollPaneBuilder
extends AbstractComponentBuilder<Void, JScrollPane, ScrollPaneBuilder>
implements ScrollPaneBuilder {
    private final JComponent view;
    private int vsbPolicy = 20;
    private int hsbPolicy = 30;
    private boolean wheelScrollingEnabled = true;
    private int verticalUnitIncrement;
    private int horizontalUnitIncrement;
    private int verticalBlockIncrement;
    private int horizontalBlockIncrement;
    private LayoutManager layout;

    DefaultScrollPaneBuilder(JComponent view) {
        this.view = Objects.requireNonNull(view);
    }

    @Override
    public ScrollPaneBuilder verticalScrollBarPolicy(int verticalScrollBarPolicy) {
        this.vsbPolicy = verticalScrollBarPolicy;
        return this;
    }

    @Override
    public ScrollPaneBuilder horizontalScrollBarPolicy(int horizontalScrollBarPolicy) {
        this.hsbPolicy = horizontalScrollBarPolicy;
        return this;
    }

    @Override
    public ScrollPaneBuilder verticalUnitIncrement(int verticalUnitIncrement) {
        this.verticalUnitIncrement = verticalUnitIncrement;
        return this;
    }

    @Override
    public ScrollPaneBuilder horizontalUnitIncrement(int horizontalUnitIncrement) {
        this.horizontalUnitIncrement = horizontalUnitIncrement;
        return this;
    }

    @Override
    public ScrollPaneBuilder verticalBlockIncrement(int verticalBlockIncrement) {
        this.verticalBlockIncrement = verticalBlockIncrement;
        return this;
    }

    @Override
    public ScrollPaneBuilder horizontalBlockIncrement(int horizontalBlockIncrement) {
        this.horizontalBlockIncrement = horizontalBlockIncrement;
        return this;
    }

    @Override
    public ScrollPaneBuilder wheelScrollingEnable(boolean wheelScrollingEnabled) {
        this.wheelScrollingEnabled = wheelScrollingEnabled;
        return this;
    }

    @Override
    public ScrollPaneBuilder layout(LayoutManager layout) {
        this.layout = layout;
        return this;
    }

    @Override
    protected JScrollPane createComponent() {
        JScrollPane scrollPane = new JScrollPane(this.view, this.vsbPolicy, this.hsbPolicy);
        scrollPane.setWheelScrollingEnabled(this.wheelScrollingEnabled);
        if (this.verticalUnitIncrement > 0) {
            scrollPane.getVerticalScrollBar().setUnitIncrement(this.verticalUnitIncrement);
        }
        if (this.horizontalUnitIncrement > 0) {
            scrollPane.getHorizontalScrollBar().setUnitIncrement(this.horizontalUnitIncrement);
        }
        if (this.verticalBlockIncrement > 0) {
            scrollPane.getVerticalScrollBar().setBlockIncrement(this.verticalBlockIncrement);
        }
        if (this.horizontalBlockIncrement > 0) {
            scrollPane.getHorizontalScrollBar().setBlockIncrement(this.horizontalBlockIncrement);
        }
        if (this.layout != null) {
            scrollPane.setLayout(this.layout);
        }
        return scrollPane;
    }

    @Override
    protected ComponentValue<Void, JScrollPane> createComponentValue(JScrollPane component) {
        return new ScrollPaneComponentValue(component);
    }

    @Override
    protected void setInitialValue(JScrollPane component, Void initialValue) {
    }

    private static final class ScrollPaneComponentValue
    extends AbstractComponentValue<Void, JScrollPane> {
        private ScrollPaneComponentValue(JScrollPane component) {
            super(component);
        }

        @Override
        protected Void getComponentValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setComponentValue(Void value) {
            throw new UnsupportedOperationException();
        }
    }
}

