/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.spinner;

import is.codion.common.item.Item;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import java.util.Objects;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;

final class SpinnerItemValue<T>
extends AbstractComponentValue<T, JSpinner> {
    SpinnerItemValue(JSpinner spinner) {
        super(spinner);
        if (!(spinner.getModel() instanceof SpinnerListModel)) {
            throw new IllegalArgumentException("Spinner model must be a SpinnerListModel");
        }
        spinner.getModel().addChangeListener(e -> this.notifyListeners());
    }

    @Override
    protected T getComponentValue() {
        Item selectedItem = (Item)((JSpinner)this.component()).getModel().getValue();
        return (T)(selectedItem == null ? null : selectedItem.value());
    }

    @Override
    protected void setComponentValue(T value) {
        SpinnerListModel model = (SpinnerListModel)((JSpinner)this.component()).getModel();
        model.getList().stream().map(Item.class::cast).filter(item -> Objects.equals(item.value(), value)).findFirst().ifPresent(model::setValue);
    }
}

