/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.table.FilterColumnConditionPanel;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;

final class DefaultFilterFieldFactory<C>
implements FilterColumnConditionPanel.FieldFactory<C> {
    private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(Character.class, String.class, Boolean.class, Short.class, Integer.class, Double.class, BigDecimal.class, Long.class, LocalTime.class, LocalDate.class, LocalDateTime.class, OffsetDateTime.class);

    DefaultFilterFieldFactory() {
    }

    @Override
    public boolean supportsType(Class<?> columnClass) {
        return SUPPORTED_TYPES.contains(Objects.requireNonNull(columnClass));
    }

    @Override
    public JComponent createEqualField(ColumnConditionModel<C, ?> conditionModel) {
        return DefaultFilterFieldFactory.createField(conditionModel).link(conditionModel.operands().equal()).build();
    }

    @Override
    public Optional<JComponent> createUpperBoundField(ColumnConditionModel<C, ?> conditionModel) {
        if (conditionModel.columnClass().equals(Boolean.class)) {
            return Optional.empty();
        }
        return Optional.of(DefaultFilterFieldFactory.createField(conditionModel).link(conditionModel.operands().upperBound()).build());
    }

    @Override
    public Optional<JComponent> createLowerBoundField(ColumnConditionModel<C, ?> conditionModel) {
        if (conditionModel.columnClass().equals(Boolean.class)) {
            return Optional.empty();
        }
        return Optional.of(DefaultFilterFieldFactory.createField(conditionModel).link(conditionModel.operands().lowerBound()).build());
    }

    @Override
    public JComponent createInField(ColumnConditionModel<C, ?> conditionModel) {
        return Components.listBox(DefaultFilterFieldFactory.createField(conditionModel).buildValue(), conditionModel.operands().in()).build();
    }

    private static <T> ComponentBuilder<T, ? extends JComponent, ?> createField(ColumnConditionModel<?, ?> columnConditionModel) {
        Class columnClass = columnConditionModel.columnClass();
        if (columnClass.equals(Boolean.class)) {
            return Components.checkBox().nullable(true).horizontalAlignment(0);
        }
        if (columnClass.equals(Short.class)) {
            return Components.shortField().format(columnConditionModel.format().orElse(null));
        }
        if (columnClass.equals(Integer.class)) {
            return Components.integerField().format(columnConditionModel.format().orElse(null));
        }
        if (columnClass.equals(Double.class)) {
            return Components.doubleField().format(columnConditionModel.format().orElse(null));
        }
        if (columnClass.equals(BigDecimal.class)) {
            return Components.bigDecimalField().format(columnConditionModel.format().orElse(null));
        }
        if (columnClass.equals(Long.class)) {
            return Components.longField().format(columnConditionModel.format().orElse(null));
        }
        if (columnClass.equals(LocalTime.class)) {
            return Components.localTimeField().dateTimePattern(columnConditionModel.dateTimePattern());
        }
        if (columnClass.equals(LocalDate.class)) {
            return Components.localDateField().dateTimePattern(columnConditionModel.dateTimePattern());
        }
        if (columnClass.equals(LocalDateTime.class)) {
            return Components.localDateTimeField().dateTimePattern(columnConditionModel.dateTimePattern());
        }
        if (columnClass.equals(OffsetDateTime.class)) {
            return Components.offsetDateTimeField().dateTimePattern(columnConditionModel.dateTimePattern());
        }
        if (columnClass.equals(String.class)) {
            return Components.stringField();
        }
        if (columnClass.equals(Character.class)) {
            return Components.characterField();
        }
        throw new IllegalArgumentException("Unsupported type: " + columnClass);
    }
}

