/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.swing.common.ui.component.table.FilterTableCellEditor;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;

final class DefaultFilterTableCellEditor<T>
extends AbstractCellEditor
implements FilterTableCellEditor<T> {
    private final Supplier<ComponentValue<T, ? extends JComponent>> inputComponent;
    private ComponentValue<T, ? extends JComponent> componentValue;

    DefaultFilterTableCellEditor(Supplier<ComponentValue<T, ? extends JComponent>> inputComponent) {
        this.inputComponent = Objects.requireNonNull(inputComponent);
    }

    @Override
    public ComponentValue<T, ? extends JComponent> componentValue() {
        if (this.componentValue == null) {
            this.componentValue = this.initializeComponentValue();
        }
        return this.componentValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.componentValue().set(value);
        return this.componentValue().component();
    }

    @Override
    public Object getCellEditorValue() {
        return this.componentValue().get();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= 2;
        }
        return false;
    }

    private ComponentValue<T, ? extends JComponent> initializeComponentValue() {
        ComponentValue<T, JComponent> value = this.inputComponent.get();
        JComponent editorComponent = value.component();
        if (editorComponent instanceof JCheckBox) {
            ((JCheckBox)editorComponent).setHorizontalAlignment(0);
        }
        if (editorComponent instanceof JComboBox) {
            new ComboBoxEnterPressedAction((JComboBox)editorComponent, Control.commandControl(this::stopCellEditing));
        }
        return value;
    }

    private static final class ComboBoxEnterPressedAction
    extends AbstractAction {
        private static final String ENTER_PRESSED = "enterPressed";
        private final JComboBox<?> comboBox;
        private final Action action;
        private final Action enterPressedAction;

        private ComboBoxEnterPressedAction(JComboBox<?> comboBox, Action action) {
            this.comboBox = comboBox;
            this.action = action;
            this.enterPressedAction = comboBox.getActionMap().get(ENTER_PRESSED);
            this.comboBox.getActionMap().put(ENTER_PRESSED, this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.comboBox.isPopupVisible()) {
                this.enterPressedAction.actionPerformed(e);
            } else if (this.action.isEnabled()) {
                this.action.actionPerformed(e);
            }
        }
    }
}

