/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.swing.common.model.component.button.NullableToggleButtonModel;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.component.button.NullableCheckBox;
import is.codion.swing.common.ui.component.table.DefaultFilterTableCellRendererBuilder;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilterTableSearchModel;
import java.awt.Component;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

final class DefaultFilterTableCellRenderer<R, C>
extends DefaultTableCellRenderer
implements FilterTableCellRenderer {
    private final FilterTableCellRenderer.Settings<C> settings;
    private final FilterTableModel<R, C> tableModel;
    private final C columnIdentifier;
    private final boolean toolTipData;
    private final boolean columnShading;
    private final boolean alternateRowColoring;
    private final Function<Object, String> string;
    private final FilterTableCellRenderer.CellColors<C> cellColors;

    DefaultFilterTableCellRenderer(DefaultFilterTableCellRendererBuilder<R, C> builder, FilterTableCellRenderer.Settings<C> settings) {
        this.tableModel = Objects.requireNonNull(builder).tableModel;
        this.settings = Objects.requireNonNull(settings);
        this.settings.updateColors();
        this.columnIdentifier = builder.columnIdentifier;
        this.toolTipData = builder.toolTipData;
        this.columnShading = builder.columnShading;
        this.alternateRowColoring = builder.alternateRowColoring;
        this.string = builder.string;
        this.cellColors = builder.cellColors;
        this.setHorizontalAlignment(builder.horizontalAlignment);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.settings != null) {
            this.settings.updateColors();
        }
    }

    @Override
    public boolean columnShading() {
        return this.columnShading;
    }

    @Override
    public boolean alternateRowColoring() {
        return this.alternateRowColoring;
    }

    @Override
    public int horizontalAlignment() {
        return this.getHorizontalAlignment();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setForeground(this.settings.foregroundColor(this.cellColors.foregroundColor(row, this.columnIdentifier, value, isSelected)));
        this.setBackground(this.settings.backgroundColor(this.tableModel, row, this.columnIdentifier, this.columnShading, isSelected, this.cellColors.backgroundColor(row, this.columnIdentifier, value, isSelected)));
        this.setBorder(hasFocus || DefaultFilterTableCellRenderer.isSearchResult(((FilterTable)table).searchModel(), row, column) ? this.settings.focusedCellBorder() : this.settings.defaultCellBorder());
        if (this.toolTipData) {
            this.setToolTipText(value == null ? "" : value.toString());
        }
        return this;
    }

    @Override
    protected void setValue(Object value) {
        super.setValue(this.string.apply(value));
    }

    FilterTableCellRenderer.Settings<C> settings() {
        return this.settings;
    }

    private static boolean isSearchResult(FilterTableSearchModel searchModel, int row, int column) {
        return ((FilterTableSearchModel.RowColumn)searchModel.currentResult().get()).equals(row, column);
    }

    public static final class BooleanRenderer<R, C>
    extends NullableCheckBox
    implements TableCellRenderer,
    UIResource,
    FilterTableCellRenderer {
        private final FilterTableCellRenderer.Settings<C> settings;
        private final FilterTableModel<R, C> tableModel;
        private final C columnIdentifier;
        private final boolean columnShading;
        private final boolean alternateRowColoring;
        private final FilterTableCellRenderer.CellColors<C> cellColors;

        BooleanRenderer(DefaultFilterTableCellRendererBuilder<R, C> builder, FilterTableCellRenderer.Settings<C> settings) {
            super(new NullableToggleButtonModel());
            this.tableModel = Objects.requireNonNull(builder).tableModel;
            this.settings = Objects.requireNonNull(settings);
            this.settings.updateColors();
            this.columnIdentifier = Objects.requireNonNull(builder.columnIdentifier);
            this.columnShading = builder.columnShading;
            this.alternateRowColoring = builder.alternateRowColoring;
            this.cellColors = builder.cellColors;
            this.setHorizontalAlignment(builder.horizontalAlignment);
            this.setBorderPainted(true);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.settings != null) {
                this.settings.updateColors();
            }
        }

        @Override
        public boolean columnShading() {
            return this.columnShading;
        }

        @Override
        public boolean alternateRowColoring() {
            return this.alternateRowColoring;
        }

        @Override
        public int horizontalAlignment() {
            return this.getHorizontalAlignment();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.model().toggleState().set((Boolean)value);
            this.setForeground(this.settings.foregroundColor(this.cellColors.foregroundColor(row, this.columnIdentifier, value, isSelected)));
            this.setBackground(this.settings.backgroundColor(this.tableModel, row, this.columnIdentifier, this.columnShading, isSelected, this.cellColors.backgroundColor(row, this.columnIdentifier, value, isSelected)));
            this.setBorder(hasFocus || DefaultFilterTableCellRenderer.isSearchResult(((FilterTable)table).searchModel(), row, column) ? this.settings.focusedCellBorder() : this.settings.defaultCellBorder());
            return this;
        }
    }
}

