/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.state.State;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.component.table.FilterTableColumnModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

final class DefaultFilterTableColumnModel<C>
implements FilterTableColumnModel<C> {
    private final DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
    private final Event<C> columnHidden = Event.event();
    private final Event<C> columnShown = Event.event();
    private final Map<C, FilterTableColumn<C>> columns = new LinkedHashMap<C, FilterTableColumn<C>>();
    private final Map<Integer, C> columnIdentifiers = new HashMap<Integer, C>();
    private final Map<C, HiddenColumn> hiddenColumns = new LinkedHashMap<C, HiddenColumn>();
    private final Map<C, State> visibleStates = new HashMap<C, State>();
    private final State locked = State.state();

    DefaultFilterTableColumnModel(List<FilterTableColumn<C>> tableColumns) {
        if (Objects.requireNonNull(tableColumns, "columns").isEmpty()) {
            throw new IllegalArgumentException("One or more columns must be specified");
        }
        tableColumns.forEach(this::initializeColumn);
    }

    @Override
    public Collection<FilterTableColumn<C>> columns() {
        return Collections.unmodifiableCollection(this.columns.values());
    }

    @Override
    public State locked() {
        return this.locked;
    }

    @Override
    public void setVisibleColumns(C ... identifiers) {
        this.setVisibleColumns(Arrays.asList(identifiers));
    }

    @Override
    public void setVisibleColumns(List<C> identifiers) {
        Objects.requireNonNull(identifiers);
        identifiers.forEach(this::validateColumn);
        int columnIndex = 0;
        for (C c : identifiers) {
            this.visibleStates.get(c).set((Object)true);
            this.moveColumn(this.getColumnIndex(c), columnIndex++);
        }
        for (FilterTableColumn filterTableColumn : this.columns()) {
            if (identifiers.contains(filterTableColumn.identifier())) continue;
            this.visibleStates.get(filterTableColumn.identifier()).set((Object)false);
        }
        if (!identifiers.isEmpty()) {
            this.tableColumnModel.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    public List<FilterTableColumn<C>> visible() {
        ArrayList<FilterTableColumn> tableColumns = new ArrayList<FilterTableColumn>(this.tableColumnModel.getColumnCount());
        Enumeration<TableColumn> columnEnumeration = this.tableColumnModel.getColumns();
        while (columnEnumeration.hasMoreElements()) {
            tableColumns.add((FilterTableColumn)columnEnumeration.nextElement());
        }
        return Collections.unmodifiableList(tableColumns);
    }

    @Override
    public Collection<FilterTableColumn<C>> hidden() {
        return Collections.unmodifiableCollection(this.hiddenColumns.values().stream().map(hiddenColumn -> hiddenColumn.column).collect(Collectors.toList()));
    }

    @Override
    public FilterTableColumn<C> column(C identifier) {
        FilterTableColumn<C> column = this.columns.get(Objects.requireNonNull(identifier));
        if (column != null) {
            return column;
        }
        throw new IllegalArgumentException("Column not found: " + identifier);
    }

    @Override
    public boolean containsColumn(C identifier) {
        return this.columns.containsKey(Objects.requireNonNull(identifier));
    }

    @Override
    public State visible(C identifier) {
        return this.validateColumn(Objects.requireNonNull(identifier));
    }

    @Override
    public C identifier(int columnModelIndex) {
        C identifier = this.columnIdentifiers.get(columnModelIndex);
        if (identifier != null) {
            return identifier;
        }
        throw new IllegalArgumentException("Column at model index not found: " + columnModelIndex);
    }

    @Override
    public void resetColumns() {
        this.setVisibleColumns((List<C>)new ArrayList<C>(this.columns.keySet()));
    }

    @Override
    public void addColumn(TableColumn column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeColumn(TableColumn column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveColumn(int fromIndex, int toIndex) {
        this.tableColumnModel.moveColumn(fromIndex, toIndex);
    }

    @Override
    public void setColumnMargin(int columnMargin) {
        this.tableColumnModel.setColumnMargin(columnMargin);
    }

    @Override
    public int getColumnCount() {
        return this.tableColumnModel.getColumnCount();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.tableColumnModel.getColumns();
    }

    @Override
    public int getColumnIndex(Object columnIdentifier) {
        return this.tableColumnModel.getColumnIndex(columnIdentifier);
    }

    @Override
    public FilterTableColumn<C> getColumn(int columnIndex) {
        return (FilterTableColumn)this.tableColumnModel.getColumn(columnIndex);
    }

    @Override
    public int getColumnMargin() {
        return this.tableColumnModel.getColumnMargin();
    }

    @Override
    public int getColumnIndexAtX(int xPosition) {
        return this.tableColumnModel.getColumnIndexAtX(xPosition);
    }

    @Override
    public int getTotalColumnWidth() {
        return this.tableColumnModel.getTotalColumnWidth();
    }

    @Override
    public void setColumnSelectionAllowed(boolean columnSelectionAllowed) {
        this.tableColumnModel.setColumnSelectionAllowed(columnSelectionAllowed);
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.tableColumnModel.getColumnSelectionAllowed();
    }

    @Override
    public int[] getSelectedColumns() {
        return this.tableColumnModel.getSelectedColumns();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.tableColumnModel.getSelectedColumnCount();
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.tableColumnModel.setSelectionModel(listSelectionModel);
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.tableColumnModel.getSelectionModel();
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.tableColumnModel.addColumnModelListener(listener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.tableColumnModel.removeColumnModelListener(listener);
    }

    @Override
    public EventObserver<C> columnHidden() {
        return this.columnHidden.observer();
    }

    @Override
    public EventObserver<C> columnShown() {
        return this.columnShown.observer();
    }

    private void initializeColumn(FilterTableColumn<C> column) {
        C identifier = column.identifier();
        this.columns.put(identifier, column);
        this.columnIdentifiers.put(column.getModelIndex(), identifier);
        this.tableColumnModel.addColumn(column);
        this.visibleStates.put(identifier, this.createVisibleState(identifier));
    }

    private State createVisibleState(C identifier) {
        State visibleState = State.state((boolean)true);
        visibleState.addValidator(value -> this.checkIfLocked());
        visibleState.addConsumer(visible -> this.setColumnVisible(identifier, (boolean)visible));
        return visibleState;
    }

    private State validateColumn(C identifier) {
        State visibleState = this.visibleStates.get(identifier);
        if (visibleState == null) {
            throw new IllegalArgumentException("Column not found: " + identifier);
        }
        return visibleState;
    }

    private void setColumnVisible(C identifier, boolean visible) {
        if (visible) {
            this.showColumn(identifier);
        } else {
            this.hideColumn(identifier);
        }
    }

    private void showColumn(C identifier) {
        HiddenColumn column = this.hiddenColumns.get(identifier);
        if (column != null) {
            this.hiddenColumns.remove(identifier);
            this.tableColumnModel.addColumn(column.column);
            this.tableColumnModel.moveColumn(this.getColumnCount() - 1, column.indexWhenShown());
            this.columnShown.accept(identifier);
        }
    }

    private void hideColumn(C identifier) {
        if (!this.hiddenColumns.containsKey(identifier)) {
            HiddenColumn hiddenColumn = new HiddenColumn(this.column(identifier));
            this.hiddenColumns.put(identifier, hiddenColumn);
            this.tableColumnModel.removeColumn(hiddenColumn.column);
            this.columnHidden.accept(identifier);
        }
    }

    private void checkIfLocked() {
        if (((Boolean)this.locked.get()).booleanValue()) {
            throw new IllegalStateException("Column model is locked");
        }
    }

    private final class HiddenColumn {
        private final FilterTableColumn<C> column;
        private final Set<FilterTableColumn<C>> columnsToTheRight;

        private HiddenColumn(FilterTableColumn<C> column) {
            this.column = column;
            this.columnsToTheRight = this.columnsToTheRightOf(column);
        }

        private Set<FilterTableColumn<C>> columnsToTheRightOf(FilterTableColumn<C> column) {
            return IntStream.range(DefaultFilterTableColumnModel.this.tableColumnModel.getColumnIndex(column.identifier()) + 1, DefaultFilterTableColumnModel.this.tableColumnModel.getColumnCount()).mapToObj(columnIndex -> (FilterTableColumn)DefaultFilterTableColumnModel.this.tableColumnModel.getColumn(columnIndex)).collect(Collectors.toSet());
        }

        private int indexWhenShown() {
            for (int i = 0; i < DefaultFilterTableColumnModel.this.tableColumnModel.getColumnCount(); ++i) {
                if (!this.columnsToTheRight.contains(DefaultFilterTableColumnModel.this.tableColumnModel.getColumn(i))) continue;
                return i;
            }
            return DefaultFilterTableColumnModel.this.tableColumnModel.getColumnCount() - 1;
        }
    }
}

