/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.component.table.FilterTableColumnModel;
import is.codion.swing.common.ui.component.table.FilterTableSearchModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

final class DefaultFilterTableSearchModel<C>
implements FilterTableSearchModel {
    private static final FilterTableSearchModel.RowColumn NULL_COORDINATE = new DefaultRowColumn(-1, -1);
    private final FilterTableModel<?, C> tableModel;
    private final FilterTableColumnModel<C> columnModel;
    private final State caseSensitive = ((State.Builder)State.builder().listener(this::performSearch)).build();
    private final List<FilterTableSearchModel.RowColumn> searchResults = new ArrayList<FilterTableSearchModel.RowColumn>();
    private final Value<Predicate<String>> searchPredicate = Value.builder().nullable().listener(this::performSearch).build();
    private final Value<String> searchString = Value.builder().nonNull((Object)"").consumer(searchText -> this.searchPredicate.set(this.createSearchPredicate((String)searchText))).build();
    private final State regularExpression = ((State.Builder)State.builder().listener(() -> this.searchString.clear())).build();
    private final Value<FilterTableSearchModel.RowColumn> searchResult = Value.builder().nonNull((Object)NULL_COORDINATE).build();
    private int searchResultIndex = -1;

    DefaultFilterTableSearchModel(FilterTableModel<?, C> tableModel, FilterTableColumnModel<C> columnModel) {
        this.tableModel = Objects.requireNonNull(tableModel);
        this.columnModel = Objects.requireNonNull(columnModel);
        this.bindEvents();
    }

    @Override
    public State regularExpression() {
        return this.regularExpression;
    }

    @Override
    public State caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public Value<String> searchString() {
        return this.searchString;
    }

    @Override
    public Value<Predicate<String>> searchPredicate() {
        return this.searchPredicate;
    }

    @Override
    public List<FilterTableSearchModel.RowColumn> searchResults() {
        return Collections.unmodifiableList(new ArrayList<FilterTableSearchModel.RowColumn>(this.searchResults));
    }

    @Override
    public Optional<FilterTableSearchModel.RowColumn> nextResult() {
        return this.nextResult(false);
    }

    @Override
    public Optional<FilterTableSearchModel.RowColumn> selectNextResult() {
        return this.nextResult(true);
    }

    @Override
    public Optional<FilterTableSearchModel.RowColumn> previousResult() {
        return this.previousResult(false);
    }

    @Override
    public Optional<FilterTableSearchModel.RowColumn> selectPreviousResult() {
        return this.previousResult(true);
    }

    @Override
    public ValueObserver<FilterTableSearchModel.RowColumn> currentResult() {
        return this.searchResult.observer();
    }

    private Optional<FilterTableSearchModel.RowColumn> nextResult(boolean addToSelection) {
        if (this.searchResults.isEmpty()) {
            return this.emptyResult(addToSelection);
        }
        this.searchResultIndex = this.incrementSearchResultIndex();
        this.searchResult.set((Object)this.searchResults.get(this.searchResultIndex));
        return this.selectResult(addToSelection);
    }

    private Optional<FilterTableSearchModel.RowColumn> previousResult(boolean addToSelection) {
        if (this.searchResults.isEmpty()) {
            return this.emptyResult(addToSelection);
        }
        this.searchResultIndex = this.decrementSearchResultIndex();
        this.searchResult.set((Object)this.searchResults.get(this.searchResultIndex));
        return this.selectResult(addToSelection);
    }

    private Optional<FilterTableSearchModel.RowColumn> selectResult(boolean addToSelection) {
        if (addToSelection) {
            this.tableModel.selectionModel().selectedIndexes().add(((FilterTableSearchModel.RowColumn)this.searchResult.get()).row());
        } else {
            this.tableModel.selectionModel().selectedIndex().set((Object)((FilterTableSearchModel.RowColumn)this.searchResult.get()).row());
        }
        return this.searchResult.optional();
    }

    private Optional<FilterTableSearchModel.RowColumn> emptyResult(boolean addToSelection) {
        if (!addToSelection) {
            this.tableModel.selectionModel().clearSelection();
        }
        return Optional.empty();
    }

    private int incrementSearchResultIndex() {
        return this.searchResultIndex == -1 || this.searchResultIndex == this.searchResults.size() - 1 ? 0 : this.searchResultIndex + 1;
    }

    private int decrementSearchResultIndex() {
        return this.searchResultIndex == -1 || this.searchResultIndex == 0 ? this.searchResults.size() - 1 : this.searchResultIndex - 1;
    }

    private void performSearch() {
        this.clearSearchResults();
        if (this.searchPredicate.isNull() || this.tableModel.visibleCount() == 0 || this.tableModel.getColumnCount() == 0) {
            return;
        }
        Predicate predicate = (Predicate)this.searchPredicate.get();
        List<FilterTableColumn<C>> visibleColumns = this.columnModel.visible();
        for (int row = 0; row < this.tableModel.visibleCount(); ++row) {
            for (int columnIndex = 0; columnIndex < visibleColumns.size(); ++columnIndex) {
                FilterTableColumn<C> column = visibleColumns.get(columnIndex);
                if (!predicate.test(this.tableModel.getStringAt(row, column.identifier()))) continue;
                this.searchResults.add(new DefaultRowColumn(row, columnIndex));
            }
        }
    }

    private void clearSearchResults() {
        this.searchResults.clear();
        this.searchResultIndex = -1;
        this.searchResult.clear();
    }

    private void bindEvents() {
        this.columnModel.addColumnModelListener(new ClearSearchListener());
        this.tableModel.dataChanged().addListener(() -> {
            this.clearSearchResults();
            this.performSearch();
        });
    }

    private Predicate<String> createSearchPredicate(String searchText) {
        if (searchText.isEmpty()) {
            return null;
        }
        if (((Boolean)this.regularExpression.get()).booleanValue()) {
            try {
                return new RegexSearchCondition(searchText);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }
        return new StringSearchCondition(searchText, this.caseSensitive);
    }

    static final class DefaultRowColumn
    implements FilterTableSearchModel.RowColumn {
        private final int row;
        private final int column;

        DefaultRowColumn(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.column;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof DefaultRowColumn && ((DefaultRowColumn)obj).row() == this.row() && ((DefaultRowColumn)obj).column() == this.column();
        }

        public int hashCode() {
            return this.row + this.column;
        }

        public String toString() {
            return "row: " + this.row + ", column: " + this.column;
        }
    }

    private final class ClearSearchListener
    implements TableColumnModelListener {
        private ClearSearchListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            DefaultFilterTableSearchModel.this.clearSearchResults();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            DefaultFilterTableSearchModel.this.clearSearchResults();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            DefaultFilterTableSearchModel.this.clearSearchResults();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private static final class RegexSearchCondition
    implements Predicate<String> {
        private final Pattern pattern;

        private RegexSearchCondition(String patternString) {
            this.pattern = Pattern.compile(patternString);
        }

        @Override
        public boolean test(String item) {
            return item != null && this.pattern.matcher(item).find();
        }
    }

    private static final class StringSearchCondition
    implements Predicate<String> {
        private final String searchText;
        private final State caseSensitiveSearch;

        private StringSearchCondition(String searchText, State caseSensitiveSearch) {
            this.searchText = searchText;
            this.caseSensitiveSearch = caseSensitiveSearch;
        }

        @Override
        public boolean test(String item) {
            return item != null && ((Boolean)this.caseSensitiveSearch.get() != false ? item : item.toLowerCase()).contains((Boolean)this.caseSensitiveSearch.get() != false ? this.searchText : this.searchText.toLowerCase());
        }
    }
}

