/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.component.table.FilterTableSortModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.SortOrder;

final class DefaultFilterTableSortModel<R, C>
implements FilterTableSortModel<R, C> {
    private final FilterTableModel.Columns<R, C> columns;
    private final Map<C, Comparator<?>> columnComparators = new HashMap();
    private final Event<C> sortingChanged = Event.event();
    private final List<FilterTableSortModel.ColumnSortOrder<C>> columnSortOrders = new ArrayList<FilterTableSortModel.ColumnSortOrder<C>>(0);
    private final Set<C> columnSortingDisabled = new HashSet<C>();
    private final RowComparator comparator = new RowComparator();

    DefaultFilterTableSortModel(FilterTableModel.Columns<R, C> columns) {
        this.columns = columns;
    }

    @Override
    public Comparator<R> comparator() {
        return this.comparator;
    }

    @Override
    public SortOrder sortOrder(C identifier) {
        Objects.requireNonNull(identifier);
        return this.columnSortOrders.stream().filter(columnSortOrder -> columnSortOrder.identifier().equals(identifier)).findFirst().map(FilterTableSortModel.ColumnSortOrder::sortOrder).orElse(SortOrder.UNSORTED);
    }

    @Override
    public int sortPriority(C identifier) {
        Objects.requireNonNull(identifier);
        for (int i = 0; i < this.columnSortOrders.size(); ++i) {
            if (!this.columnSortOrders.get(i).identifier().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setSortOrder(C identifier, SortOrder sortOrder) {
        this.setSortOrder(identifier, sortOrder, false);
    }

    @Override
    public void addSortOrder(C identifier, SortOrder sortOrder) {
        this.setSortOrder(identifier, sortOrder, true);
    }

    @Override
    public boolean sorted() {
        return !this.columnSortOrders.isEmpty();
    }

    @Override
    public List<FilterTableSortModel.ColumnSortOrder<C>> columnSortOrder() {
        return Collections.unmodifiableList(this.columnSortOrders);
    }

    @Override
    public void clear() {
        if (!this.columnSortOrders.isEmpty()) {
            C firstSortColumn = this.columnSortOrders.get(0).identifier();
            this.columnSortOrders.clear();
            this.sortingChanged.accept(firstSortColumn);
        }
    }

    @Override
    public void setSortingEnabled(C identifier, boolean sortingEnabled) {
        Objects.requireNonNull(identifier);
        if (sortingEnabled) {
            this.columnSortingDisabled.remove(identifier);
        } else {
            this.columnSortingDisabled.add(identifier);
            if (this.removeSortOrder(identifier)) {
                this.sortingChanged.accept(identifier);
            }
        }
    }

    @Override
    public boolean isSortingEnabled(C identifier) {
        return !this.columnSortingDisabled.contains(Objects.requireNonNull(identifier));
    }

    @Override
    public EventObserver<C> sortingChanged() {
        return this.sortingChanged.observer();
    }

    private void setSortOrder(C identifier, SortOrder sortOrder, boolean addColumnToSort) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(sortOrder);
        if (!this.isSortingEnabled(identifier)) {
            throw new IllegalStateException("Sorting is disabled for column: " + identifier);
        }
        if (!addColumnToSort) {
            this.columnSortOrders.clear();
        } else {
            this.removeSortOrder(identifier);
        }
        if (sortOrder != SortOrder.UNSORTED) {
            this.columnSortOrders.add(new DefaultColumnSortOrder<C>(identifier, sortOrder));
        }
        this.sortingChanged.accept(identifier);
    }

    private boolean removeSortOrder(C identifier) {
        return this.columnSortOrders.removeIf(columnSortOrder -> columnSortOrder.identifier().equals(identifier));
    }

    private final class RowComparator
    implements Comparator<R> {
        private RowComparator() {
        }

        @Override
        public int compare(R rowOne, R rowTwo) {
            for (FilterTableSortModel.ColumnSortOrder columnSortOrder : DefaultFilterTableSortModel.this.columnSortOrders) {
                int comparison = this.compareRows(rowOne, rowTwo, columnSortOrder.identifier(), columnSortOrder.sortOrder());
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }

        private int compareRows(R rowOne, R rowTwo, C identifier, SortOrder sortOrder) {
            Object valueOne = DefaultFilterTableSortModel.this.columns.value(rowOne, identifier);
            Object valueTwo = DefaultFilterTableSortModel.this.columns.value(rowTwo, identifier);
            int comparison = valueOne == null && valueTwo == null ? 0 : (valueOne == null ? -1 : (valueTwo == null ? 1 : DefaultFilterTableSortModel.this.columnComparators.computeIfAbsent(identifier, k -> DefaultFilterTableSortModel.this.columns.comparator(identifier)).compare(valueOne, valueTwo)));
            if (comparison != 0) {
                return sortOrder == SortOrder.DESCENDING ? -comparison : comparison;
            }
            return 0;
        }
    }

    private static final class DefaultColumnSortOrder<C>
    implements FilterTableSortModel.ColumnSortOrder<C> {
        private final C identifier;
        private final SortOrder sortOrder;

        private DefaultColumnSortOrder(C identifier, SortOrder sortOrder) {
            this.identifier = identifier;
            this.sortOrder = sortOrder;
        }

        @Override
        public C identifier() {
            return this.identifier;
        }

        @Override
        public SortOrder sortOrder() {
            return this.sortOrder;
        }
    }
}

