/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.Operator;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.item.Item;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.combobox.ItemComboBoxModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.RadioButtonBuilder;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.combobox.ItemComboBoxBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.DefaultFilterFieldFactory;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.key.KeyEvents;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.FocusManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class FilterColumnConditionPanel<C, T>
extends ColumnConditionPanel<C, T> {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(FilterColumnConditionPanel.class, (ResourceBundle)ResourceBundle.getBundle(FilterColumnConditionPanel.class.getName()));
    private static final String UNKNOWN_OPERATOR = "Unknown operator: ";
    private static final List<Operator> LOWER_BOUND_OPERATORS = Arrays.asList(Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL, Operator.BETWEEN_EXCLUSIVE, Operator.BETWEEN, Operator.NOT_BETWEEN_EXCLUSIVE, Operator.NOT_BETWEEN);
    private static final List<Operator> UPPER_BOUND_OPERATORS = Arrays.asList(Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL, Operator.BETWEEN_EXCLUSIVE, Operator.BETWEEN, Operator.NOT_BETWEEN_EXCLUSIVE, Operator.NOT_BETWEEN);
    private final FieldFactory<C> fieldFactory;
    private final Event<C> focusGainedEvent = Event.event();
    private final TableColumn tableColumn;
    private JToggleButton toggleEnabledButton;
    private JComboBox<Item<Operator>> operatorCombo;
    private JComponent equalField;
    private JComponent upperBoundField;
    private JComponent lowerBoundField;
    private JComponent inField;
    private JPanel controlPanel;
    private JPanel inputPanel;
    private JPanel rangePanel;
    private boolean initialized = false;

    private FilterColumnConditionPanel(DefaultBuilder<C, T> builder) {
        super(builder.conditionModel, builder.caption);
        this.fieldFactory = builder.fieldFactory;
        this.tableColumn = builder.tableColumn;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI(this.toggleEnabledButton, this.operatorCombo, this.equalField, this.lowerBoundField, this.upperBoundField, this.inField, this.controlPanel, this.inputPanel, this.rangePanel);
    }

    @Override
    public Collection<JComponent> components() {
        return Stream.of(this.toggleEnabledButton, this.operatorCombo, this.equalField, this.lowerBoundField, this.upperBoundField, this.inField).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void requestInputFocus() {
        switch ((Operator)this.conditionModel().operator().get()) {
            case EQUAL: 
            case NOT_EQUAL: {
                this.equalField().ifPresent(JComponent::requestFocusInWindow);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN_EXCLUSIVE: 
            case BETWEEN: 
            case NOT_BETWEEN_EXCLUSIVE: 
            case NOT_BETWEEN: {
                this.lowerBoundField().ifPresent(JComponent::requestFocusInWindow);
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                this.upperBoundField().ifPresent(JComponent::requestFocusInWindow);
                break;
            }
            case IN: 
            case NOT_IN: {
                this.inField().ifPresent(JComponent::requestFocusInWindow);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNKNOWN_OPERATOR + this.conditionModel().operator().get());
            }
        }
    }

    @Override
    public Optional<EventObserver<C>> focusGainedEvent() {
        return Optional.of(this.focusGainedEvent);
    }

    public JComboBox<Item<Operator>> operatorComboBox() {
        this.initialize();
        return this.operatorCombo;
    }

    public Optional<JComponent> equalField() {
        this.initialize();
        return Optional.ofNullable(this.equalField);
    }

    public Optional<JComponent> upperBoundField() {
        this.initialize();
        return Optional.ofNullable(this.upperBoundField);
    }

    public Optional<JComponent> lowerBoundField() {
        this.initialize();
        return Optional.ofNullable(this.lowerBoundField);
    }

    public Optional<JComponent> inField() {
        this.initialize();
        return Optional.ofNullable(this.inField);
    }

    public static <C, T> Builder<C, T> builder(ColumnConditionModel<C, T> columnConditionModel) {
        return new DefaultBuilder<C, T>(columnConditionModel);
    }

    private JComponent createEqualField(FieldFactory<C> fieldFactory) {
        return this.equalFieldRequired() ? fieldFactory.createEqualField(this.conditionModel()) : null;
    }

    private JComponent createUpperBoundField(FieldFactory<C> fieldFactory) {
        return this.upperBoundFieldRequired() ? (JComponent)fieldFactory.createUpperBoundField(this.conditionModel()).orElse(null) : null;
    }

    private JComponent createLowerBoundField(FieldFactory<C> fieldFactory) {
        return this.lowerBoundFieldRequired() ? (JComponent)fieldFactory.createLowerBoundField(this.conditionModel()).orElse(null) : null;
    }

    private JComponent createInField(FieldFactory<C> fieldFactory) {
        return this.inFieldRequired() ? fieldFactory.createInField(this.conditionModel()) : null;
    }

    private boolean equalFieldRequired() {
        return this.conditionModel().operators().contains(Operator.EQUAL) || this.conditionModel().operators().contains(Operator.NOT_EQUAL);
    }

    private boolean upperBoundFieldRequired() {
        return this.conditionModel().operators().stream().anyMatch(UPPER_BOUND_OPERATORS::contains);
    }

    private boolean lowerBoundFieldRequired() {
        return this.conditionModel().operators().stream().anyMatch(LOWER_BOUND_OPERATORS::contains);
    }

    private boolean inFieldRequired() {
        return this.conditionModel().operators().contains(Operator.IN) || this.conditionModel().operators().contains(Operator.NOT_IN);
    }

    private void initialize() {
        if (!this.initialized) {
            this.setLayout(new BorderLayout());
            this.createComponents();
            this.bindEvents();
            this.controlPanel.add(this.operatorCombo, "Center");
            this.addStringConfigurationPopupMenu();
            this.onOperatorChanged((Operator)this.conditionModel().operator().get());
            this.initialized = true;
        }
    }

    private void createComponents() {
        this.controlPanel = new JPanel(new BorderLayout());
        this.inputPanel = new JPanel(new BorderLayout());
        this.rangePanel = new JPanel(new GridLayout(1, 2));
        this.toggleEnabledButton = (JToggleButton)((RadioButtonBuilder)((RadioButtonBuilder)Components.radioButton((Value<Boolean>)this.conditionModel().enabled()).horizontalAlignment(0)).popupMenu(radioButton -> Components.menu((Controls)Controls.builder().control((Control.Builder<?, ?>)Control.builder().toggle(this.conditionModel().autoEnable()).name(MESSAGES.getString("auto_enable"))).build()).createPopupMenu())).build();
        boolean modelLocked = (Boolean)this.conditionModel().locked().get();
        this.conditionModel().locked().set((Object)false);
        this.equalField = this.createEqualField(this.fieldFactory);
        this.upperBoundField = this.createUpperBoundField(this.fieldFactory);
        this.lowerBoundField = this.createLowerBoundField(this.fieldFactory);
        this.inField = this.createInField(this.fieldFactory);
        this.operatorCombo = this.createOperatorComboBox(this.conditionModel().operators());
        this.conditionModel().locked().set((Object)modelLocked);
        this.components().forEach(this::configureHorizontalAlignment);
    }

    private void configureHorizontalAlignment(JComponent component) {
        TableCellRenderer cellRenderer;
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).setHorizontalAlignment(0);
        } else if (this.tableColumn != null && (cellRenderer = this.tableColumn.getCellRenderer()) instanceof DefaultTableCellRenderer) {
            Component editorComponent;
            int horizontalAlignment = ((DefaultTableCellRenderer)cellRenderer).getHorizontalAlignment();
            if (component instanceof JTextField) {
                ((JTextField)component).setHorizontalAlignment(horizontalAlignment);
            } else if (component instanceof JComboBox && (editorComponent = ((JComboBox)component).getEditor().getEditorComponent()) instanceof JTextField) {
                ((JTextField)editorComponent).setHorizontalAlignment(horizontalAlignment);
            }
        }
    }

    private void bindEvents() {
        this.conditionModel().operator().addConsumer(this::onOperatorChanged);
        Utilities.linkToEnabledState(this.conditionModel().locked().not(), this.operatorCombo, this.equalField, this.upperBoundField, this.lowerBoundField, this.toggleEnabledButton);
        this.components().forEach(component -> component.addFocusListener(new FocusGained(this.conditionModel().identifier())));
        Collection fields = Stream.of(this.operatorCombo, this.toggleEnabledButton, this.equalField, this.upperBoundField, this.lowerBoundField, this.inField).filter(Objects::nonNull).collect(Collectors.toList());
        ControlKeys.TOGGLE_ENABLED.defaultKeystroke().optional().ifPresent(keyStroke -> KeyEvents.builder(keyStroke).action(Control.commandControl(this::toggleEnabled)).enable(fields));
        ControlKeys.PREVIOUS_OPERATOR.defaultKeystroke().optional().ifPresent(keyStroke -> KeyEvents.builder(keyStroke).action(Control.commandControl(this::selectPreviousOperator)).enable(fields));
        ControlKeys.NEXT_OPERATOR.defaultKeystroke().optional().ifPresent(keyStroke -> KeyEvents.builder(keyStroke).action(Control.commandControl(this::selectNextOperator)).enable(fields));
    }

    private void onOperatorChanged(Operator operator) {
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: {
                this.singleValuePanel(this.equalField);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                this.singleValuePanel(this.lowerBoundField);
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                this.singleValuePanel(this.upperBoundField);
                break;
            }
            case BETWEEN_EXCLUSIVE: 
            case BETWEEN: 
            case NOT_BETWEEN_EXCLUSIVE: 
            case NOT_BETWEEN: {
                this.rangePanel();
                break;
            }
            case IN: 
            case NOT_IN: {
                this.singleValuePanel(this.inField);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNKNOWN_OPERATOR + this.conditionModel().operator().get());
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void onStateChanged(ColumnConditionPanel.ConditionState conditionState) {
        switch (conditionState) {
            case HIDDEN: {
                this.setHidden();
                break;
            }
            case SIMPLE: {
                this.setSimple();
                break;
            }
            case ADVANCED: {
                this.setAdvanced();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown panel state: " + conditionState);
            }
        }
        this.revalidate();
    }

    private void setHidden() {
        this.removeAll();
    }

    private void setSimple() {
        boolean parentOfFocusOwner;
        this.initialize();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl = parentOfFocusOwner = Utilities.parentOfType(FilterColumnConditionPanel.class, focusOwner) == this;
        if (parentOfFocusOwner) {
            this.requestFocusInWindow(true);
        }
        this.remove(this.controlPanel);
        this.inputPanel.add((Component)this.toggleEnabledButton, "East");
        this.add((Component)this.inputPanel, "Center");
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.inputPanel.getPreferredSize().height));
        this.revalidate();
        if (parentOfFocusOwner) {
            focusOwner.requestFocusInWindow();
        }
    }

    private void setAdvanced() {
        boolean parentOfFocusOwner;
        this.initialize();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl = parentOfFocusOwner = Utilities.parentOfType(FilterColumnConditionPanel.class, focusOwner) == this;
        if (parentOfFocusOwner) {
            this.requestFocusInWindow(true);
        }
        this.controlPanel.add((Component)this.toggleEnabledButton, "East");
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.inputPanel, "Center");
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.controlPanel.getPreferredSize().height + this.inputPanel.getPreferredSize().height));
        this.revalidate();
        if (parentOfFocusOwner) {
            focusOwner.requestFocusInWindow();
        }
    }

    private JComboBox<Item<Operator>> createOperatorComboBox(List<Operator> operators) {
        ItemComboBoxModel operatorComboBoxModel = ItemComboBoxModel.itemComboBoxModel(operators.stream().map(operator -> Item.item((Object)operator, (String)FilterColumnConditionPanel.caption(operator))).collect(Collectors.toList()));
        return (JComboBox)((ItemComboBoxBuilder)((ItemComboBoxBuilder)Components.itemComboBox(operatorComboBoxModel, this.conditionModel().operator()).completionMode(Completion.Mode.NONE).renderer(new OperatorComboBoxRenderer()).maximumRowCount(operators.size()).mouseWheelScrollingWithWrapAround(true).toolTipText(((Operator)this.conditionModel().operator().get()).description())).onBuild(comboBox -> operatorComboBoxModel.selectedItem().addConsumer(selectedOperator -> comboBox.setToolTipText(((Operator)selectedOperator.value()).description())))).build();
    }

    private void selectNextOperator() {
        ItemComboBoxModel itemComboBoxModel = (ItemComboBoxModel)this.operatorCombo.getModel();
        List visibleItems = itemComboBoxModel.visibleItems();
        int index = visibleItems.indexOf(itemComboBoxModel.getSelectedItem());
        if (index < itemComboBoxModel.visibleCount() - 1) {
            itemComboBoxModel.setSelectedItem(visibleItems.get(index + 1));
        } else {
            itemComboBoxModel.setSelectedItem(visibleItems.get(0));
        }
    }

    private void toggleEnabled() {
        this.conditionModel().enabled().set((Object)((Boolean)this.conditionModel().enabled().get() == false ? 1 : 0));
    }

    private void selectPreviousOperator() {
        ItemComboBoxModel itemComboBoxModel = (ItemComboBoxModel)this.operatorCombo.getModel();
        List visibleItems = itemComboBoxModel.visibleItems();
        int index = visibleItems.indexOf(itemComboBoxModel.getSelectedItem());
        if (index > 0) {
            itemComboBoxModel.setSelectedItem(visibleItems.get(index - 1));
        } else {
            itemComboBoxModel.setSelectedItem(visibleItems.get(visibleItems.size() - 1));
        }
    }

    private void singleValuePanel(JComponent boundField) {
        if (!Arrays.asList(this.inputPanel.getComponents()).contains(boundField)) {
            boolean boundFieldHasFocus = this.boundFieldHasFocus();
            this.clearInputPanel(boundFieldHasFocus);
            this.inputPanel.add((Component)boundField, "Center");
            if (this.state().isEqualTo((Object)ColumnConditionPanel.ConditionState.SIMPLE)) {
                this.inputPanel.add((Component)this.toggleEnabledButton, "East");
            }
            if (boundFieldHasFocus) {
                boundField.requestFocusInWindow();
            }
        }
    }

    private void rangePanel() {
        if (!Arrays.asList(this.inputPanel.getComponents()).contains(this.rangePanel)) {
            boolean boundFieldHasFocus = this.boundFieldHasFocus();
            this.clearInputPanel(boundFieldHasFocus);
            this.rangePanel.add(this.lowerBoundField);
            this.rangePanel.add(this.upperBoundField);
            this.inputPanel.add((Component)this.rangePanel, "Center");
            if (this.state().isEqualTo((Object)ColumnConditionPanel.ConditionState.SIMPLE)) {
                this.inputPanel.add((Component)this.toggleEnabledButton, "East");
            }
            if (boundFieldHasFocus) {
                this.lowerBoundField.requestFocusInWindow();
            }
        }
    }

    private void clearInputPanel(boolean clearFocus) {
        if (clearFocus) {
            FocusManager.getCurrentManager().clearFocusOwner();
        }
        this.inputPanel.removeAll();
    }

    private boolean boundFieldHasFocus() {
        return FilterColumnConditionPanel.boundFieldHasFocus(this.equalField) || FilterColumnConditionPanel.boundFieldHasFocus(this.lowerBoundField) || FilterColumnConditionPanel.boundFieldHasFocus(this.upperBoundField) || FilterColumnConditionPanel.boundFieldHasFocus(this.inField);
    }

    private void addStringConfigurationPopupMenu() {
        if (this.isStringOrCharacter()) {
            Controls.ControlsBuilder controlsBuilder = Controls.builder();
            controlsBuilder.control((Control.Builder<?, ?>)Control.builder().toggle(this.conditionModel().caseSensitive()).name(MESSAGES.getString("case_sensitive")));
            if (this.conditionModel().columnClass().equals(String.class)) {
                controlsBuilder.control(this.createAutomaticWildcardControls());
            }
            JPopupMenu popupMenu = Components.menu(controlsBuilder).createPopupMenu();
            Stream.of(this.equalField, this.lowerBoundField, this.upperBoundField, this.inField).filter(Objects::nonNull).forEach(field -> field.setComponentPopupMenu(popupMenu));
        }
    }

    private boolean isStringOrCharacter() {
        return this.conditionModel().columnClass().equals(String.class) || this.conditionModel().columnClass().equals(Character.class);
    }

    private Controls createAutomaticWildcardControls() {
        Value automaticWildcardValue = this.conditionModel().automaticWildcard();
        ColumnConditionModel.AutomaticWildcard automaticWildcard = (ColumnConditionModel.AutomaticWildcard)automaticWildcardValue.get();
        State automaticWildcardNoneState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.NONE));
        State automaticWildcardPostfixState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.POSTFIX));
        State automaticWildcardPrefixState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.PREFIX));
        State automaticWildcardPrefixAndPostfixState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.PREFIX_AND_POSTFIX));
        State.group((State[])new State[]{automaticWildcardNoneState, automaticWildcardPostfixState, automaticWildcardPrefixState, automaticWildcardPrefixAndPostfixState});
        automaticWildcardNoneState.addConsumer(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.NONE);
            }
        });
        automaticWildcardPostfixState.addConsumer(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.POSTFIX);
            }
        });
        automaticWildcardPrefixState.addConsumer(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.PREFIX);
            }
        });
        automaticWildcardPrefixAndPostfixState.addConsumer(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.PREFIX_AND_POSTFIX);
            }
        });
        return (Controls)((Controls.ControlsBuilder)Controls.builder().name(MESSAGES.getString("automatic_wildcard"))).control((Control.Builder<?, ?>)Control.builder().toggle(automaticWildcardNoneState).name(ColumnConditionModel.AutomaticWildcard.NONE.description())).control((Control.Builder<?, ?>)Control.builder().toggle(automaticWildcardPostfixState).name(ColumnConditionModel.AutomaticWildcard.POSTFIX.description())).control((Control.Builder<?, ?>)Control.builder().toggle(automaticWildcardPrefixState).name(ColumnConditionModel.AutomaticWildcard.PREFIX.description())).control((Control.Builder<?, ?>)Control.builder().toggle(automaticWildcardPrefixAndPostfixState).name(ColumnConditionModel.AutomaticWildcard.PREFIX_AND_POSTFIX.description())).build();
    }

    private static boolean boundFieldHasFocus(JComponent field) {
        if (field == null) {
            return false;
        }
        if (field.hasFocus()) {
            return true;
        }
        if (field instanceof JComboBox) {
            return ((JComboBox)field).getEditor().getEditorComponent().hasFocus();
        }
        return false;
    }

    private static String caption(Operator operator) {
        switch (Objects.requireNonNull(operator)) {
            case EQUAL: {
                return "\u03b1 =";
            }
            case NOT_EQUAL: {
                return "\u03b1 \u2260";
            }
            case LESS_THAN: {
                return "\u03b1 <";
            }
            case LESS_THAN_OR_EQUAL: {
                return "\u03b1 \u2264";
            }
            case GREATER_THAN: {
                return "\u03b1 >";
            }
            case GREATER_THAN_OR_EQUAL: {
                return "\u03b1 \u2265";
            }
            case BETWEEN_EXCLUSIVE: {
                return "< \u03b1 <";
            }
            case BETWEEN: {
                return "\u2264 \u03b1 \u2264";
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return "\u2265 \u03b1 \u2265";
            }
            case NOT_BETWEEN: {
                return "> \u03b1 >";
            }
            case IN: {
                return "\u03b1 \u2208";
            }
            case NOT_IN: {
                return "\u03b1 \u2209";
            }
        }
        throw new IllegalArgumentException(UNKNOWN_OPERATOR + operator);
    }

    private static final class DefaultBuilder<C, T>
    implements Builder<C, T> {
        private final ColumnConditionModel<C, T> conditionModel;
        private String caption;
        private FieldFactory<C> fieldFactory = new DefaultFilterFieldFactory();
        private TableColumn tableColumn;

        private DefaultBuilder(ColumnConditionModel<C, T> conditionModel) {
            this.conditionModel = Objects.requireNonNull(conditionModel);
            this.caption = conditionModel.identifier().toString();
        }

        @Override
        public Builder<C, T> caption(String caption) {
            this.caption = Objects.requireNonNull(caption);
            return this;
        }

        @Override
        public Builder<C, T> fieldFactory(FieldFactory<C> fieldFactory) {
            if (!Objects.requireNonNull(fieldFactory).supportsType(this.conditionModel.columnClass())) {
                throw new IllegalArgumentException("Field factory does not support the column value type: " + this.conditionModel.columnClass());
            }
            this.fieldFactory = Objects.requireNonNull(fieldFactory);
            return this;
        }

        @Override
        public Builder<C, T> tableColumn(TableColumn tableColumn) {
            this.tableColumn = Objects.requireNonNull(tableColumn);
            return this;
        }

        @Override
        public FilterColumnConditionPanel<C, T> build() {
            return new FilterColumnConditionPanel(this);
        }
    }

    public static interface FieldFactory<C> {
        public boolean supportsType(Class<?> var1);

        public JComponent createEqualField(ColumnConditionModel<C, ?> var1);

        public Optional<JComponent> createUpperBoundField(ColumnConditionModel<C, ?> var1);

        public Optional<JComponent> createLowerBoundField(ColumnConditionModel<C, ?> var1);

        public JComponent createInField(ColumnConditionModel<C, ?> var1);
    }

    public static final class ControlKeys {
        public static final ControlKey<ToggleControl> TOGGLE_ENABLED = ToggleControl.key("toggleEnabled", KeyEvents.keyStroke(10, 128));
        public static final ControlKey<CommandControl> PREVIOUS_OPERATOR = CommandControl.key("previousOperator", KeyEvents.keyStroke(38, 128));
        public static final ControlKey<CommandControl> NEXT_OPERATOR = CommandControl.key("nextOperator", KeyEvents.keyStroke(40, 128));

        private ControlKeys() {
        }
    }

    private static final class OperatorComboBoxRenderer
    implements ListCellRenderer<Item<Operator>> {
        private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

        private OperatorComboBoxRenderer() {
            this.listCellRenderer.setHorizontalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Item<Operator>> list, Item<Operator> value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.listCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private final class FocusGained
    extends FocusAdapter {
        private final C identifier;

        private FocusGained(C identifier) {
            this.identifier = identifier;
        }

        @Override
        public void focusGained(FocusEvent e) {
            FilterColumnConditionPanel.this.focusGainedEvent.accept(this.identifier);
        }
    }

    public static interface Builder<C, T> {
        public Builder<C, T> caption(String var1);

        public Builder<C, T> fieldFactory(FieldFactory<C> var1);

        public Builder<C, T> tableColumn(TableColumn var1);

        public FilterColumnConditionPanel<C, T> build();
    }
}

