/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.i18n.Messages;
import is.codion.common.item.Item;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableSummaryModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.combobox.ItemComboBoxModel;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.model.component.table.FilterTableSelectionModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.ColumnSelectionPanel;
import is.codion.swing.common.ui.component.table.DefaultFilterFieldFactory;
import is.codion.swing.common.ui.component.table.DefaultFilterPanelFactory;
import is.codion.swing.common.ui.component.table.DefaultFilterTableColumnModel;
import is.codion.swing.common.ui.component.table.DefaultFilterTableSearchModel;
import is.codion.swing.common.ui.component.table.DefaultFilterTableSortModel;
import is.codion.swing.common.ui.component.table.FilterColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilterTableCellEditorFactory;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilterTableCellRendererFactory;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.component.table.FilterTableColumnModel;
import is.codion.swing.common.ui.component.table.FilterTableHeaderRenderer;
import is.codion.swing.common.ui.component.table.FilterTableSearchModel;
import is.codion.swing.common.ui.component.table.FilterTableSortModel;
import is.codion.swing.common.ui.component.table.TableConditionPanel;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class FilterTable<R, C>
extends JTable {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(FilterTable.class, (ResourceBundle)ResourceBundle.getBundle(FilterTable.class.getName()));
    public static final PropertyValue<Integer> AUTO_RESIZE_MODE = Configuration.integerValue((String)(FilterTable.class.getName() + ".autoResizeMode"), (int)0);
    public static final PropertyValue<Boolean> ALLOW_COLUMN_REORDERING = Configuration.booleanValue((String)(FilterTable.class.getName() + ".allowColumnReordering"), (boolean)true);
    private static final String SELECT = "select";
    private static final String SELECT_COLUMNS = "select_columns";
    private static final String RESET = "reset";
    private static final String RESET_COLUMNS_DESCRIPTION = "reset_columns_description";
    private static final String SINGLE_SELECTION_MODE = "single_selection_mode";
    private static final String AUTO_RESIZE = "auto_resize";
    private static final List<Item<Integer>> AUTO_RESIZE_MODES = Arrays.asList(Item.item((Object)0, (String)MESSAGES.getString("resize_off")), Item.item((Object)1, (String)MESSAGES.getString("resize_next_column")), Item.item((Object)2, (String)MESSAGES.getString("resize_subsequent_columns")), Item.item((Object)3, (String)MESSAGES.getString("resize_last_column")), Item.item((Object)4, (String)MESSAGES.getString("resize_all_columns")));
    private static final int SEARCH_FIELD_MINIMUM_WIDTH = 100;
    private static final int COLUMN_RESIZE_AMOUNT = 10;
    private final FilterTableModel<R, C> tableModel;
    private final FilterTableSearchModel searchModel;
    private final FilterTableSortModel<R, C> sortModel;
    private final TableSummaryModel<C> summaryModel;
    private final TableConditionPanel.Factory<C> filterPanelFactory;
    private final FilterColumnConditionPanel.FieldFactory<C> filterFieldFactory;
    private final Event<MouseEvent> doubleClick = Event.event();
    private final Value<Action> doubleClickAction;
    private final State sortingEnabled;
    private final State scrollToSelectedItem;
    private final Value<CenterOnScroll> centerOnScroll;
    private final ScrollToColumn scrollToColumn = new ScrollToColumn();
    private final ControlMap controlMap;
    private TableConditionPanel<C> filterPanel;
    private JTextField searchField;

    private FilterTable(DefaultBuilder<R, C> builder) {
        super((TableModel)builder.tableModel, new DefaultFilterTableColumnModel(builder.columns), (ListSelectionModel)builder.tableModel.selectionModel());
        ColumnSummaryModel.SummaryValues.Factory factory;
        this.tableModel = builder.tableModel;
        this.sortModel = new DefaultFilterTableSortModel(this.tableModel.columns());
        this.searchModel = new DefaultFilterTableSearchModel<C>(this.tableModel, this.columnModel());
        if (builder.summaryValuesFactory == null) {
            ColumnSummaryModel.SummaryValues.Factory factory2;
            factory = factory2;
            super();
        } else {
            factory = builder.summaryValuesFactory;
        }
        this.summaryModel = TableSummaryModel.tableSummaryModel(factory);
        this.filterPanelFactory = builder.filterPanelFactory;
        this.filterFieldFactory = builder.filterFieldFactory;
        this.centerOnScroll = Value.builder().nonNull((Object)CenterOnScroll.NEITHER).initialValue((Object)builder.centerOnScroll).build();
        this.doubleClickAction = Value.value((Object)builder.doubleClickAction);
        this.scrollToSelectedItem = State.state((boolean)builder.scrollToSelectedItem);
        this.sortingEnabled = State.state((boolean)builder.sortingEnabled);
        this.controlMap = builder.controlMap;
        this.controlMap.control(ControlKeys.COPY_CELL).set((Object)this.createCopyCellControl());
        this.controlMap.control(ControlKeys.TOGGLE_SORT_COLUMN).set((Object)this.createToggleSortColumnControl());
        this.controlMap.control(ControlKeys.TOGGLE_SORT_COLUMN_ADD).set((Object)this.createToggleSortColumnAddControl());
        if (builder.filterState != ColumnConditionPanel.ConditionState.HIDDEN) {
            this.filterPanel().state().set((Object)builder.filterState);
        }
        this.autoStartsEdit(builder.autoStartsEdit);
        this.setSelectionMode(builder.selectionMode);
        this.setAutoResizeMode(builder.autoResizeMode);
        this.configureColumns(builder.cellRendererFactory, builder.cellEditorFactory);
        this.configureTableHeader(builder.columnReorderingAllowed, builder.columnResizingAllowed);
        this.bindEvents(builder.columnReorderingAllowed, builder.columnResizingAllowed);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI(this.getTableHeader(), this.searchField, this.filterPanel);
        Utilities.updateUI(this.columnModel().hidden().stream().flatMap(FilterTable::columnComponents).collect(Collectors.toList()));
    }

    public FilterTableModel<R, C> getModel() {
        return (FilterTableModel)super.getModel();
    }

    public FilterTableModel<R, C> model() {
        return this.getModel();
    }

    @Override
    public FilterTableColumnModel<C> getColumnModel() {
        return (FilterTableColumnModel)super.getColumnModel();
    }

    public FilterTableColumnModel<C> columnModel() {
        return this.getColumnModel();
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (this.tableModel != null) {
            throw new IllegalStateException("Table model has already been set");
        }
        if (!(dataModel instanceof FilterTableModel)) {
            throw new IllegalArgumentException("FilterTable model must be a FilterTableModel instance");
        }
        List selection = (List)((FilterTableModel)dataModel).selectionModel().selectedItems().get();
        super.setModel(dataModel);
        if (!selection.isEmpty()) {
            ((FilterTableModel)dataModel).selectionModel().selectedItems().set((Object)selection);
        }
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        if (this.columnModel != null) {
            throw new IllegalStateException("Column model has already been set");
        }
        if (!(columnModel instanceof FilterTableColumnModel)) {
            throw new IllegalArgumentException("FilterTable column model must be a FilterTableColumnModel instance");
        }
        super.setColumnModel(columnModel);
    }

    @Override
    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (this.selectionModel != null) {
            throw new IllegalStateException("Selection model has already been set");
        }
        if (!(selectionModel instanceof FilterTableSelectionModel)) {
            throw new IllegalArgumentException("FilterTable selection model must be a FilterTableSelectionModel instance");
        }
        super.setSelectionModel(selectionModel);
    }

    public TableConditionPanel<C> filterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = this.filterPanelFactory.create(this.tableModel.filterModel(), this.createColumnFilterPanels(), this.columnModel(), this::configureTableConditionPanel);
        }
        return this.filterPanel;
    }

    public FilterTableSearchModel searchModel() {
        return this.searchModel;
    }

    public FilterTableSortModel<R, C> sortModel() {
        return this.sortModel;
    }

    public TableSummaryModel<C> summaryModel() {
        return this.summaryModel;
    }

    public JTextField searchField() {
        if (this.searchField == null) {
            this.searchField = this.createSearchField();
        }
        return this.searchField;
    }

    public Value<Action> doubleClickAction() {
        return this.doubleClickAction;
    }

    public State sortingEnabled() {
        return this.sortingEnabled;
    }

    public State scrollToSelectedItem() {
        return this.scrollToSelectedItem;
    }

    public Value<CenterOnScroll> centerOnScroll() {
        return this.centerOnScroll;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.tableModel.selectionModel().setSelectionMode(selectionMode);
    }

    public void selectColumns() {
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(this.columnModel());
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog(columnSelectionPanel).owner(this.getParent())).title(MESSAGES.getString(SELECT_COLUMNS))).onShown(dialog -> columnSelectionPanel.requestColumnPanelFocus())).onOk(columnSelectionPanel::applyChanges).show();
    }

    public void selectAutoResizeMode() {
        ItemComboBoxModel<Integer> autoResizeComboBoxModel = this.createAutoResizeModeComboBoxModel();
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog(((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)Components.itemComboBox(autoResizeComboBoxModel).build()).border(Borders.emptyBorder())).build()).owner(this.getParent())).title(MESSAGES.getString(AUTO_RESIZE))).onOk(() -> this.setAutoResizeMode((Integer)((Item)autoResizeComboBoxModel.selectedValue()).value())).show();
    }

    public boolean cellVisible(int row, int column) {
        JViewport viewport = Utilities.parentOfType(JViewport.class, this);
        return viewport != null && this.cellVisible(viewport, row, column);
    }

    public void scrollToColumn(C identifier) {
        Objects.requireNonNull(identifier);
        JViewport viewport = Utilities.parentOfType(JViewport.class, this);
        if (viewport != null) {
            this.scrollToRowColumn(viewport, this.rowAtPoint(viewport.getViewPosition()), this.columnModel().getColumnIndex(identifier), CenterOnScroll.NEITHER);
        }
    }

    public void scrollToCoordinate(int row, int column, CenterOnScroll centerOnScroll) {
        Objects.requireNonNull(centerOnScroll);
        JViewport viewport = Utilities.parentOfType(JViewport.class, this);
        if (viewport != null) {
            this.scrollToRowColumn(viewport, row, column, centerOnScroll);
        }
    }

    public void copySelectedCell() {
        int selectedRow = this.getSelectedRow();
        int selectedColumn = this.getSelectedColumn();
        if (selectedRow >= 0 && selectedColumn >= 0) {
            TableColumn column = this.columnModel().getColumn(selectedColumn);
            Utilities.setClipboard(this.model().getStringAt(selectedRow, ((FilterTableColumn)column).identifier()));
        }
    }

    public void copyToClipboard() {
        Utilities.setClipboard(this.export().delimiter('\t').selected(!this.selectionModel.isSelectionEmpty()).get());
    }

    public void copySelectedToClipboard() {
        Utilities.setClipboard(this.export().delimiter('\t').selected(true).get());
    }

    public Export export() {
        return new DefaultExport();
    }

    public CommandControl createSelectColumnsControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::selectColumns).name(MESSAGES.getString(SELECT) + "...")).enabled(this.columnModel().locked().not())).description(MESSAGES.getString(SELECT_COLUMNS))).build();
    }

    public Controls createToggleColumnsControls() {
        return (Controls)((Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(MESSAGES.getString(SELECT))).enabled(this.columnModel().locked().not())).controls(this.columnModel().columns().stream().sorted(new ColumnComparator()).map(this::createToggleColumnControl).collect(Collectors.toList())).build();
    }

    public CommandControl createResetColumnsControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.columnModel()::resetColumns).name(MESSAGES.getString(RESET))).enabled(this.columnModel().locked().not())).description(MESSAGES.getString(RESET_COLUMNS_DESCRIPTION))).build();
    }

    public CommandControl createSelectAutoResizeModeControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)Control.builder().command(this::selectAutoResizeMode).name(MESSAGES.getString(AUTO_RESIZE) + "...")).build();
    }

    public Controls createToggleAutoResizeModelControls() {
        return (Controls)((Controls.ControlsBuilder)Controls.builder().name(MESSAGES.getString(AUTO_RESIZE))).controls(this.createAutoResizeModeControls()).build();
    }

    public ToggleControl createSingleSelectionModeControl() {
        return (ToggleControl)((ToggleControl.ToggleControlBuilder)Control.builder().toggle(this.tableModel.selectionModel().singleSelectionMode()).name(MESSAGES.getString(SINGLE_SELECTION_MODE))).build();
    }

    public CommandControl createCopyCellControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::copySelectedCell).name(MESSAGES.getString("copy_cell"))).enabled(this.tableModel.selectionModel().selectionNotEmpty())).build();
    }

    public void autoStartsEdit(boolean autoStartsEdit) {
        this.putClientProperty("JTable.autoStartsEdit", autoStartsEdit);
    }

    public EventObserver<MouseEvent> doubleClick() {
        return this.doubleClick.observer();
    }

    public static <T extends Number, C> ColumnSummaryModel.SummaryValues<T> summaryValues(C identifier, FilterTableModel<?, C> tableModel, Format format) {
        return new DefaultSummaryValues(identifier, tableModel, format);
    }

    public static <R, C> Builder<R, C> builder(FilterTableModel<R, C> tableModel, List<FilterTableColumn<C>> columns) {
        return new DefaultBuilder<R, C>(Objects.requireNonNull(tableModel), Objects.requireNonNull(columns));
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new FilterTableHeader(this.columnModel);
    }

    private JTextField createSearchField() {
        CommandControl nextResult = Control.commandControl(() -> this.selectSearchResult(false, true));
        CommandControl selectNextResult = Control.commandControl(() -> this.selectSearchResult(true, true));
        CommandControl previousResult = Control.commandControl(() -> this.selectSearchResult(false, false));
        CommandControl selectPreviousResult = Control.commandControl(() -> this.selectSearchResult(true, false));
        CommandControl requestTableFocus = Control.commandControl(this::requestFocusInWindow);
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)Components.stringField(this.searchModel.searchString()).minimumWidth(100)).preferredWidth(100)).selectAllOnFocusGained(true)).keyEvent(KeyEvents.builder(10).action(nextResult))).keyEvent(KeyEvents.builder(10).modifiers(64).action(selectNextResult))).keyEvent(KeyEvents.builder(40).action(nextResult))).keyEvent(KeyEvents.builder(40).modifiers(64).action(selectNextResult))).keyEvent(KeyEvents.builder(38).action(previousResult))).keyEvent(KeyEvents.builder(38).modifiers(64).action(selectPreviousResult))).keyEvent(KeyEvents.builder(27).action(requestTableFocus))).popupMenuControls(textField -> this.searchFieldPopupMenuControls())).hint(Messages.find() + "...").onTextChanged(this::onSearchTextChanged)).onBuild(field -> KeyEvents.builder(70).modifiers(128).action(Control.commandControl(field::requestFocusInWindow)).condition(1).enable(this))).build();
    }

    private void selectSearchResult(boolean addToSelection, boolean next) {
        this.searchResult(addToSelection, next).ifPresent(rowColumn -> {
            if (!addToSelection) {
                this.setColumnSelectionInterval(rowColumn.column(), rowColumn.column());
            }
            this.scrollToCoordinate(rowColumn.row(), rowColumn.column(), (CenterOnScroll)((Object)((Object)this.centerOnScroll.get())));
        });
    }

    private Optional<FilterTableSearchModel.RowColumn> searchResult(boolean addToSelection, boolean next) {
        if (next) {
            return addToSelection ? this.searchModel.selectNextResult() : this.searchModel.nextResult();
        }
        return addToSelection ? this.searchModel.selectPreviousResult() : this.searchModel.previousResult();
    }

    private void onSearchTextChanged(String searchText) {
        if (!searchText.isEmpty()) {
            this.searchModel.nextResult();
        }
    }

    private void toggleColumnSorting(int selectedColumn, boolean add) {
        Object identifier;
        if (((Boolean)this.sortingEnabled.get()).booleanValue() && selectedColumn != -1 && this.sortModel.isSortingEnabled(identifier = ((FilterTableColumn)this.columnModel().getColumn(selectedColumn)).identifier())) {
            if (add) {
                this.sortModel.addSortOrder(identifier, FilterTableSortModel.nextSortOrder(this.sortModel.sortOrder(identifier)));
            } else {
                this.sortModel.setSortOrder(identifier, FilterTableSortModel.nextSortOrder(this.sortModel.sortOrder(identifier)));
            }
        }
    }

    private Controls searchFieldPopupMenuControls() {
        return (Controls)Controls.builder().control((Control.Builder<?, ?>)Control.builder().toggle(this.searchModel.caseSensitive()).name(MESSAGES.getString("case_sensitive_search"))).control((Control.Builder<?, ?>)Control.builder().toggle(this.searchModel.regularExpression()).name(MESSAGES.getString("regular_expression_search"))).build();
    }

    private boolean cellVisible(JViewport viewport, int row, int column) {
        Rectangle cellRect = this.getCellRect(row, column, true);
        Point viewPosition = viewport.getViewPosition();
        cellRect.setLocation(cellRect.x - viewPosition.x, cellRect.y - viewPosition.y);
        return new Rectangle(viewport.getExtentSize()).contains(cellRect);
    }

    private void scrollToRowColumn(JViewport viewport, int row, int column, CenterOnScroll centerOnScroll) {
        Rectangle cellRectangle = this.getCellRect(row, column, true);
        Rectangle viewRectangle = viewport.getViewRect();
        cellRectangle.setLocation(cellRectangle.x - viewRectangle.x, cellRectangle.y - viewRectangle.y);
        int x = cellRectangle.x;
        int y = cellRectangle.y;
        if (centerOnScroll != CenterOnScroll.NEITHER) {
            if ((centerOnScroll == CenterOnScroll.COLUMN || centerOnScroll == CenterOnScroll.BOTH) && cellRectangle.x < (x = (viewRectangle.width - cellRectangle.width) / 2)) {
                x = -x;
            }
            if ((centerOnScroll == CenterOnScroll.ROW || centerOnScroll == CenterOnScroll.BOTH) && cellRectangle.y < (y = (viewRectangle.height - cellRectangle.height) / 2)) {
                y = -y;
            }
            cellRectangle.translate(x, y);
        }
        viewport.scrollRectToVisible(cellRectangle);
    }

    private ToggleControl createToggleColumnControl(FilterTableColumn<C> column) {
        return (ToggleControl)((ToggleControl.ToggleControlBuilder)((ToggleControl.ToggleControlBuilder)Control.builder().toggle(this.columnModel().visible(column.identifier())).name(String.valueOf(column.getHeaderValue()))).description(column.toolTipText().orElse(null))).build();
    }

    private void configureColumns(FilterTableCellRendererFactory<C> cellRendererFactory, FilterTableCellEditorFactory<C> cellEditorFactory) {
        this.columnModel().columns().stream().filter(column -> column.getCellRenderer() == null).forEach(column -> column.setCellRenderer(cellRendererFactory.tableCellRenderer((FilterTableColumn)column)));
        this.columnModel().columns().stream().filter(column -> column.getHeaderRenderer() == null).forEach(column -> column.setHeaderRenderer(new FilterTableHeaderRenderer(this, column)));
        this.columnModel().columns().stream().filter(column -> column.getCellEditor() == null).forEach(column -> cellEditorFactory.tableCellEditor((FilterTableColumn)column).ifPresent(column::setCellEditor));
    }

    private void configureTableHeader(boolean reorderingAllowed, boolean columnResizingAllowed) {
        JTableHeader header = this.getTableHeader();
        header.setFocusable(false);
        header.setReorderingAllowed(reorderingAllowed);
        header.setResizingAllowed(columnResizingAllowed);
        header.setAutoscrolls(true);
        header.addMouseMotionListener(new ColumnDragMouseHandler());
        header.addMouseListener(new MouseSortHandler());
    }

    private ItemComboBoxModel<Integer> createAutoResizeModeComboBoxModel() {
        ItemComboBoxModel autoResizeComboBoxModel = ItemComboBoxModel.itemComboBoxModel(AUTO_RESIZE_MODES);
        autoResizeComboBoxModel.setSelectedItem(AUTO_RESIZE_MODES.get(this.getAutoResizeMode()));
        return autoResizeComboBoxModel;
    }

    private List<ToggleControl> createAutoResizeModeControls() {
        ArrayList<ToggleControl> controls = new ArrayList<ToggleControl>();
        State.Group group = State.group((State[])new State[0]);
        for (Item<Integer> resizeMode : AUTO_RESIZE_MODES) {
            State state = State.state((boolean)((Integer)resizeMode.value()).equals(this.getAutoResizeMode()));
            group.add(state);
            state.addConsumer(enabled -> {
                if (enabled.booleanValue()) {
                    this.setAutoResizeMode((Integer)resizeMode.value());
                }
            });
            controls.add((ToggleControl)((ToggleControl.ToggleControlBuilder)Control.builder().toggle(state).name(resizeMode.caption())).build());
        }
        this.addPropertyChangeListener("autoResizeMode", changeEvent -> ((ToggleControl)controls.get((Integer)changeEvent.getNewValue())).value().set((Object)true));
        return controls;
    }

    private void bindEvents(boolean columnReorderingAllowed, boolean columnResizingAllowed) {
        this.columnModel().columnHidden().addConsumer(this::onColumnHidden);
        this.tableModel.selectionModel().selectedIndexes().addConsumer((Consumer)new ScrollToSelected());
        this.tableModel.filterModel().conditionChanged().addListener(this.getTableHeader()::repaint);
        this.searchModel.currentResult().addListener(this::repaint);
        this.sortModel.sortingChanged().addListener(this.getTableHeader()::repaint);
        this.sortModel.sortingChanged().addListener(() -> this.tableModel.comparator().set(this.sortModel.sorted() ? this.sortModel.comparator() : null));
        this.addMouseListener(new FilterTableMouseListener());
        this.addKeyListener(new MoveResizeColumnKeyListener(columnReorderingAllowed, columnResizingAllowed));
        this.controlMap.keyEvent(ControlKeys.COPY_CELL).ifPresent(keyEvent -> keyEvent.enable(this));
        this.controlMap.keyEvent(ControlKeys.TOGGLE_SORT_COLUMN_ADD).ifPresent(keyEvent -> keyEvent.enable(this));
        this.controlMap.keyEvent(ControlKeys.TOGGLE_SORT_COLUMN).ifPresent(keyEvent -> keyEvent.enable(this));
    }

    private void onColumnHidden(C identifier) {
        ColumnConditionModel filterModel = (ColumnConditionModel)this.tableModel.filterModel().conditionModels().get(identifier);
        if (filterModel != null && !((Boolean)filterModel.locked().get()).booleanValue()) {
            filterModel.enabled().set((Object)false);
        }
    }

    private CommandControl createToggleSortColumnAddControl() {
        return Control.commandControl(() -> this.toggleColumnSorting(this.getSelectedColumn(), true));
    }

    private CommandControl createToggleSortColumnControl() {
        return Control.commandControl(() -> this.toggleColumnSorting(this.getSelectedColumn(), false));
    }

    private static Stream<JComponent> columnComponents(FilterTableColumn<?> column) {
        ArrayList<JComponent> components = new ArrayList<JComponent>(3);
        FilterTable.addIfComponent(components, column.getCellRenderer());
        FilterTable.addIfComponent(components, column.getCellEditor());
        FilterTable.addIfComponent(components, column.getHeaderRenderer());
        return components.stream();
    }

    private Collection<ColumnConditionPanel<C, ?>> createColumnFilterPanels() {
        return this.tableModel.filterModel().conditionModels().values().stream().filter(conditionModel -> this.columnModel().containsColumn(conditionModel.identifier())).filter(conditionModel -> this.filterFieldFactory.supportsType(conditionModel.columnClass())).map(conditionModel -> FilterColumnConditionPanel.builder(conditionModel).fieldFactory(this.filterFieldFactory).tableColumn(this.columnModel().column(conditionModel.identifier())).caption(Objects.toString(this.columnModel().column(conditionModel.identifier()).getHeaderValue())).build()).collect(Collectors.toList());
    }

    private void configureTableConditionPanel(TableConditionPanel<C> tableConditionPanel) {
        tableConditionPanel.conditionPanels().forEach(this::configureColumnConditionPanel);
    }

    private void configureColumnConditionPanel(ColumnConditionPanel<C, ?> conditionPanel) {
        conditionPanel.focusGainedEvent().ifPresent(focusGainedEvent -> focusGainedEvent.addConsumer((Consumer)this.scrollToColumn));
    }

    private static void addIfComponent(Collection<JComponent> components, Object object) {
        if (object instanceof JComponent) {
            components.add((JComponent)object);
        }
    }

    private static final class DefaultBuilder<R, C>
    extends AbstractComponentBuilder<Void, FilterTable<R, C>, Builder<R, C>>
    implements Builder<R, C> {
        private final FilterTableModel<R, C> tableModel;
        private final List<FilterTableColumn<C>> columns;
        private final ControlMap controlMap = ControlMap.controlMap(ControlKeys.class);
        private ColumnSummaryModel.SummaryValues.Factory<C> summaryValuesFactory;
        private TableConditionPanel.Factory<C> filterPanelFactory = new DefaultFilterPanelFactory();
        private FilterColumnConditionPanel.FieldFactory<C> filterFieldFactory = new DefaultFilterFieldFactory();
        private FilterTableCellRendererFactory<C> cellRendererFactory;
        private FilterTableCellEditorFactory<C> cellEditorFactory;
        private boolean autoStartsEdit = false;
        private CenterOnScroll centerOnScroll = CenterOnScroll.NEITHER;
        private Action doubleClickAction;
        private boolean scrollToSelectedItem = true;
        private boolean sortingEnabled = true;
        private int selectionMode = 2;
        private boolean columnReorderingAllowed = (Boolean)ALLOW_COLUMN_REORDERING.get();
        private boolean columnResizingAllowed = true;
        private int autoResizeMode = (Integer)AUTO_RESIZE_MODE.get();
        private ColumnConditionPanel.ConditionState filterState = ColumnConditionPanel.ConditionState.HIDDEN;

        private DefaultBuilder(FilterTableModel<R, C> tableModel, List<FilterTableColumn<C>> columns) {
            this.tableModel = tableModel;
            this.columns = new ArrayList<FilterTableColumn<C>>(this.validateIdentifiers(columns));
            this.cellRendererFactory = new DefaultFilterTableCellRendererFactory<R, C>(tableModel);
            this.cellEditorFactory = new DefaultFilterTableCellEditorFactory();
        }

        @Override
        public Builder<R, C> summaryValuesFactory(ColumnSummaryModel.SummaryValues.Factory<C> summaryValuesFactory) {
            this.summaryValuesFactory = Objects.requireNonNull(summaryValuesFactory);
            return this;
        }

        @Override
        public Builder<R, C> filterPanelFactory(TableConditionPanel.Factory<C> filterPanelFactory) {
            this.filterPanelFactory = Objects.requireNonNull(filterPanelFactory);
            return this;
        }

        @Override
        public Builder<R, C> filterFieldFactory(FilterColumnConditionPanel.FieldFactory<C> filterFieldFactory) {
            this.filterFieldFactory = Objects.requireNonNull(filterFieldFactory);
            return this;
        }

        @Override
        public Builder<R, C> cellRendererFactory(FilterTableCellRendererFactory<C> cellRendererFactory) {
            this.cellRendererFactory = Objects.requireNonNull(cellRendererFactory);
            return this;
        }

        @Override
        public Builder<R, C> cellEditorFactory(FilterTableCellEditorFactory<C> cellEditorFactory) {
            this.cellEditorFactory = Objects.requireNonNull(cellEditorFactory);
            return this;
        }

        @Override
        public Builder<R, C> autoStartsEdit(boolean autoStartsEdit) {
            this.autoStartsEdit = autoStartsEdit;
            return this;
        }

        @Override
        public Builder<R, C> centerOnScroll(CenterOnScroll centerOnScroll) {
            this.centerOnScroll = Objects.requireNonNull(centerOnScroll);
            return this;
        }

        @Override
        public Builder<R, C> doubleClickAction(Action doubleClickAction) {
            this.doubleClickAction = Objects.requireNonNull(doubleClickAction);
            return this;
        }

        @Override
        public Builder<R, C> scrollToSelectedItem(boolean scrollToSelectedItem) {
            this.scrollToSelectedItem = scrollToSelectedItem;
            return this;
        }

        @Override
        public Builder<R, C> sortingEnabled(boolean sortingEnabled) {
            this.sortingEnabled = sortingEnabled;
            return this;
        }

        @Override
        public Builder<R, C> selectionMode(int selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        @Override
        public Builder<R, C> columnReorderingAllowed(boolean columnReorderingAllowed) {
            this.columnReorderingAllowed = columnReorderingAllowed;
            return this;
        }

        @Override
        public Builder<R, C> columnResizingAllowed(boolean columnResizingAllowed) {
            this.columnResizingAllowed = columnResizingAllowed;
            return this;
        }

        @Override
        public Builder<R, C> autoResizeMode(int autoResizeMode) {
            this.autoResizeMode = autoResizeMode;
            return this;
        }

        @Override
        public Builder<R, C> filterState(ColumnConditionPanel.ConditionState filterState) {
            this.filterState = Objects.requireNonNull(filterState);
            return this;
        }

        @Override
        public Builder<R, C> keyStroke(ControlKey<?> controlKey, KeyStroke keyStroke) {
            this.controlMap.keyStroke(controlKey).set((Object)keyStroke);
            return this;
        }

        @Override
        protected FilterTable<R, C> createComponent() {
            return new FilterTable(this);
        }

        @Override
        protected ComponentValue<Void, FilterTable<R, C>> createComponentValue(FilterTable<R, C> component) {
            return new FilterTableComponentValue<R, C>(component);
        }

        @Override
        protected void setInitialValue(FilterTable<R, C> component, Void initialValue) {
        }

        private Collection<FilterTableColumn<C>> validateIdentifiers(List<FilterTableColumn<C>> columns) {
            if (columns.stream().map(new ColumnIdentifier()).distinct().count() != (long)columns.size()) {
                throw new IllegalArgumentException("Column identifiers are not unique");
            }
            return columns;
        }

        private static final class ColumnIdentifier<C>
        implements Function<FilterTableColumn<C>, C> {
            private ColumnIdentifier() {
            }

            @Override
            public C apply(FilterTableColumn<C> column) {
                return column.identifier();
            }
        }
    }

    private final class ScrollToColumn
    implements Consumer<C> {
        private ScrollToColumn() {
        }

        @Override
        public void accept(C identifier) {
            FilterTable.this.scrollToColumn(identifier);
        }
    }

    private final class DefaultSummaryValuesFactory
    implements ColumnSummaryModel.SummaryValues.Factory<C> {
        private DefaultSummaryValuesFactory() {
        }

        public <T extends Number> Optional<ColumnSummaryModel.SummaryValues<T>> createSummaryValues(C identifier, Format format) {
            Class columnClass = FilterTable.this.tableModel.getColumnClass(identifier);
            if (Number.class.isAssignableFrom(columnClass)) {
                return Optional.of(new DefaultSummaryValues(identifier, FilterTable.this.tableModel, format));
            }
            return Optional.empty();
        }
    }

    public static enum CenterOnScroll {
        COLUMN,
        ROW,
        BOTH,
        NEITHER;

    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> MOVE_COLUMN_LEFT = CommandControl.key("moveColumnLeft", KeyEvents.keyStroke(37, 192));
        public static final ControlKey<CommandControl> MOVE_COLUMN_RIGHT = CommandControl.key("moveColumnRight", KeyEvents.keyStroke(39, 192));
        public static final ControlKey<CommandControl> DECREASE_COLUMN_SIZE = CommandControl.key("decreaseColumnSize", KeyEvents.keyStroke(109, 128));
        public static final ControlKey<CommandControl> INCREASE_COLUMN_SIZE = CommandControl.key("increaseColumnSize", KeyEvents.keyStroke(107, 128));
        public static final ControlKey<CommandControl> COPY_CELL = CommandControl.key("copyCell", KeyEvents.keyStroke(67, 640));
        public static final ControlKey<CommandControl> TOGGLE_SORT_COLUMN = CommandControl.key("toggleSortColumn", KeyEvents.keyStroke(40, 512));
        public static final ControlKey<CommandControl> TOGGLE_SORT_COLUMN_ADD = CommandControl.key("toggleSortColumnAdd", KeyEvents.keyStroke(38, 512));

        private ControlKeys() {
        }
    }

    public static interface Export {
        public Export delimiter(char var1);

        public Export header(boolean var1);

        public Export hidden(boolean var1);

        public Export selected(boolean var1);

        public String get();
    }

    private final class DefaultExport
    implements Export {
        private char delimiter = (char)9;
        private boolean header = true;
        private boolean hidden = false;
        private boolean selected = false;

        private DefaultExport() {
        }

        @Override
        public Export delimiter(char delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        public Export header(boolean header) {
            this.header = header;
            return this;
        }

        @Override
        public Export hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @Override
        public Export selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        @Override
        public String get() {
            List rows = this.selected ? (List)FilterTable.this.tableModel.selectionModel().selectedIndexes().get() : IntStream.range(0, FilterTable.this.tableModel.visibleCount()).boxed().collect(Collectors.toList());
            ArrayList columns = new ArrayList(FilterTable.this.columnModel().visible());
            if (this.hidden) {
                columns.addAll(FilterTable.this.columnModel().hidden());
            }
            ArrayList lines = new ArrayList();
            if (this.header) {
                lines.add(columns.stream().map(column -> String.valueOf(column.getHeaderValue())).collect(Collectors.toList()));
            }
            lines.addAll(rows.stream().map(row -> this.stringValues((int)row, columns)).collect(Collectors.toList()));
            return lines.stream().map(line -> String.join((CharSequence)String.valueOf(this.delimiter), line)).collect(Collectors.joining(System.lineSeparator()));
        }

        private List<String> stringValues(int row, List<FilterTableColumn<C>> columns) {
            return columns.stream().map(column -> FilterTable.this.tableModel.getStringAt(row, column.identifier())).collect(Collectors.toList());
        }
    }

    static final class ColumnComparator
    implements Comparator<TableColumn> {
        private final Comparator<String> collator = Text.collator();

        ColumnComparator() {
        }

        @Override
        public int compare(TableColumn col1, TableColumn col2) {
            return this.collator.compare(String.valueOf(col1.getHeaderValue()), String.valueOf(col2.getHeaderValue()));
        }
    }

    private static final class DefaultSummaryValues<T extends Number, C>
    implements ColumnSummaryModel.SummaryValues<T> {
        private final C identifier;
        private final FilterTableModel<?, C> tableModel;
        private final Format format;
        private final Event<?> valuesChanged = Event.event();

        private DefaultSummaryValues(C identifier, FilterTableModel<?, C> tableModel, Format format) {
            this.identifier = Objects.requireNonNull(identifier);
            this.tableModel = Objects.requireNonNull(tableModel);
            this.format = Objects.requireNonNull(format);
            this.tableModel.dataChanged().addListener(this.valuesChanged);
            this.tableModel.selectionModel().selectedIndexes().addListener(this.valuesChanged);
        }

        public String format(Object value) {
            return this.format.format(value);
        }

        public EventObserver<?> valuesChanged() {
            return this.valuesChanged.observer();
        }

        public Collection<T> values() {
            return this.subset() ? this.tableModel.selectedValues(this.identifier) : this.tableModel.values(this.identifier);
        }

        public boolean subset() {
            FilterTableSelectionModel tableSelectionModel = this.tableModel.selectionModel();
            return (Boolean)tableSelectionModel.selectionNotEmpty().get() != false && tableSelectionModel.selectionCount() != this.tableModel.visibleCount();
        }
    }

    private static final class FilterTableHeader
    extends JTableHeader {
        private FilterTableHeader(TableColumnModel columnModel) {
            super(columnModel);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int index = this.columnModel.getColumnIndexAtX(event.getPoint().x);
            if (index != -1) {
                return ((FilterTableColumn)this.columnModel.getColumn(index)).toolTipText().orElse(null);
            }
            return null;
        }
    }

    private final class ColumnDragMouseHandler
    extends MouseMotionAdapter {
        private ColumnDragMouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            FilterTable.this.scrollRectToVisible(new Rectangle(e.getX(), FilterTable.this.getVisibleRect().y, 1, 1));
        }
    }

    private final class MouseSortHandler
    extends MouseAdapter {
        private MouseSortHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!((Boolean)FilterTable.this.sortingEnabled.get()).booleanValue() || e.getButton() != 1 || e.isControlDown()) {
                return;
            }
            FilterTableColumnModel columnModel = FilterTable.this.columnModel();
            int index = columnModel.getColumnIndexAtX(e.getX());
            if (index >= 0) {
                Object identifier;
                if (!FilterTable.this.getSelectionModel().isSelectionEmpty()) {
                    FilterTable.this.setColumnSelectionInterval(index, index);
                }
                if (FilterTable.this.sortModel.isSortingEnabled(identifier = ((FilterTableColumn)columnModel.getColumn(index)).identifier())) {
                    SortOrder nextSortOrder = FilterTableSortModel.nextSortOrder(FilterTable.this.sortModel.sortOrder(identifier));
                    if (e.isAltDown()) {
                        FilterTable.this.sortModel.addSortOrder(identifier, nextSortOrder);
                    } else {
                        FilterTable.this.sortModel.setSortOrder(identifier, nextSortOrder);
                    }
                }
            }
        }
    }

    private final class ScrollToSelected
    implements Consumer<List<Integer>> {
        private ScrollToSelected() {
        }

        @Override
        public void accept(List<Integer> selectedRowIndexes) {
            if (((Boolean)FilterTable.this.scrollToSelectedItem.get()).booleanValue() && !selectedRowIndexes.isEmpty() && this.noRowVisible(selectedRowIndexes)) {
                FilterTable.this.scrollToCoordinate(selectedRowIndexes.get(0), FilterTable.this.getSelectedColumn(), (CenterOnScroll)((Object)FilterTable.this.centerOnScroll.get()));
            }
        }

        private boolean noRowVisible(List<Integer> rows) {
            JViewport viewport = Utilities.parentOfType(JViewport.class, FilterTable.this);
            if (viewport != null) {
                return rows.stream().noneMatch(row -> this.rowVisible(viewport, (int)row));
            }
            return false;
        }

        private boolean rowVisible(JViewport viewport, int row) {
            int topRow = FilterTable.this.rowAtPoint(viewport.getViewPosition());
            int visibleRows = viewport.getExtentSize().height / FilterTable.this.getRowHeight();
            return row >= topRow && row <= topRow + visibleRows;
        }
    }

    private final class FilterTableMouseListener
    extends MouseAdapter {
        private FilterTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (FilterTable.this.doubleClickAction.isNotNull()) {
                    ((Action)FilterTable.this.doubleClickAction.get()).actionPerformed(new ActionEvent(this, 1001, "doubleClick"));
                }
                FilterTable.this.doubleClick.accept((Object)e);
            }
        }
    }

    private final class MoveResizeColumnKeyListener
    extends KeyAdapter {
        private final boolean columnResizingAllowed;
        private final boolean columnReorderingAllowed;
        private final KeyStroke moveLeft;
        private final KeyStroke moveRight;
        private final KeyStroke increaseSize;
        private final KeyStroke decreaseSize;

        private MoveResizeColumnKeyListener(boolean columnReorderingAllowed, boolean columnResizingAllowed) {
            this.columnReorderingAllowed = columnReorderingAllowed;
            this.columnResizingAllowed = columnResizingAllowed;
            this.moveLeft = (KeyStroke)FilterTable.this.controlMap.keyStroke(ControlKeys.MOVE_COLUMN_LEFT).get();
            this.moveRight = (KeyStroke)FilterTable.this.controlMap.keyStroke(ControlKeys.MOVE_COLUMN_RIGHT).get();
            this.increaseSize = (KeyStroke)FilterTable.this.controlMap.keyStroke(ControlKeys.INCREASE_COLUMN_SIZE).get();
            this.decreaseSize = (KeyStroke)FilterTable.this.controlMap.keyStroke(ControlKeys.DECREASE_COLUMN_SIZE).get();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.columnReorderingAllowed && this.move(e)) {
                this.moveSelectedColumn(e.getKeyCode() == this.moveLeft.getKeyCode());
                e.consume();
            } else if (this.columnResizingAllowed && this.resize(e)) {
                this.resizeSelectedColumn(e.getKeyCode() == this.increaseSize.getKeyCode());
                e.consume();
            }
        }

        private boolean move(KeyEvent e) {
            return this.moveLeft != null && this.moveLeft.equals(KeyStroke.getKeyStrokeForEvent(e)) || this.moveRight != null && this.moveRight.equals(KeyStroke.getKeyStrokeForEvent(e));
        }

        private boolean resize(KeyEvent e) {
            return this.decreaseSize != null && this.decreaseSize.equals(KeyStroke.getKeyStrokeForEvent(e)) || this.increaseSize != null && this.increaseSize.equals(KeyStroke.getKeyStrokeForEvent(e));
        }

        private void moveSelectedColumn(boolean left) {
            int selectedColumnIndex = FilterTable.this.getSelectedColumn();
            if (selectedColumnIndex != -1) {
                int columnCount = FilterTable.this.columnModel().getColumnCount();
                int newIndex = left ? (selectedColumnIndex == 0 ? columnCount - 1 : selectedColumnIndex - 1) : (selectedColumnIndex == columnCount - 1 ? 0 : selectedColumnIndex + 1);
                FilterTable.this.moveColumn(selectedColumnIndex, newIndex);
                FilterTable.this.scrollRectToVisible(FilterTable.this.getCellRect(FilterTable.this.getSelectedRow(), newIndex, true));
            }
        }

        private void resizeSelectedColumn(boolean enlarge) {
            int selectedColumnIndex = FilterTable.this.getSelectedColumn();
            if (selectedColumnIndex != -1) {
                TableColumn column = FilterTable.this.columnModel().getColumn(selectedColumnIndex);
                FilterTable.this.tableHeader.setResizingColumn(column);
                column.setWidth(column.getWidth() + (enlarge ? 10 : -10));
            }
        }
    }

    private static final class DefaultFilterTableCellEditorFactory<C>
    implements FilterTableCellEditorFactory<C> {
        private DefaultFilterTableCellEditorFactory() {
        }

        @Override
        public Optional<TableCellEditor> tableCellEditor(FilterTableColumn<C> column) {
            return Optional.empty();
        }
    }

    private static final class DefaultFilterTableCellRendererFactory<R, C>
    implements FilterTableCellRendererFactory<C> {
        private final FilterTableModel<R, C> tableModel;

        private DefaultFilterTableCellRendererFactory(FilterTableModel<R, C> tableModel) {
            this.tableModel = tableModel;
        }

        @Override
        public FilterTableCellRenderer tableCellRenderer(FilterTableColumn<C> column) {
            return FilterTableCellRenderer.builder(this.tableModel, column.identifier(), this.tableModel.getColumnClass(column.identifier())).build();
        }
    }

    private static final class FilterTableComponentValue<R, C>
    extends AbstractComponentValue<Void, FilterTable<R, C>> {
        private FilterTableComponentValue(FilterTable<R, C> table) {
            super(table);
        }

        @Override
        protected Void getComponentValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setComponentValue(Void value) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Builder<R, C>
    extends ComponentBuilder<Void, FilterTable<R, C>, Builder<R, C>> {
        public Builder<R, C> summaryValuesFactory(ColumnSummaryModel.SummaryValues.Factory<C> var1);

        public Builder<R, C> filterPanelFactory(TableConditionPanel.Factory<C> var1);

        public Builder<R, C> filterFieldFactory(FilterColumnConditionPanel.FieldFactory<C> var1);

        public Builder<R, C> cellRendererFactory(FilterTableCellRendererFactory<C> var1);

        public Builder<R, C> cellEditorFactory(FilterTableCellEditorFactory<C> var1);

        public Builder<R, C> autoStartsEdit(boolean var1);

        public Builder<R, C> centerOnScroll(CenterOnScroll var1);

        public Builder<R, C> doubleClickAction(Action var1);

        public Builder<R, C> scrollToSelectedItem(boolean var1);

        public Builder<R, C> sortingEnabled(boolean var1);

        public Builder<R, C> selectionMode(int var1);

        public Builder<R, C> columnReorderingAllowed(boolean var1);

        public Builder<R, C> columnResizingAllowed(boolean var1);

        public Builder<R, C> autoResizeMode(int var1);

        public Builder<R, C> filterState(ColumnConditionPanel.ConditionState var1);

        public Builder<R, C> keyStroke(ControlKey<?> var1, KeyStroke var2);
    }
}

