/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import java.util.Objects;
import java.util.Optional;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class FilterTableColumn<C>
extends TableColumn {
    private final String toolTipText;

    private FilterTableColumn(DefaultBuilder<C> builder) {
        super(builder.modelIndex);
        super.setIdentifier(builder.identifier);
        this.toolTipText = builder.toolTipText;
        if (builder.preferredWidth != 0) {
            this.setPreferredWidth(builder.preferredWidth);
        }
        if (builder.maxWidth != 0) {
            this.setMaxWidth(builder.maxWidth);
        }
        if (builder.minWidth != 0) {
            this.setMinWidth(builder.minWidth);
        }
        if (builder.width != 0) {
            this.setWidth(builder.width);
        }
        if (builder.headerValue != null) {
            this.setHeaderValue(builder.headerValue);
        }
        if (builder.headerRenderer != null) {
            this.setHeaderRenderer(builder.headerRenderer);
        }
        if (builder.cellEditor != null) {
            this.setCellEditor(builder.cellEditor);
        }
        if (builder.cellRenderer != null) {
            this.setCellRenderer(builder.cellRenderer);
        }
        this.setResizable(builder.resizable);
    }

    public C getIdentifier() {
        return (C)super.getIdentifier();
    }

    @Override
    public void setIdentifier(Object identifier) {
        throw new UnsupportedOperationException("Changing the identifier of a FilterTableColumn is not supported");
    }

    public C identifier() {
        return this.getIdentifier();
    }

    public Optional<String> toolTipText() {
        return Optional.ofNullable(this.toolTipText);
    }

    public String toString() {
        return this.identifier().toString();
    }

    public static FilterTableColumn<Integer> filterTableColumn(int modelIndex) {
        return FilterTableColumn.builder(modelIndex, modelIndex).build();
    }

    public static <C> FilterTableColumn<C> filterTableColumn(C identifier, int modelIndex) {
        return FilterTableColumn.builder(identifier, modelIndex).build();
    }

    public static <T extends Enum<T>> Builder<T> builder(T identifier) {
        return FilterTableColumn.builder(identifier, identifier.ordinal());
    }

    public static Builder<Integer> builder(int modelIndex) {
        return FilterTableColumn.builder(modelIndex, modelIndex);
    }

    public static <C> Builder<C> builder(C identifier, int modelIndex) {
        return new DefaultBuilder<C>(identifier, modelIndex);
    }

    private static final class DefaultBuilder<C>
    implements Builder<C> {
        private final C identifier;
        private final int modelIndex;
        private int preferredWidth;
        private int maxWidth;
        private int minWidth;
        private int width;
        private boolean resizable = true;
        private Object headerValue;
        private String toolTipText;
        private TableCellRenderer headerRenderer;
        private TableCellEditor cellEditor;
        private TableCellRenderer cellRenderer;

        private DefaultBuilder(C identifier, int modelIndex) {
            if (modelIndex < 0) {
                throw new IllegalArgumentException("Model index must be positive: " + modelIndex);
            }
            this.identifier = Objects.requireNonNull(identifier);
            this.modelIndex = modelIndex;
            this.headerValue = identifier;
        }

        @Override
        public Builder<C> preferredWidth(int preferredWidth) {
            this.preferredWidth = preferredWidth;
            return this;
        }

        @Override
        public Builder<C> maxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        @Override
        public Builder<C> minWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        @Override
        public Builder<C> width(int width) {
            this.width = width;
            return this;
        }

        @Override
        public Builder<C> resizable(boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        @Override
        public Builder<C> headerValue(Object headerValue) {
            this.headerValue = Objects.requireNonNull(headerValue);
            return this;
        }

        @Override
        public Builder<C> headerRenderer(TableCellRenderer headerRenderer) {
            this.headerRenderer = Objects.requireNonNull(headerRenderer);
            return this;
        }

        @Override
        public Builder<C> toolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
            return this;
        }

        @Override
        public Builder<C> cellEditor(TableCellEditor cellEditor) {
            this.cellEditor = cellEditor;
            return this;
        }

        @Override
        public Builder<C> cellRenderer(TableCellRenderer cellRenderer) {
            this.cellRenderer = cellRenderer;
            return this;
        }

        @Override
        public FilterTableColumn<C> build() {
            return new FilterTableColumn(this);
        }
    }

    public static interface Builder<C> {
        public Builder<C> preferredWidth(int var1);

        public Builder<C> maxWidth(int var1);

        public Builder<C> minWidth(int var1);

        public Builder<C> width(int var1);

        public Builder<C> resizable(boolean var1);

        public Builder<C> headerValue(Object var1);

        public Builder<C> headerRenderer(TableCellRenderer var1);

        public Builder<C> toolTipText(String var1);

        public Builder<C> cellEditor(TableCellEditor var1);

        public Builder<C> cellRenderer(TableCellRenderer var1);

        public FilterTableColumn<C> build();
    }
}

