/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.i18n.Messages;
import is.codion.common.item.Item;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilterColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilterTableColumnModel;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class TableConditionPanel<C>
extends JPanel {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(FilterColumnConditionPanel.class, (ResourceBundle)ResourceBundle.getBundle(TableConditionPanel.class.getName()));
    private final TableConditionModel<C> conditionModel;
    private final Value<ColumnConditionPanel.ConditionState> conditionState = Value.builder().nonNull((Object)ColumnConditionPanel.ConditionState.HIDDEN).consumer(this::onStateChanged).build();
    private final State hiddenState = State.state((boolean)true);
    private final State simpleState = State.state();
    private final State advancedState = State.state();

    protected TableConditionPanel(TableConditionModel<C> conditionModel) {
        this.conditionModel = Objects.requireNonNull(conditionModel);
        this.configureStates();
    }

    public final TableConditionModel<C> conditionModel() {
        return this.conditionModel;
    }

    public final Value<ColumnConditionPanel.ConditionState> state() {
        return this.conditionState;
    }

    public abstract Collection<ColumnConditionPanel<C, ?>> conditionPanels();

    public Collection<ColumnConditionPanel<C, ?>> selectableConditionPanels() {
        return this.conditionPanels();
    }

    public <T extends ColumnConditionPanel<C, ?>> T conditionPanel(C identifier) {
        return (T)this.conditionPanels().stream().filter(panel -> panel.conditionModel().identifier().equals(identifier)).findFirst().orElseThrow(() -> new IllegalStateException("No condition panel available for " + identifier));
    }

    public Controls controls() {
        return (Controls)Controls.builder().control((Control.Builder<?, ?>)Control.builder().toggle(this.hiddenState).name(MESSAGES.getString("hidden"))).control((Control.Builder<?, ?>)Control.builder().toggle(this.simpleState).name(MESSAGES.getString("simple"))).control((Control.Builder<?, ?>)Control.builder().toggle(this.advancedState).name(MESSAGES.getString("advanced"))).separator().control((Control.Builder<?, ?>)Control.builder().command(this::clearConditions).name(Messages.clear())).build();
    }

    public final void selectConditionPanel(JComponent dialogOwner) {
        List columnItems = this.selectableConditionPanels().stream().map(panel -> Item.item((Object)panel.conditionModel().identifier(), (String)panel.caption())).sorted().collect(Collectors.toList());
        if (columnItems.size() == 1) {
            this.state().map(state -> state == ColumnConditionPanel.ConditionState.HIDDEN ? ColumnConditionPanel.ConditionState.SIMPLE : state);
            ((ColumnConditionPanel)this.conditionPanel(((Item)columnItems.get(0)).value())).requestInputFocus();
        } else if (!columnItems.isEmpty()) {
            ((SelectionDialogBuilder)((SelectionDialogBuilder)Dialogs.selectionDialog(columnItems).owner(dialogOwner)).title(MESSAGES.getString("select_condition"))).selectSingle().map(columnItem -> this.conditionPanel(columnItem.value())).map(ColumnConditionPanel.class::cast).ifPresent(conditionPanel -> {
                this.state().map(state -> state == ColumnConditionPanel.ConditionState.HIDDEN ? ColumnConditionPanel.ConditionState.SIMPLE : state);
                conditionPanel.requestInputFocus();
            });
        }
    }

    protected void onStateChanged(ColumnConditionPanel.ConditionState conditionState) {
    }

    private void configureStates() {
        State.group((State[])new State[]{this.hiddenState, this.simpleState, this.advancedState});
        this.hiddenState.addConsumer((Consumer)new StateConsumer(ColumnConditionPanel.ConditionState.HIDDEN));
        this.simpleState.addConsumer((Consumer)new StateConsumer(ColumnConditionPanel.ConditionState.SIMPLE));
        this.advancedState.addConsumer((Consumer)new StateConsumer(ColumnConditionPanel.ConditionState.ADVANCED));
        this.conditionState.addConsumer(state -> {
            this.hiddenState.set((Object)(state == ColumnConditionPanel.ConditionState.HIDDEN ? 1 : 0));
            this.simpleState.set((Object)(state == ColumnConditionPanel.ConditionState.SIMPLE ? 1 : 0));
            this.advancedState.set((Object)(state == ColumnConditionPanel.ConditionState.ADVANCED ? 1 : 0));
        });
    }

    private void clearConditions() {
        this.conditionModel.conditionModels().values().forEach(ColumnConditionModel::clear);
    }

    private final class StateConsumer
    implements Consumer<Boolean> {
        private final ColumnConditionPanel.ConditionState state;

        private StateConsumer(ColumnConditionPanel.ConditionState state) {
            this.state = state;
        }

        @Override
        public void accept(Boolean enabled) {
            if (enabled.booleanValue()) {
                TableConditionPanel.this.conditionState.set((Object)this.state);
            }
        }
    }

    public static interface Factory<C> {
        public TableConditionPanel<C> create(TableConditionModel<C> var1, Collection<ColumnConditionPanel<C, ?>> var2, FilterTableColumnModel<C> var3, Consumer<TableConditionPanel<C>> var4);
    }
}

