/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.Text;
import is.codion.swing.common.ui.component.text.AbstractTextComponentValue;
import is.codion.swing.common.ui.component.text.UpdateOn;
import java.text.Format;
import java.text.ParseException;
import javax.swing.text.JTextComponent;

final class DefaultTextComponentValue<T, C extends JTextComponent>
extends AbstractTextComponentValue<T, C> {
    private final Format format;

    DefaultTextComponentValue(C textComponent, Format format, UpdateOn updateOn) {
        super(textComponent, null, updateOn);
        this.format = format;
    }

    @Override
    protected T getComponentValue() {
        String text = ((JTextComponent)this.component()).getText();
        if (Text.nullOrEmpty((String)text)) {
            return null;
        }
        return this.parseValueFromText(text);
    }

    @Override
    protected void setComponentValue(T value) {
        ((JTextComponent)this.component()).setText(value == null ? "" : (this.format == null ? value.toString() : this.format.format(value)));
    }

    private T parseValueFromText(String text) {
        try {
            return (T)(this.format == null ? text : this.format.parseObject(text));
        }
        catch (ParseException e) {
            return null;
        }
    }
}

