/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.model.CancelException;
import is.codion.swing.common.model.component.text.DocumentAdapter;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.FileSelectionDialogBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public final class FileInputPanel
extends JPanel {
    private final JTextField filePathField;

    private FileInputPanel(JTextField filePathField) {
        this.filePathField = Objects.requireNonNull(filePathField);
        this.setLayout(Layouts.borderLayout());
        this.add((Component)filePathField, "Center");
        JButton browseButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInputPanel.this.browseFile();
            }
        });
        browseButton.setPreferredSize(new Dimension(filePathField.getPreferredSize().height, filePathField.getPreferredSize().height));
        this.add((Component)browseButton, "East");
    }

    public JTextField filePathField() {
        return this.filePathField;
    }

    public static FileInputPanel fileInputPanel(JTextField filePathField) {
        return new FileInputPanel(filePathField);
    }

    public static Builder builder(JTextField filePathField) {
        return new DefaultFileInputPanelBuilder(filePathField);
    }

    private void browseFile() {
        try {
            File file = ((FileSelectionDialogBuilder)((FileSelectionDialogBuilder)Dialogs.fileSelectionDialog().owner(this.filePathField)).title("Select file")).selectFile();
            this.filePathField.setText(file.toString());
        }
        catch (CancelException e) {
            this.filePathField.setText("");
            throw e;
        }
    }

    private static final class DefaultFileInputPanelBuilder
    extends AbstractComponentBuilder<byte[], FileInputPanel, Builder>
    implements Builder {
        private final JTextField filePathField;

        private DefaultFileInputPanelBuilder(JTextField filePathField) {
            this.filePathField = Objects.requireNonNull(filePathField);
        }

        @Override
        protected FileInputPanel createComponent() {
            return FileInputPanel.fileInputPanel(this.filePathField);
        }

        @Override
        protected ComponentValue<byte[], FileInputPanel> createComponentValue(FileInputPanel component) {
            return new FileInputPanelValue(component);
        }

        @Override
        protected void setInitialValue(FileInputPanel component, byte[] initialValue) {
        }
    }

    private static final class FileInputPanelValue
    extends AbstractComponentValue<byte[], FileInputPanel> {
        private FileInputPanelValue(FileInputPanel fileInputPanel) {
            super(fileInputPanel);
            fileInputPanel.filePathField().getDocument().addDocumentListener((DocumentListener)((DocumentAdapter)e -> this.notifyListeners()));
        }

        @Override
        protected byte[] getComponentValue() {
            String filePath = ((FileInputPanel)this.component()).filePathField().getText();
            if (filePath.isEmpty()) {
                return null;
            }
            try {
                return Files.readAllBytes(Path.of(filePath, new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void setComponentValue(byte[] value) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Builder
    extends ComponentBuilder<byte[], FileInputPanel, Builder> {
    }
}

