/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class HintTextField
extends JTextField {
    private final Value<String> hint;
    private Color hintColor;

    public HintTextField(Document document) {
        this(document, null);
    }

    public HintTextField(String hint) {
        this(null, hint);
    }

    public HintTextField(Document document, String hint) {
        super(document, null, 0);
        this.hint = Value.builder().nonNull((Object)"").initialValue((Object)hint).listener(this::repaint).build();
        this.setupListeners();
        this.updateHintColor();
    }

    public final Value<String> hint() {
        return this.hint;
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
        if (!((String)this.hint.get()).isEmpty() && !this.isFocusOwner() && this.getText().isEmpty()) {
            this.paintHint(graphics);
        }
    }

    @Override
    public final void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        super.addPropertyChangeListener(property, listener);
    }

    @Override
    public final synchronized void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
    }

    private void paintHint(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.hintColor);
        graphics.drawString(this.adjustHintLength(fontMetrics, insets.left + insets.right), insets.left, this.getHeight() - fontMetrics.getDescent() - insets.bottom);
    }

    private String adjustHintLength(FontMetrics fontMetrics, int insets) {
        String adjustedText = (String)this.hint.get();
        int hintWidth = fontMetrics.stringWidth(adjustedText) + insets;
        while (hintWidth > this.getWidth() && !adjustedText.isEmpty()) {
            adjustedText = adjustedText.substring(0, adjustedText.length() - 1);
            hintWidth = fontMetrics.stringWidth(adjustedText) + insets;
        }
        return adjustedText;
    }

    private void updateHintColor() {
        this.hintColor = this.hintForegroundColor();
        this.repaint();
    }

    private Color hintForegroundColor() {
        Color foreground = this.getForeground();
        Color background = this.getBackground();
        int r = (int)Math.sqrt((Math.pow(background.getRed(), 2.0) + Math.pow(foreground.getRed(), 2.0)) / 2.0);
        int g = (int)Math.sqrt((Math.pow(background.getGreen(), 2.0) + Math.pow(foreground.getGreen(), 2.0)) / 2.0);
        int b = (int)Math.sqrt((Math.pow(background.getBlue(), 2.0) + Math.pow(foreground.getBlue(), 2.0)) / 2.0);
        return new Color(r, g, b, foreground.getAlpha());
    }

    private void setupListeners() {
        this.addPropertyChangeListener(new UpdateHintColor());
        this.addFocusListener(new RepaintFocusListener());
    }

    private final class UpdateHintColor
    implements PropertyChangeListener {
        private UpdateHintColor() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "UI": 
                case "foreground": 
                case "background": {
                    HintTextField.this.updateHintColor();
                    break;
                }
            }
        }
    }

    private final class RepaintFocusListener
    implements FocusListener {
        private RepaintFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            HintTextField.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            HintTextField.this.repaint();
        }
    }
}

