/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.swing.common.ui.component.text.CaseDocumentFilter;
import is.codion.swing.common.ui.component.text.SizedDocument;
import is.codion.swing.common.ui.component.text.StringLengthValidator;
import java.util.Objects;
import java.util.Optional;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

final class MaximumTextFieldLength {
    MaximumTextFieldLength(Document document, int maximumLength) {
        Objects.requireNonNull(document);
        if (document instanceof SizedDocument) {
            ((SizedDocument)document).setMaximumLength(maximumLength);
        } else if (document instanceof AbstractDocument) {
            DocumentFilter documentFilter = ((AbstractDocument)document).getDocumentFilter();
            if (documentFilter == null) {
                CaseDocumentFilter caseDocumentFilter = CaseDocumentFilter.caseDocumentFilter();
                caseDocumentFilter.addValidator(new StringLengthValidator(maximumLength));
                ((AbstractDocument)document).setDocumentFilter(caseDocumentFilter);
            } else if (documentFilter instanceof CaseDocumentFilter) {
                CaseDocumentFilter caseDocumentFilter = (CaseDocumentFilter)documentFilter;
                Optional<StringLengthValidator> lengthValidator = caseDocumentFilter.validators().stream().filter(StringLengthValidator.class::isInstance).map(StringLengthValidator.class::cast).findFirst();
                if (lengthValidator.isPresent()) {
                    lengthValidator.get().setMaximumLength(maximumLength);
                } else {
                    caseDocumentFilter.addValidator(new StringLengthValidator(maximumLength));
                }
            }
        }
    }
}

