/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.i18n.Messages;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.text.DocumentAdapter;
import is.codion.swing.common.ui.Colors;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.button.CheckBoxMenuItemBuilder;
import is.codion.swing.common.ui.component.text.DefaultTextFieldBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.key.KeyEvents;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public final class SearchHighlighter {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(SearchHighlighter.class, (ResourceBundle)ResourceBundle.getBundle(SearchHighlighter.class.getName()));
    private static final String UI_PROPERTY_NAME = "UI";
    private final JTextComponent textComponent;
    private final Value<String> searchStringValue = Value.builder().nonNull((Object)"").listener(this::searchAndHighlightResults).build();
    private final State caseSensitiveState;
    private final Highlighter highlighter = new DefaultHighlighter();
    private final List<MatchPosition> searchTextPositions = new ArrayList<MatchPosition>();
    private final Value<Integer> currentSearchTextPositionIndex = Value.value();
    private final Value<Integer> selectedSearchTextPosition = Value.value();
    private final ScrollToRatio scrollToRatio;
    private final boolean customHighlightColor;
    private final boolean customSelectedHighlightColor;
    private Highlighter.HighlightPainter highlightPainter;
    private SelectedHighlightPainter selectedHightlightPainter;

    private SearchHighlighter(DefaultBuilder builder) {
        this.textComponent = builder.textComponent;
        this.scrollToRatio = new ScrollToRatio(builder.scrollYRatio, builder.scrollXRatio);
        this.caseSensitiveState = ((State.Builder)State.builder((boolean)builder.caseSensitive).listener(this::searchAndHighlightResults)).build();
        this.customHighlightColor = builder.customHighlightColor;
        this.customSelectedHighlightColor = builder.customSelectedHighlightColor;
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(builder.selectedHighlightColor);
        this.selectedHightlightPainter = new SelectedHighlightPainter(builder.highlightColor);
        this.textComponent.setHighlighter(this.highlighter);
        this.bindEvents();
    }

    public Value<String> searchString() {
        return this.searchStringValue;
    }

    public State caseSensitive() {
        return this.caseSensitiveState;
    }

    public void highlightColor(Color color) {
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Objects.requireNonNull(color));
        this.updateHighligths();
    }

    public void selectedHighlightColor(Color color) {
        this.selectedHightlightPainter = new SelectedHighlightPainter(Objects.requireNonNull(color));
        this.updateHighligths();
    }

    public JTextField createSearchField() {
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)new DefaultTextFieldBuilder(String.class, this.searchStringValue).selectAllOnFocusGained(true)).keyEvent(KeyEvents.builder(40).action(Control.commandControl(this::nextSearchPosition)))).keyEvent(KeyEvents.builder(38).action(Control.commandControl(this::previousSearchPosition)))).keyEvent(KeyEvents.builder(27).action(Control.commandControl(this.textComponent::requestFocusInWindow)))).popupMenu(textField -> SearchHighlighter.createPopupMenu((ToggleControl)((ToggleControl.ToggleControlBuilder)Control.builder().toggle(this.caseSensitiveState).name(MESSAGES.getString("case_sensitive"))).build()))).hint(Messages.find() + "...").build();
    }

    public static Builder builder(JTextComponent textComponent) {
        return new DefaultBuilder(Objects.requireNonNull(textComponent));
    }

    public void nextSearchPosition() {
        if (!this.searchTextPositions.isEmpty()) {
            this.deselectCurrentSearchPosition();
            if (this.currentSearchTextPositionIndex.isNull() || this.currentSearchTextPositionIndex.isEqualTo((Object)(this.searchTextPositions.size() - 1))) {
                this.currentSearchTextPositionIndex.set((Object)0);
            } else {
                this.currentSearchTextPositionIndex.set((Object)((Integer)this.currentSearchTextPositionIndex.get() + 1));
            }
            this.selectCurrentSearchPosition();
        }
    }

    public void previousSearchPosition() {
        if (!this.searchTextPositions.isEmpty()) {
            this.deselectCurrentSearchPosition();
            if (this.currentSearchTextPositionIndex.isNull() || this.currentSearchTextPositionIndex.isEqualTo((Object)0)) {
                this.currentSearchTextPositionIndex.set((Object)(this.searchTextPositions.size() - 1));
            } else {
                this.currentSearchTextPositionIndex.set((Object)((Integer)this.currentSearchTextPositionIndex.get() - 1));
            }
            this.selectCurrentSearchPosition();
        }
    }

    Integer selectedHighlightPosition() {
        return (Integer)this.selectedSearchTextPosition.get();
    }

    private void searchAndHighlightResults() {
        this.currentSearchTextPositionIndex.clear();
        this.selectedSearchTextPosition.clear();
        this.highlighter.removeAllHighlights();
        this.searchTextPositions.clear();
        if (!((String)this.searchStringValue.get()).isEmpty()) {
            Pattern pattern = Pattern.compile((String)this.searchStringValue.get(), (Boolean)this.caseSensitiveState.get() != false ? 0 : 2);
            try {
                Matcher matcher = pattern.matcher(this.textComponent.getDocument().getText(0, this.textComponent.getDocument().getLength()));
                int searchFrom = 0;
                while (matcher.find(searchFrom)) {
                    Object highlightTag = this.highlighter.addHighlight(matcher.start(), matcher.end(), this.highlightPainter);
                    this.searchTextPositions.add(new MatchPosition(matcher.start(), matcher.end(), highlightTag));
                    searchFrom = matcher.end();
                }
                this.nextSearchPosition();
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void selectCurrentSearchPosition() {
        MatchPosition matchPosition = this.searchTextPositions.get((Integer)this.currentSearchTextPositionIndex.get());
        this.selectedSearchTextPosition.set((Object)matchPosition.start);
        try {
            this.highlighter.removeHighlight(matchPosition.highlightTag);
            matchPosition.highlightTag = this.highlighter.addHighlight(matchPosition.start, matchPosition.end, this.selectedHightlightPainter);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void deselectCurrentSearchPosition() {
        if (this.currentSearchTextPositionIndex.isNotNull()) {
            MatchPosition matchPosition = this.searchTextPositions.get((Integer)this.currentSearchTextPositionIndex.get());
            try {
                this.highlighter.removeHighlight(matchPosition.highlightTag);
                matchPosition.highlightTag = this.highlighter.addHighlight(matchPosition.start, matchPosition.end, this.highlightPainter);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void bindEvents() {
        this.textComponent.getDocument().addDocumentListener((DocumentListener)((DocumentAdapter)e -> this.searchAndHighlightResults()));
        this.textComponent.addPropertyChangeListener(UI_PROPERTY_NAME, new UpdateHightlightColors());
        this.selectedSearchTextPosition.addConsumer(selectedSearchPosition -> {
            if (selectedSearchPosition != null) {
                this.scrollToPosition((int)selectedSearchPosition);
            }
        });
    }

    private void scrollToPosition(int position) {
        JViewport viewport = Utilities.parentOfType(JViewport.class, this.textComponent);
        try {
            Rectangle view = this.textComponent.modelToView(position);
            if (viewport != null && view != null) {
                viewport.setViewPosition(this.viewPosition(viewport, view));
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private Point viewPosition(JViewport viewport, Rectangle view) {
        return new Point(this.locationX(viewport, view), this.locationY(viewport, view));
    }

    private int locationY(JViewport viewport, Rectangle view) {
        int extentHeight = viewport.getExtentSize().height;
        int viewHeight = viewport.getViewSize().height;
        int yPosition = (int)Math.max(0.0, (double)view.y - (double)(extentHeight - view.height) * this.scrollToRatio.scrollYRatio);
        yPosition = Math.min(yPosition, viewHeight - extentHeight);
        return yPosition;
    }

    private int locationX(JViewport viewport, Rectangle view) {
        int extentWidth = viewport.getExtentSize().width;
        int viewWidth = viewport.getViewSize().width;
        int yPosition = (int)Math.max(0.0, (double)view.x - (double)(extentWidth - view.width) * this.scrollToRatio.scrollXRatio);
        yPosition = Math.min(yPosition, viewWidth - extentWidth);
        return yPosition;
    }

    private void updateHighligths() {
        Highlighter.Highlight[] highlights = this.highlighter.getHighlights();
        this.highlighter.removeAllHighlights();
        for (Highlighter.Highlight highlight : highlights) {
            this.updateHighlight(highlight, this.matchPosition(highlight.getStartOffset()));
        }
    }

    private void updateHighlight(Highlighter.Highlight highlight, MatchPosition matchPosition) {
        try {
            matchPosition.highlightTag = this.highlighter.addHighlight(highlight.getStartOffset(), highlight.getEndOffset(), highlight.getPainter() instanceof SelectedHighlightPainter ? this.selectedHightlightPainter : this.highlightPainter);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private MatchPosition matchPosition(int startOffset) {
        return this.searchTextPositions.stream().filter(matchPosition -> matchPosition.start == startOffset).findFirst().orElseThrow(IllegalStateException::new);
    }

    private static JPopupMenu createPopupMenu(ToggleControl caseSensitiveControl) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add((JMenuItem)((CheckBoxMenuItemBuilder)CheckBoxMenuItemBuilder.builder().toggleControl(caseSensitiveControl)).build());
        return popupMenu;
    }

    private static final class DefaultBuilder
    implements Builder {
        private final JTextComponent textComponent;
        private Color highlightColor;
        private Color selectedHighlightColor;
        private boolean customHighlightColor = false;
        private boolean customSelectedHighlightColor = false;
        private boolean caseSensitive = true;
        private double scrollYRatio = 0.5;
        private double scrollXRatio = 0.5;

        private DefaultBuilder(JTextComponent textComponent) {
            this.textComponent = textComponent;
            this.highlightColor = textComponent.getSelectionColor();
            this.selectedHighlightColor = Colors.darker(textComponent.getSelectionColor());
        }

        @Override
        public Builder highlightColor(Color highlightColor) {
            this.highlightColor = Objects.requireNonNull(highlightColor);
            this.customHighlightColor = true;
            return this;
        }

        @Override
        public Builder selectedHighlightColor(Color selectedHighlightColor) {
            this.selectedHighlightColor = Objects.requireNonNull(selectedHighlightColor);
            this.customSelectedHighlightColor = true;
            return this;
        }

        @Override
        public Builder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public Builder scrollYRatio(double scrollYRatio) {
            if (scrollYRatio < 0.0 || scrollYRatio > 1.0) {
                throw new IllegalArgumentException("scrollYRatio must be between 0 and 1");
            }
            this.scrollYRatio = scrollYRatio;
            return this;
        }

        @Override
        public Builder scrollXRatio(double scrollXRatio) {
            if (scrollXRatio < 0.0 || scrollXRatio > 1.0) {
                throw new IllegalArgumentException("scrollXRatio must be between 0 and 1");
            }
            this.scrollXRatio = scrollXRatio;
            return this;
        }

        @Override
        public SearchHighlighter build() {
            return new SearchHighlighter(this);
        }
    }

    private static final class ScrollToRatio {
        private final double scrollYRatio;
        private final double scrollXRatio;

        private ScrollToRatio(double scrollYRatio, double scrollXRatio) {
            this.scrollYRatio = scrollYRatio;
            this.scrollXRatio = scrollXRatio;
        }
    }

    private static final class SelectedHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private SelectedHighlightPainter(Color color) {
            super(color);
        }
    }

    private static final class MatchPosition {
        private final int start;
        private final int end;
        private Object highlightTag;

        private MatchPosition(int start, int end, Object highlightTag) {
            this.start = start;
            this.end = end;
            this.highlightTag = highlightTag;
        }
    }

    private final class UpdateHightlightColors
    implements PropertyChangeListener {
        private UpdateHightlightColors() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!SearchHighlighter.this.customHighlightColor) {
                SearchHighlighter.this.highlightColor(SearchHighlighter.this.textComponent.getSelectionColor());
            }
            if (!SearchHighlighter.this.customSelectedHighlightColor) {
                SearchHighlighter.this.selectedHighlightColor(Colors.darker(SearchHighlighter.this.textComponent.getSelectionColor()));
            }
        }
    }

    public static interface Builder {
        public Builder highlightColor(Color var1);

        public Builder selectedHighlightColor(Color var1);

        public Builder caseSensitive(boolean var1);

        public Builder scrollYRatio(double var1);

        public Builder scrollXRatio(double var1);

        public SearchHighlighter build();
    }
}

