/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.swing.common.ui.component.text.CaseDocumentFilter;
import is.codion.swing.common.ui.component.text.StringLengthValidator;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public final class SizedDocument
extends PlainDocument {
    private final CaseDocumentFilter documentFilter = CaseDocumentFilter.caseDocumentFilter();
    private final StringLengthValidator stringLengthValidator;

    private SizedDocument(int maximumLength) {
        this.stringLengthValidator = new StringLengthValidator(maximumLength);
        this.documentFilter.addValidator(this.stringLengthValidator);
        super.setDocumentFilter(this.documentFilter);
    }

    @Override
    public void setDocumentFilter(DocumentFilter filter) {
        throw new UnsupportedOperationException("Changing the DocumentFilter of SizedDocument is not allowed");
    }

    @Override
    public CaseDocumentFilter getDocumentFilter() {
        return (CaseDocumentFilter)super.getDocumentFilter();
    }

    public int getMaximumLength() {
        return this.stringLengthValidator.getMaximumLength();
    }

    public void setMaximumLength(int maximumLength) {
        this.stringLengthValidator.setMaximumLength(maximumLength);
    }

    public static SizedDocument sizedDocument() {
        return SizedDocument.sizedDocument(-1);
    }

    public static SizedDocument sizedDocument(int maximumLength) {
        return new SizedDocument(maximumLength);
    }
}

