/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.control.Control;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

abstract class AbstractControl
extends AbstractAction
implements Control {
    private static final String ENABLED = "enabled";
    static final String FONT = "Font";
    static final String BACKGROUND = "Background";
    static final String FOREGROUND = "Foreground";
    private final StateObserver enabledObserver;
    private final Enabler enabler = new Enabler();
    private final boolean initialized;

    AbstractControl(AbstractControlBuilder<?, ?> builder) {
        super((String)builder.values.get("Name"));
        this.initialized = true;
        this.enabledObserver = builder.enabled == null ? State.state((boolean)true) : builder.enabled;
        this.enabledObserver.addWeakConsumer((Consumer)this.enabler);
        super.setEnabled((Boolean)this.enabledObserver.get());
        builder.values.forEach((x$0, x$1) -> super.putValue((String)x$0, x$1));
    }

    public final String toString() {
        return this.name().orElse(super.toString());
    }

    @Override
    public final void setEnabled(boolean newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putValue(String key, Object newValue) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        super.putValue(key, newValue);
    }

    @Override
    public final Object getValue(String key) {
        if (ENABLED.equals(key)) {
            return this.enabledObserver.get();
        }
        return super.getValue(key);
    }

    @Override
    public final Collection<String> keys() {
        return Arrays.stream(this.getKeys()).filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
    }

    @Override
    public final Optional<String> description() {
        return Optional.ofNullable((String)this.getValue("ShortDescription"));
    }

    @Override
    public final Optional<String> name() {
        Object value = this.getValue("Name");
        return value == null ? Optional.empty() : Optional.of(String.valueOf(value));
    }

    @Override
    public final StateObserver enabled() {
        return this.enabledObserver;
    }

    @Override
    public final OptionalInt mnemonic() {
        Integer mnemonic = (Integer)this.getValue("MnemonicKey");
        return mnemonic == null || mnemonic.equals(0) ? OptionalInt.empty() : OptionalInt.of(mnemonic);
    }

    @Override
    public final Optional<KeyStroke> keyStroke() {
        return Optional.ofNullable((KeyStroke)this.getValue("AcceleratorKey"));
    }

    @Override
    public final Optional<Icon> smallIcon() {
        return Optional.ofNullable((Icon)this.getValue("SmallIcon"));
    }

    @Override
    public final Optional<Icon> largeIcon() {
        return Optional.ofNullable((Icon)this.getValue("SwingLargeIconKey"));
    }

    @Override
    public final Optional<Color> background() {
        return Optional.ofNullable((Color)this.getValue(BACKGROUND));
    }

    @Override
    public final Optional<Color> foreground() {
        return Optional.ofNullable((Color)this.getValue(FOREGROUND));
    }

    @Override
    public final Optional<Font> font() {
        return Optional.ofNullable((Font)this.getValue(FONT));
    }

    static abstract class AbstractControlBuilder<C extends Control, B extends Control.Builder<C, B>>
    implements Control.Builder<C, B> {
        private final Map<String, Object> values = new HashMap<String, Object>();
        private StateObserver enabled;

        AbstractControlBuilder() {
        }

        @Override
        public final B name(String name) {
            this.values.put("Name", name);
            return this.self();
        }

        @Override
        public final B enabled(StateObserver enabled) {
            this.enabled = enabled;
            return this.self();
        }

        @Override
        public final B mnemonic(int mnemonic) {
            this.values.put("MnemonicKey", mnemonic);
            return this.self();
        }

        @Override
        public final B smallIcon(Icon smallIcon) {
            this.values.put("SmallIcon", smallIcon);
            return this.self();
        }

        @Override
        public final B largeIcon(Icon largeIcon) {
            this.values.put("SwingLargeIconKey", largeIcon);
            return this.self();
        }

        @Override
        public final B description(String description) {
            this.values.put("ShortDescription", description);
            return this.self();
        }

        @Override
        public final B foreground(Color foreground) {
            this.values.put(AbstractControl.FOREGROUND, foreground);
            return this.self();
        }

        @Override
        public final B background(Color background) {
            this.values.put(AbstractControl.BACKGROUND, background);
            return this.self();
        }

        @Override
        public final B font(Font font) {
            this.values.put(AbstractControl.FONT, font);
            return this.self();
        }

        @Override
        public final B keyStroke(KeyStroke keyStroke) {
            this.values.put("AcceleratorKey", keyStroke);
            return this.self();
        }

        @Override
        public final B value(String key, Object value) {
            if (AbstractControl.ENABLED.equals(key)) {
                throw new IllegalArgumentException("Can not set the enabled property of a Control");
            }
            this.values.put(key, value);
            return this.self();
        }

        protected final B self() {
            return (B)this;
        }
    }

    private final class Enabler
    implements Consumer<Boolean> {
        private Enabler() {
        }

        @Override
        public void accept(Boolean enabled) {
            if (SwingUtilities.isEventDispatchThread()) {
                AbstractControl.super.setEnabled(enabled);
            } else {
                SwingUtilities.invokeLater(() -> AbstractControl.super.setEnabled(enabled));
            }
        }
    }
}

