/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.model.CancelException;
import is.codion.swing.common.ui.control.AbstractControl;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.function.Consumer;

final class DefaultCommandControl
extends AbstractControl
implements CommandControl {
    private static final Consumer<Exception> DEFAULT_EXCEPTION_HANDLER = new DefaultExceptionHandler();
    private final Control.Command command;
    private final Control.ActionCommand actionCommand;
    private final Consumer<Exception> onException;

    private DefaultCommandControl(Control.Command command, Control.ActionCommand actionCommand, DefaultCommandControlBuilder builder) {
        super(builder);
        this.command = command;
        this.actionCommand = actionCommand;
        this.onException = builder.onException;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.command != null) {
                this.command.execute();
            } else {
                this.actionCommand.execute(e);
            }
        }
        catch (Exception exception) {
            this.onException.accept(exception);
        }
    }

    @Override
    public CommandControl.CommandControlBuilder copy() {
        return this.copyBuilder(this.command, this.actionCommand);
    }

    @Override
    public CommandControl.CommandControlBuilder copy(Control.Command command) {
        return this.copyBuilder(command, null);
    }

    @Override
    public CommandControl.CommandControlBuilder copy(Control.ActionCommand actionCommand) {
        return this.copyBuilder(null, actionCommand);
    }

    private CommandControl.CommandControlBuilder copyBuilder(Control.Command command, Control.ActionCommand actionCommand) {
        if (command == null && actionCommand == null) {
            throw new NullPointerException("Command or ActionCommand must be specified");
        }
        CommandControl.CommandControlBuilder builder = ((CommandControl.CommandControlBuilder)new DefaultCommandControlBuilder(command, actionCommand).enabled(this.enabled())).onException(this.onException);
        this.keys().forEach(key -> builder.value((String)key, this.getValue((String)key)));
        return builder;
    }

    static final class DefaultCommandControlBuilder
    extends AbstractControl.AbstractControlBuilder<CommandControl, CommandControl.CommandControlBuilder>
    implements CommandControl.CommandControlBuilder {
        private final Control.Command command;
        private final Control.ActionCommand actionCommand;
        private Consumer<Exception> onException = DEFAULT_EXCEPTION_HANDLER;

        DefaultCommandControlBuilder(Control.Command command, Control.ActionCommand actionCommand) {
            this.command = command;
            this.actionCommand = actionCommand;
        }

        @Override
        public CommandControl.CommandControlBuilder onException(Consumer<Exception> onException) {
            this.onException = Objects.requireNonNull(onException);
            return (CommandControl.CommandControlBuilder)this.self();
        }

        @Override
        public CommandControl build() {
            return new DefaultCommandControl(this.command, this.actionCommand, this);
        }
    }

    private static final class DefaultExceptionHandler
    implements Consumer<Exception> {
        private DefaultExceptionHandler() {
        }

        @Override
        public void accept(Exception exception) {
            if (exception instanceof CancelException) {
                return;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }
}

