/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.control.AbstractControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.control.Controls;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.KeyStroke;

final class DefaultControls
extends AbstractControl
implements Controls {
    private final List<Action> actions = new ArrayList<Action>();

    DefaultControls(DefaultControlsBuilder builder) {
        super(builder);
        this.actions.addAll(builder.actions);
    }

    @Override
    public List<Action> actions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public int size() {
        return this.actions.size();
    }

    @Override
    public boolean empty() {
        return this.actions.stream().noneMatch(action -> action != SEPARATOR);
    }

    @Override
    public boolean notEmpty() {
        return !this.empty();
    }

    @Override
    public Action get(int index) {
        return this.actions.get(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public Controls.ControlsBuilder copy() {
        return new DefaultControlsBuilder(this);
    }

    static final class DefaultControlsBuilder
    extends AbstractControl.AbstractControlBuilder<Controls, Controls.ControlsBuilder>
    implements Controls.ControlsBuilder {
        private final List<Action> actions = new ArrayList<Action>();

        DefaultControlsBuilder() {
        }

        private DefaultControlsBuilder(DefaultControls controls) {
            this.enabled(controls.enabled());
            controls.keys().forEach(key -> this.value((String)key, controls.getValue((String)key)));
            this.actions.addAll(controls.actions);
        }

        @Override
        public Controls.ControlsBuilder control(Control control) {
            return this.controlAt(this.actions.size(), control);
        }

        @Override
        public Controls.ControlsBuilder control(Control.Builder<?, ?> controlBuilder) {
            return this.controlAt(this.actions.size(), controlBuilder);
        }

        @Override
        public Controls.ControlsBuilder controlAt(int index, Control control) {
            this.actions.add(index, Objects.requireNonNull(control));
            return this;
        }

        @Override
        public Controls.ControlsBuilder controlAt(int index, Control.Builder<?, ?> controlBuilder) {
            this.actions.add(index, (Action)Objects.requireNonNull(controlBuilder).build());
            return this;
        }

        @Override
        public Controls.ControlsBuilder controls(Control ... controls) {
            return this.controls(Arrays.asList(Objects.requireNonNull(controls)));
        }

        @Override
        public Controls.ControlsBuilder controls(Collection<? extends Control> controls) {
            this.actions.addAll(Objects.requireNonNull(controls));
            return this;
        }

        @Override
        public Controls.ControlsBuilder controls(Control.Builder<?, ?> ... controlBuilders) {
            this.actions.addAll(Arrays.stream(controlBuilders).map(Control.Builder::build).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Controls.ControlsBuilder action(Action action) {
            return this.actionAt(this.actions.size(), action);
        }

        @Override
        public Controls.ControlsBuilder actionAt(int index, Action action) {
            this.actions.add(index, Objects.requireNonNull(action));
            return this;
        }

        @Override
        public Controls.ControlsBuilder actions(Action ... actions) {
            return this.actions(Arrays.asList(Objects.requireNonNull(actions)));
        }

        @Override
        public Controls.ControlsBuilder actions(Collection<Action> actions) {
            this.actions.addAll(Objects.requireNonNull(actions));
            return this;
        }

        @Override
        public Controls.ControlsBuilder separator() {
            return this.separatorAt(this.actions.size());
        }

        @Override
        public Controls.ControlsBuilder separatorAt(int index) {
            if (this.actions.isEmpty() || this.actions.get(index - 1) != Controls.SEPARATOR) {
                this.actions.add(Controls.SEPARATOR);
            }
            return this;
        }

        @Override
        public Controls.ControlsBuilder remove(Action action) {
            this.actions.remove(Objects.requireNonNull(action));
            return this;
        }

        @Override
        public Controls.ControlsBuilder removeAll() {
            this.actions.clear();
            return this;
        }

        @Override
        public Controls build() {
            return new DefaultControls(this);
        }
    }

    static final class DefaultLayout
    implements Controls.Layout {
        private static final ControlItem SEPARATOR = new Separator();
        private final Value<KeyStroke> keyStroke = Value.value();
        private final List<ControlKey<?>> defaults;
        private final List<ControlItem> items = new ArrayList<ControlItem>();

        DefaultLayout(List<ControlKey<?>> defaults) {
            this.defaults = Objects.requireNonNull(defaults);
            this.defaults();
        }

        private DefaultLayout(DefaultLayout layout) {
            this.keyStroke.set((Object)((KeyStroke)layout.keyStroke.get()));
            this.defaults = new ArrayList(layout.defaults);
            this.defaults();
        }

        @Override
        public Controls.Layout separator() {
            if (this.items.isEmpty() || this.items.get(this.items.size() - 1) != SEPARATOR) {
                this.items.add(SEPARATOR);
            }
            return this;
        }

        @Override
        public Controls.Layout control(ControlKey<?> controlKey) {
            this.add(Objects.requireNonNull(controlKey));
            return this;
        }

        @Override
        public Controls.Layout control(Control control) {
            this.items.add(new CustomAction(Objects.requireNonNull(control)));
            return this;
        }

        @Override
        public Controls.Layout control(Control.Builder<?, ?> controlBuilder) {
            return this.control((Control)Objects.requireNonNull(controlBuilder).build());
        }

        @Override
        public Controls.Layout action(Action action) {
            this.items.add(new CustomAction(Objects.requireNonNull(action)));
            return this;
        }

        @Override
        public Controls.Layout controls(ControlKey<Controls> controlsKey) {
            return this.control(controlsKey);
        }

        @Override
        public Controls.Layout controls(Controls.ControlsKey controlsKey, Consumer<Controls.Layout> layout) {
            Controls.Layout defaultLayout = controlsKey.defaultLayout().map(Controls.Layout::copy).orElseThrow(() -> new IllegalArgumentException("No default controls layout available"));
            layout.accept(defaultLayout);
            this.items.add(new StandardControls(controlsKey, defaultLayout));
            return this;
        }

        @Override
        public Controls.Layout clear() {
            this.items.clear();
            return this;
        }

        @Override
        public Controls.Layout copy() {
            return new DefaultLayout(this);
        }

        @Override
        public Controls.Layout defaults() {
            return this.defaults(null);
        }

        @Override
        public Controls.Layout defaults(ControlKey<?> stopAt) {
            for (ControlKey<?> control : this.defaults) {
                if (control == null) {
                    this.separator();
                } else {
                    this.add(control);
                }
                if (stopAt == null || control != stopAt) continue;
                break;
            }
            return this;
        }

        @Override
        public Controls create(ControlMap controlMap) {
            Controls.ControlsBuilder builder = Controls.builder();
            this.items.forEach(item -> item.addTo(builder, controlMap));
            return (Controls)builder.build();
        }

        private void add(ControlKey<?> controlKey) {
            if (!this.contains(controlKey)) {
                this.items.add(new StandardControl(controlKey));
            }
        }

        private boolean contains(ControlKey<?> controlKey) {
            return this.items.stream().map(ControlItem::controlKey).flatMap(Optional::stream).anyMatch(controlKey::equals);
        }

        private static interface ControlItem {
            public void addTo(Controls.ControlsBuilder var1, ControlMap var2);

            default public Optional<ControlKey<?>> controlKey() {
                return Optional.empty();
            }
        }

        private static final class CustomAction
        implements ControlItem {
            private final Action action;

            private CustomAction(Action action) {
                this.action = action;
            }

            @Override
            public void addTo(Controls.ControlsBuilder builder, ControlMap controlMap) {
                builder.action(this.action);
            }
        }

        private static final class StandardControls
        implements ControlItem {
            private final Controls.ControlsKey controlsKey;
            private final Controls.Layout layout;

            private StandardControls(Controls.ControlsKey controlsKey, Controls.Layout layout) {
                this.controlsKey = controlsKey;
                this.layout = layout;
            }

            @Override
            public void addTo(Controls.ControlsBuilder builder, ControlMap controlMap) {
                Controls defaultControls = (Controls)controlMap.control(this.controlsKey).get();
                Controls configuredControls = this.layout.create(controlMap);
                builder.control(defaultControls.copy().removeAll().actions(configuredControls.actions()));
            }

            @Override
            public Optional<ControlKey<?>> controlKey() {
                return Optional.of(this.controlsKey);
            }
        }

        private static final class StandardControl
        implements ControlItem {
            private final ControlKey<?> controlKey;

            private StandardControl(ControlKey<?> controlKey) {
                this.controlKey = controlKey;
            }

            @Override
            public void addTo(Controls.ControlsBuilder builder, ControlMap controlMap) {
                controlMap.control(this.controlKey).optional().ifPresent(control -> {
                    if (control instanceof Controls) {
                        StandardControl.addControls(builder, (Controls)control, controlMap);
                    } else {
                        builder.control((Control)control);
                    }
                });
            }

            @Override
            public Optional<ControlKey<?>> controlKey() {
                return Optional.of(this.controlKey);
            }

            private static void addControls(Controls.ControlsBuilder builder, Controls controlsToAdd, ControlMap controlMap) {
                if (controlsToAdd.notEmpty()) {
                    if (!controlsToAdd.name().isPresent()) {
                        controlsToAdd.actions().stream().filter(action -> action != SEPARATOR).forEach(action -> new CustomAction((Action)action).addTo(builder, controlMap));
                    } else {
                        builder.control(controlsToAdd);
                    }
                }
            }
        }

        private static final class Separator
        implements ControlItem {
            private Separator() {
            }

            @Override
            public void addTo(Controls.ControlsBuilder builder, ControlMap controlMap) {
                builder.separator();
            }
        }
    }

    static final class DefaultSeparator
    implements Action {
        private static final String CONTROLS_SEPARATOR = "Separator";

        DefaultSeparator() {
        }

        @Override
        public Object getValue(String key) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void setEnabled(boolean b) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }
    }
}

