/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.resource.MessageBundle;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.DefaultOkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.LookAndFeelSelectionDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.laf.LookAndFeelComboBox;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class DefaultLookAndFeelSelectionDialogBuilder
implements LookAndFeelSelectionDialogBuilder {
    private static final int PADDING = 10;
    private JComponent owner;
    private boolean enableOnSelection = (Boolean)LookAndFeelComboBox.ENABLE_ON_SELECTION.get();

    DefaultLookAndFeelSelectionDialogBuilder() {
    }

    @Override
    public LookAndFeelSelectionDialogBuilder owner(JComponent owner) {
        this.owner = Objects.requireNonNull(owner);
        return this;
    }

    @Override
    public LookAndFeelSelectionDialogBuilder enableOnSelection(boolean enableOnSelection) {
        this.enableOnSelection = enableOnSelection;
        return this;
    }

    @Override
    public Control createControl(Consumer<LookAndFeelProvider> selectedLookAndFeel) {
        MessageBundle resourceBundle = MessageBundle.messageBundle(LookAndFeelProvider.class, (ResourceBundle)ResourceBundle.getBundle(LookAndFeelProvider.class.getName()));
        String caption = resourceBundle.getString("select_look_and_feel");
        return ((CommandControl.CommandControlBuilder)Control.builder().command(() -> this.selectLookAndFeel(selectedLookAndFeel)).name(caption)).build();
    }

    @Override
    public void selectLookAndFeel(Consumer<LookAndFeelProvider> selectedLookAndFeel) {
        Objects.requireNonNull(selectedLookAndFeel);
        LookAndFeelComboBox lookAndFeelComboBox = LookAndFeelComboBox.lookAndFeelComboBox(this.enableOnSelection);
        JPanel basePanel = new JPanel(new BorderLayout());
        basePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        basePanel.add((Component)lookAndFeelComboBox, "Center");
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)new DefaultOkCancelDialogBuilder(basePanel).owner(this.owner)).title(MessageBundle.messageBundle(LookAndFeelProvider.class, (ResourceBundle)ResourceBundle.getBundle(LookAndFeelProvider.class.getName())).getString("select_look_and_feel"))).onOk(() -> selectedLookAndFeel.accept(lookAndFeelComboBox.selectedLookAndFeel())).onCancel(lookAndFeelComboBox::revert).show();
    }
}

