/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.model.CancelException;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultOkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

final class DefaultSelectionDialogBuilder<T>
extends AbstractDialogBuilder<SelectionDialogBuilder<T>>
implements SelectionDialogBuilder<T> {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(DefaultSelectionDialogBuilder.class, (ResourceBundle)ResourceBundle.getBundle(DefaultSelectionDialogBuilder.class.getName()));
    private static final int MAX_SELECT_VALUE_DIALOG_WIDTH = 500;
    private final Collection<T> values;
    private final Collection<T> defaultSelection = new ArrayList<T>();
    private boolean allowEmptySelection = false;
    private Dimension dialogSize;

    DefaultSelectionDialogBuilder(Collection<T> values) {
        if (Objects.requireNonNull(values).isEmpty()) {
            throw new IllegalArgumentException("One or more items to select from must be provided");
        }
        this.values = new ArrayList<T>(values);
    }

    @Override
    public SelectionDialogBuilder<T> defaultSelection(T defaultSelection) {
        return this.defaultSelection((Collection<T>)Collections.singletonList(Objects.requireNonNull(defaultSelection)));
    }

    @Override
    public SelectionDialogBuilder<T> defaultSelection(Collection<T> defaultSelection) {
        if (!this.values.containsAll(Objects.requireNonNull(defaultSelection))) {
            throw new IllegalArgumentException("defaultSelection was not found in selection items");
        }
        this.defaultSelection.addAll(defaultSelection);
        return this;
    }

    @Override
    public SelectionDialogBuilder<T> allowEmptySelection(boolean allowEmptySelection) {
        this.allowEmptySelection = allowEmptySelection;
        return this;
    }

    @Override
    public SelectionDialogBuilder<T> dialogSize(Dimension dialogSize) {
        this.dialogSize = Objects.requireNonNull(dialogSize);
        return this;
    }

    @Override
    public Optional<T> selectSingle() {
        return DefaultSelectionDialogBuilder.selectSingle(this, this.dialogSize);
    }

    @Override
    public Collection<T> select() {
        return DefaultSelectionDialogBuilder.select(this, false, this.dialogSize);
    }

    private static <T> Optional<T> selectSingle(DefaultSelectionDialogBuilder<T> builder, Dimension dialogSize) {
        List<T> selected = DefaultSelectionDialogBuilder.select(builder, true, dialogSize);
        if (selected.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(selected.get(0));
    }

    private static <T> List<T> select(DefaultSelectionDialogBuilder<T> builder, boolean singleSelection, Dimension dialogSize) {
        JList list = DefaultSelectionDialogBuilder.createList(builder, singleSelection);
        Object okControl = ((CommandControl.CommandControlBuilder)Control.builder().command(() -> Utilities.disposeParentWindow(list)).enabled((StateObserver)(builder.allowEmptySelection ? null : DefaultSelectionDialogBuilder.createSelectionNonEmptyState(list)))).build();
        list.addMouseListener(new MouseAdapter((Control)okControl){
            final /* synthetic */ Control val$okControl;
            {
                this.val$okControl = control;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    this.val$okControl.actionPerformed(null);
                }
            }
        });
        State cancelledState = State.state();
        Runnable onCancel = () -> {
            list.clearSelection();
            cancelledState.set((Object)true);
        };
        JDialog dialog = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)new DefaultOkCancelDialogBuilder(new JScrollPane(list)).owner(builder.owner)).locationRelativeTo(builder.locationRelativeTo)).title(DefaultSelectionDialogBuilder.createTitle(builder, singleSelection))).size(dialogSize)).okAction((Action)okControl).onCancel(onCancel).build();
        if (dialog.getSize().width > 500) {
            dialog.setSize(new Dimension(500, dialog.getSize().height));
        }
        dialog.setVisible(true);
        if (((Boolean)cancelledState.get()).booleanValue()) {
            throw new CancelException();
        }
        return list.getSelectedValuesList();
    }

    private static <T> JList<T> createList(DefaultSelectionDialogBuilder<T> builder, boolean singleSelection) {
        DefaultListModel listModel = new DefaultListModel();
        builder.values.forEach(listModel::addElement);
        JList list = new JList(listModel);
        if (singleSelection) {
            list.setSelectionMode(0);
        }
        list.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        builder.defaultSelection.stream().mapToInt(listModel::indexOf).boxed().sorted(Collections.reverseOrder()).mapToInt(Integer::intValue).peek(index -> list.getSelectionModel().addSelectionInterval(index, index)).min().ifPresent(list::ensureIndexIsVisible);
        return list;
    }

    private static State createSelectionNonEmptyState(JList<?> list) {
        State selectionNonEmptyState = State.state((!list.getSelectionModel().isSelectionEmpty() ? 1 : 0) != 0);
        list.addListSelectionListener(e -> selectionNonEmptyState.set((Object)(!list.getSelectionModel().isSelectionEmpty() ? 1 : 0)));
        return selectionNonEmptyState;
    }

    private static <T> String createTitle(DefaultSelectionDialogBuilder<T> builder, boolean singleSelection) {
        if (singleSelection) {
            return builder.title == null ? MESSAGES.getString("select_value") : (String)builder.title.get();
        }
        return builder.title == null ? MESSAGES.getString("select_values") : (String)builder.title.get();
    }
}

