/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.i18n.Messages;
import is.codion.common.property.PropertyStore;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.label.LabelBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.DefaultFileSelectionDialogBuilder;
import is.codion.swing.common.ui.dialog.FileSelectionDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

final class ExceptionPanel
extends JPanel {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(ExceptionPanel.class, (ResourceBundle)ResourceBundle.getBundle(ExceptionPanel.class.getName()));
    private static final int MESSAGE_AREA_WIDTH = 500;
    private static final int SCROLL_PANE_WIDTH = 500;
    private static final int SCROLL_PANE_HEIGHT = 200;
    private static final int TAB_SIZE = 4;
    private final State showDetailState = ((State.Builder)State.builder().consumer(this::showDetails)).build();
    private final JCheckBox detailsCheckBox = (JCheckBox)((CheckBoxBuilder)((CheckBoxBuilder)CheckBoxBuilder.builder((Value<Boolean>)this.showDetailState).text(MESSAGES.getString("details"))).toolTipText(MESSAGES.getString("show_details"))).build();
    private final JTextArea errorMessageArea = (JTextArea)((TextAreaBuilder)TextAreaBuilder.builder().rowsColumns(3, 20).editable(false)).lineWrap(true).wrapStyleWord(true).build();
    private final JTextArea stackTraceArea = (JTextArea)((TextAreaBuilder)TextAreaBuilder.builder().editable(false)).tabSize(4).build();
    private final JScrollPane stackTraceScrollPane = (JScrollPane)((ScrollPaneBuilder)((ScrollPaneBuilder)ScrollPaneBuilder.builder(this.stackTraceArea).visible(false)).preferredSize(new Dimension(500, 200))).build();
    private final JButton printButton = (JButton)((ButtonBuilder)ButtonBuilder.builder(((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.stackTraceArea::print).name(Messages.print())).description(MESSAGES.getString("print_error_report"))).mnemonic(MESSAGES.getString("print_error_report_mnemonic").charAt(0))).visible(false)).build();
    private final JButton saveButton = (JButton)((ButtonBuilder)ButtonBuilder.builder(((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::saveDetails).name(MESSAGES.getString("save"))).description(MESSAGES.getString("save_error_log"))).mnemonic(MESSAGES.getString("save_mnemonic").charAt(0))).visible(false)).build();
    private final JButton closeButton = (JButton)ButtonBuilder.builder(((CommandControl.CommandControlBuilder)Control.builder().command(this::closeDialog).name(MESSAGES.getString("close"))).description(MESSAGES.getString("close_dialog"))).build();
    private final JButton copyButton = (JButton)((ButtonBuilder)ButtonBuilder.builder(((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> Utilities.setClipboard(this.stackTraceArea.getText())).name(Messages.copy())).description(MESSAGES.getString("copy_to_clipboard"))).mnemonic(MESSAGES.getString("copy_mnemonic").charAt(0))).visible(false)).build();

    ExceptionPanel(Throwable throwable, String message, boolean systemProperties) {
        this.setThrowable(throwable, message == null ? throwable.getClass().getSimpleName() : message, systemProperties);
        this.setLayout(Layouts.borderLayout());
        this.add((Component)this.createMainPanel(), "Center");
        this.bindEvents();
    }

    JButton closeButton() {
        return this.closeButton;
    }

    JCheckBox detailsCheckBox() {
        return this.detailsCheckBox;
    }

    private JPanel createMainPanel() {
        return (JPanel)((BorderLayoutPanelBuilder)BorderLayoutPanelBuilder.builder().border(Borders.emptyBorder())).northComponent((JComponent)BorderLayoutPanelBuilder.builder().westComponent((JComponent)LabelBuilder.builder(UIManager.getIcon("OptionPane.errorIcon")).build()).centerComponent((JComponent)((ScrollPaneBuilder)ScrollPaneBuilder.builder(this.errorMessageArea).preferredWidth(500)).build()).build()).centerComponent(this.stackTraceScrollPane).southComponent(this.createButtonPanel()).build();
    }

    private JPanel createButtonPanel() {
        return (JPanel)BorderLayoutPanelBuilder.builder(Layouts.borderLayout()).westComponent((JComponent)PanelBuilder.builder(Layouts.flowLayout(0)).add(this.detailsCheckBox).build()).centerComponent((JComponent)PanelBuilder.builder(Layouts.flowLayout(2)).addAll(this.copyButton, this.printButton, this.saveButton, this.closeButton).build()).build();
    }

    private void bindEvents() {
        KeyEvents.builder(27).condition(2).action(Control.commandControl(this::closeDialog)).enable(this);
    }

    private void showDetails(boolean showDetails) {
        this.copyButton.setVisible(showDetails);
        this.printButton.setVisible(showDetails);
        this.saveButton.setVisible(showDetails);
        this.stackTraceScrollPane.setVisible(showDetails);
        this.parentDialog().ifPresent(dialog -> {
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getOwner());
        });
    }

    private void closeDialog() {
        this.parentDialog().ifPresent(Window::dispose);
    }

    private Optional<JDialog> parentDialog() {
        return Optional.of(Utilities.parentDialog(this));
    }

    private void saveDetails() throws IOException {
        Files.write(((FileSelectionDialogBuilder)new DefaultFileSelectionDialogBuilder().owner(this.stackTraceArea)).selectFileToSave("error.txt").toPath(), Arrays.asList(this.stackTraceArea.getText().split("\\r?\\n")), new OpenOption[0]);
    }

    private void setThrowable(Throwable exception, String message, boolean systemProperties) {
        this.errorMessageArea.setText(message);
        this.errorMessageArea.setCaretPosition(0);
        this.stackTraceArea.setText(ExceptionPanel.stackTraceAndProperties(exception, systemProperties));
        this.stackTraceArea.setCaretPosition(0);
    }

    private static String stackTraceAndProperties(Throwable exception, boolean systemProperties) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        StringBuilder builder = new StringBuilder(stringWriter.toString());
        if (systemProperties) {
            builder.append("\n");
            builder.append("--------------------------------------------Properties--------------------------------------------\n\n");
            builder.append(PropertyStore.systemProperties());
        }
        return builder.toString();
    }
}

