/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.laf;

import is.codion.common.Configuration;
import is.codion.common.item.Item;
import is.codion.common.property.PropertyValue;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.laf.LookAndFeelPanel;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public final class LookAndFeelComboBox
extends JComboBox<Item<LookAndFeelProvider>> {
    public static final PropertyValue<Boolean> ENABLE_ON_SELECTION = Configuration.booleanValue((String)(LookAndFeelComboBox.class.getName() + ".enableOnSelection"), (boolean)true);
    private final LookAndFeelProvider originalLookAndFeel;

    private LookAndFeelComboBox(FilterComboBoxModel<Item<LookAndFeelProvider>> comboBoxModel, boolean enableOnSelection) {
        super((ComboBoxModel)Objects.requireNonNull(comboBoxModel));
        Item selectedValue = (Item)comboBoxModel.selectedValue();
        this.originalLookAndFeel = selectedValue == null ? null : (LookAndFeelProvider)selectedValue.value();
        this.setRenderer(new LookAndFeelRenderer());
        this.setEditor(new LookAndFeelEditor());
        ComboBoxBuilder.enableMouseWheelSelection(this);
        if (enableOnSelection) {
            comboBoxModel.selectedItem().addConsumer(lookAndFeelProvider -> SwingUtilities.invokeLater(() -> LookAndFeelProvider.enableLookAndFeel((LookAndFeelProvider)lookAndFeelProvider.value())));
        }
    }

    @Override
    public FilterComboBoxModel<Item<LookAndFeelProvider>> getModel() {
        return (FilterComboBoxModel)super.getModel();
    }

    public LookAndFeelProvider selectedLookAndFeel() {
        return (LookAndFeelProvider)((Item)this.getModel().selectedValue()).value();
    }

    public void enableSelected() {
        String currentLookAndFeelClassName = UIManager.getLookAndFeel().getClass().getName();
        if (!this.selectedLookAndFeel().lookAndFeelInfo().getClassName().equals(currentLookAndFeelClassName)) {
            LookAndFeelProvider.enableLookAndFeel(this.selectedLookAndFeel());
        }
    }

    public void revert() {
        String currentLookAndFeelClassName = UIManager.getLookAndFeel().getClass().getName();
        if (this.originalLookAndFeel != null && !currentLookAndFeelClassName.equals(this.originalLookAndFeel.lookAndFeelInfo().getClassName())) {
            LookAndFeelProvider.enableLookAndFeel(this.originalLookAndFeel);
        }
    }

    public static LookAndFeelComboBox lookAndFeelComboBox() {
        return new LookAndFeelComboBox(LookAndFeelComboBox.createLookAndFeelComboBoxModel(), (Boolean)ENABLE_ON_SELECTION.get());
    }

    public static LookAndFeelComboBox lookAndFeelComboBox(boolean enableOnSelection) {
        return new LookAndFeelComboBox(LookAndFeelComboBox.createLookAndFeelComboBoxModel(), enableOnSelection);
    }

    private static FilterComboBoxModel<Item<LookAndFeelProvider>> createLookAndFeelComboBoxModel() {
        FilterComboBoxModel comboBoxModel = FilterComboBoxModel.filterComboBoxModel();
        comboBoxModel.setItems(LookAndFeelComboBox.initializeAvailableLookAndFeels());
        LookAndFeelComboBox.currentLookAndFeel((FilterComboBoxModel<Item<LookAndFeelProvider>>)comboBoxModel).ifPresent(arg_0 -> comboBoxModel.setSelectedItem(arg_0));
        return comboBoxModel;
    }

    private static List<Item<LookAndFeelProvider>> initializeAvailableLookAndFeels() {
        return LookAndFeelProvider.lookAndFeelProviders().values().stream().sorted(Comparator.comparing(lookAndFeelProvider -> lookAndFeelProvider.lookAndFeelInfo().getName())).map(provider -> Item.item((Object)provider, (String)provider.lookAndFeelInfo().getName())).collect(Collectors.toList());
    }

    private static Optional<Item<LookAndFeelProvider>> currentLookAndFeel(FilterComboBoxModel<Item<LookAndFeelProvider>> comboBoxModel) {
        String currentLookAndFeelClassName = UIManager.getLookAndFeel().getClass().getName();
        return comboBoxModel.items().stream().filter(item -> ((LookAndFeelProvider)item.value()).lookAndFeelInfo().getClassName().equals(currentLookAndFeelClassName)).findFirst();
    }

    private static final class LookAndFeelRenderer
    implements ListCellRenderer<Item<LookAndFeelProvider>> {
        private final LookAndFeelPanel panel = new LookAndFeelPanel();

        private LookAndFeelRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Item<LookAndFeelProvider>> list, Item<LookAndFeelProvider> value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.panel.setLookAndFeel((LookAndFeelProvider)value.value(), isSelected);
            }
            return this.panel;
        }
    }

    private static final class LookAndFeelEditor
    extends BasicComboBoxEditor {
        private final LookAndFeelPanel panel = new LookAndFeelPanel();
        private Item<LookAndFeelProvider> item;

        private LookAndFeelEditor() {
        }

        @Override
        public Component getEditorComponent() {
            return this.panel;
        }

        @Override
        public Object getItem() {
            return this.item;
        }

        @Override
        public void setItem(Object item) {
            this.item = (Item)item;
            if (this.item != null) {
                this.panel.setLookAndFeel((LookAndFeelProvider)this.item.value(), false);
            }
        }
    }
}

