/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.laf;

import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.label.LabelBuilder;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;

final class LookAndFeelPanel
extends JPanel {
    private static final int BORDER_THICKNESS = 5;
    private static final int COLOR_LABEL_WIDTH = 42;
    private final UIDefaults nullDefaults = new UIDefaults(0, 0.1f);
    private final Map<LookAndFeelProvider, UIDefaults> lookAndFeelDefaults = new ConcurrentHashMap<LookAndFeelProvider, UIDefaults>();
    private final JLabel textLabel = new JLabel();
    private final JLabel colorLabel = (JLabel)((LabelBuilder)Components.label().preferredWidth(42)).build();

    LookAndFeelPanel() {
        super(new BorderLayout());
        this.add((Component)this.textLabel, "Center");
        this.add((Component)this.colorLabel, "East");
    }

    void setLookAndFeel(LookAndFeelProvider lookAndFeel, boolean selected) {
        this.textLabel.setOpaque(true);
        this.colorLabel.setOpaque(true);
        this.textLabel.setText(lookAndFeel.lookAndFeelInfo().getName());
        UIDefaults defaults = this.defaults(lookAndFeel);
        if (defaults == this.nullDefaults) {
            this.textLabel.setBackground(selected ? Color.LIGHT_GRAY : Color.WHITE);
            this.textLabel.setForeground(Color.BLACK);
            this.colorLabel.setBackground(Color.WHITE);
            this.colorLabel.setBorder(null);
        } else {
            this.textLabel.setFont(defaults.getFont("TextField.font"));
            this.textLabel.setForeground(defaults.getColor(selected ? "TextField.selectionForeground" : "Label.foreground"));
            this.textLabel.setBackground(defaults.getColor(selected ? "TextField.selectionBackground" : "Label.background"));
            this.colorLabel.setBackground(defaults.getColor("TextField.background"));
            this.colorLabel.setBorder(BorderFactory.createLineBorder(defaults.getColor("ProgressBar.foreground"), 5));
        }
    }

    private UIDefaults defaults(LookAndFeelProvider lookAndFeelProvider) {
        return this.lookAndFeelDefaults.computeIfAbsent(lookAndFeelProvider, this::initializeLookAndFeelDefaults);
    }

    private UIDefaults initializeLookAndFeelDefaults(LookAndFeelProvider lookAndFeelProvider) {
        try {
            return lookAndFeelProvider.lookAndFeel().getDefaults();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return this.nullDefaults;
        }
    }
}

