/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Arrays;

public final class FlexibleGridLayout
extends GridLayout {
    private static final double ONE_POINT_O = 1.0;
    private final boolean fixedRowHeights;
    private final boolean fixedColumnWidths;
    private int fixedColumnWidth;
    private int fixedRowHeight;

    private FlexibleGridLayout(DefaultBuilder builder) {
        super(builder.rows, builder.columns, builder.horizontalGap, builder.verticalGap);
        this.fixedRowHeights = builder.fixRowHeights;
        this.fixedColumnWidths = builder.fixColumnWidths;
    }

    public FlexibleGridLayout setFixedRowHeight(int height) {
        this.fixedRowHeight = height;
        return this;
    }

    public FlexibleGridLayout setFixedColumnWidth(int width) {
        this.fixedColumnWidth = width;
        return this;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int numberOfComponents = parent.getComponentCount();
            int numberOfRows = this.getRows();
            int numberOfColumns = this.getColumns();
            if (numberOfComponents == 0) {
                return;
            }
            if (numberOfRows > 0) {
                numberOfColumns = (numberOfComponents + numberOfRows - 1) / numberOfRows;
            } else {
                numberOfRows = (numberOfComponents + numberOfColumns - 1) / numberOfColumns;
            }
            int horizontalGap = this.getHgap();
            int verticalGap = this.getVgap();
            Dimension pd = this.preferredLayoutSize(parent);
            double sw = 1.0 * (double)parent.getWidth() / pd.getWidth();
            double sh = 1.0 * (double)parent.getHeight() / pd.getHeight();
            int[] columnWidths = new int[numberOfColumns];
            int[] rowHeights = new int[numberOfRows];
            for (int i = 0; i < numberOfComponents; ++i) {
                int row = i / numberOfColumns;
                int column = i % numberOfColumns;
                Component currentComponent = parent.getComponent(i);
                Dimension currCompPrefSize = currentComponent.getPreferredSize();
                currCompPrefSize.width = (int)(sw * currCompPrefSize.getWidth());
                currCompPrefSize.height = (int)(sh * currCompPrefSize.getHeight());
                if ((double)columnWidths[column] < currCompPrefSize.getWidth()) {
                    columnWidths[column] = (int)currCompPrefSize.getWidth();
                }
                if (!((double)rowHeights[row] < currCompPrefSize.getHeight())) continue;
                rowHeights[row] = (int)currCompPrefSize.getHeight();
            }
            this.arrangeFixedSizes(columnWidths, rowHeights);
            int x = insets.left;
            for (int c = 0; c < numberOfColumns; ++c) {
                int y = insets.top;
                for (int r = 0; r < numberOfRows; ++r) {
                    int i = r * numberOfColumns + c;
                    if (i < numberOfComponents) {
                        parent.getComponent(i).setBounds(x, y, columnWidths[c], rowHeights[r]);
                    }
                    y += rowHeights[r] + verticalGap;
                }
                x += columnWidths[c] + horizontalGap;
            }
        }
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private void arrangeFixedSizes(int[] columnWidths, int[] rowHeights) {
        if (this.fixedColumnWidths) {
            int maxColumnWidth = 0;
            if (this.fixedColumnWidth <= 0) {
                for (int columnWidth : columnWidths) {
                    maxColumnWidth = Math.max(columnWidth, maxColumnWidth);
                }
            } else {
                maxColumnWidth = this.fixedColumnWidth;
            }
            Arrays.fill(columnWidths, maxColumnWidth);
        }
        if (this.fixedRowHeights) {
            int maxRowHeight = 0;
            if (this.fixedRowHeight <= 0) {
                for (int rowHeight : rowHeights) {
                    maxRowHeight = Math.max(rowHeight, maxRowHeight);
                }
            } else {
                maxRowHeight = this.fixedRowHeight;
            }
            Arrays.fill(rowHeights, maxRowHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container parent, boolean preferredSize) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int numberOfComponents = parent.getComponentCount();
            int numberOfRows = this.getRows();
            int numberOfColumns = this.getColumns();
            if (numberOfRows > 0) {
                numberOfColumns = (numberOfComponents + numberOfRows - 1) / numberOfRows;
            } else {
                numberOfRows = (numberOfComponents + numberOfColumns - 1) / numberOfColumns;
            }
            int[] columnWidths = new int[numberOfColumns];
            int[] rowHeights = new int[numberOfRows];
            for (int i = 0; i < numberOfComponents; ++i) {
                Dimension d;
                int row = i / numberOfColumns;
                int column = i % numberOfColumns;
                Component comp = parent.getComponent(i);
                Dimension dimension = d = preferredSize ? comp.getPreferredSize() : comp.getMinimumSize();
                if ((double)columnWidths[column] < d.getWidth()) {
                    columnWidths[column] = (int)d.getWidth();
                }
                if (!((double)rowHeights[row] < d.getHeight())) continue;
                rowHeights[row] = (int)d.getHeight();
            }
            this.arrangeFixedSizes(columnWidths, rowHeights);
            int newWidth = Arrays.stream(columnWidths).sum();
            int newHeight = Arrays.stream(rowHeights).sum();
            return new Dimension(insets.left + insets.right + newWidth + (numberOfColumns - 1) * this.getHgap(), insets.top + insets.bottom + newHeight + (numberOfRows - 1) * this.getVgap());
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private int rows = 0;
        private int columns = 0;
        private int horizontalGap = 0;
        private int verticalGap = 0;
        private boolean fixRowHeights = false;
        private boolean fixColumnWidths = false;
        private int fixedRowHeight;
        private int fixedColumnWidth;

        private DefaultBuilder() {
        }

        @Override
        public Builder rows(int rows) {
            this.rows = rows;
            return this;
        }

        @Override
        public Builder columns(int columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public Builder rowsColumns(int rows, int columns) {
            this.rows = rows;
            this.columns = columns;
            return this;
        }

        @Override
        public Builder gap(int gap) {
            this.horizontalGap = gap;
            this.verticalGap = gap;
            return this;
        }

        @Override
        public Builder horizontalGap(int horizontalGap) {
            this.horizontalGap = horizontalGap;
            return this;
        }

        @Override
        public Builder verticalGap(int verticalGap) {
            this.verticalGap = verticalGap;
            return this;
        }

        @Override
        public Builder fixRowHeights(boolean fixRowHeights) {
            this.fixRowHeights = fixRowHeights;
            return this;
        }

        @Override
        public Builder fixColumnWidths(boolean fixColumnWidths) {
            this.fixColumnWidths = fixColumnWidths;
            return this;
        }

        @Override
        public Builder fixedRowHeight(int fixedRowHeight) {
            this.fixRowHeights(true);
            this.fixedRowHeight = fixedRowHeight;
            return this;
        }

        @Override
        public Builder fixedColumnWidth(int fixedColumnWidth) {
            this.fixColumnWidths(true);
            this.fixedColumnWidth = fixedColumnWidth;
            return this;
        }

        @Override
        public FlexibleGridLayout build() {
            FlexibleGridLayout layout = new FlexibleGridLayout(this);
            if (this.fixedRowHeight > 0) {
                layout.setFixedRowHeight(this.fixedRowHeight);
            }
            if (this.fixedColumnWidth > 0) {
                layout.setFixedColumnWidth(this.fixedColumnWidth);
            }
            return layout;
        }
    }

    public static interface Builder {
        public Builder rows(int var1);

        public Builder columns(int var1);

        public Builder rowsColumns(int var1, int var2);

        public Builder gap(int var1);

        public Builder horizontalGap(int var1);

        public Builder verticalGap(int var1);

        public Builder fixRowHeights(boolean var1);

        public Builder fixColumnWidths(boolean var1);

        public Builder fixedRowHeight(int var1);

        public Builder fixedColumnWidth(int var1);

        public FlexibleGridLayout build();
    }
}

