/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.Operator;
import is.codion.common.model.condition.ConditionModel;
import is.codion.common.observable.Observer;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.framework.model.SwingForeignKeyConditionModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.text.Format;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DefaultSwingForeignKeyConditionModel
implements SwingForeignKeyConditionModel {
    private static final String EQUAL_SEARCH_MODEL_MESSAGE = "SwingForeignKeyCondition uses a EntityComboBoxModel for the EQUAL operand";
    private final ConditionModel<Entity> condition;
    private final EntityComboBoxModel equalComboBoxModel;
    private final EntitySearchModel inSearchModel;

    private DefaultSwingForeignKeyConditionModel(DefaultBuilder builder) {
        this.equalComboBoxModel = builder.equalComboBoxModel;
        this.inSearchModel = builder.inSearchModel;
        this.condition = ConditionModel.builder(Entity.class).operators(builder.operators()).operator(DefaultSwingForeignKeyConditionModel.defaultOperator(builder)).operands((ConditionModel.Operands)new ForeignKeyOperands()).build();
    }

    public State caseSensitive() {
        return this.condition.caseSensitive();
    }

    public Optional<Format> format() {
        return this.condition.format();
    }

    public Optional<String> dateTimePattern() {
        return this.condition.dateTimePattern();
    }

    public Value<ConditionModel.Wildcard> wildcard() {
        return this.condition.wildcard();
    }

    public State autoEnable() {
        return this.condition.autoEnable();
    }

    public State locked() {
        return this.condition.locked();
    }

    public Class<Entity> valueClass() {
        return this.condition.valueClass();
    }

    public List<Operator> operators() {
        return this.condition.operators();
    }

    public State enabled() {
        return this.condition.enabled();
    }

    public void clear() {
        this.condition.clear();
    }

    public Value<Operator> operator() {
        return this.condition.operator();
    }

    public ConditionModel.Operands<Entity> operands() {
        return this.condition.operands();
    }

    public ConditionModel.SetCondition<Entity> set() {
        return this.condition.set();
    }

    public boolean accepts(Comparable<Entity> value) {
        return this.condition.accepts(value);
    }

    public Observer<?> changed() {
        return this.condition.changed();
    }

    @Override
    public EntityComboBoxModel equalComboBoxModel() {
        if (this.equalComboBoxModel == null) {
            throw new IllegalStateException("No EntityComboBoxModel is available for the EQUAL operand");
        }
        return this.equalComboBoxModel;
    }

    public EntitySearchModel equalSearchModel() {
        throw new UnsupportedOperationException(EQUAL_SEARCH_MODEL_MESSAGE);
    }

    public EntitySearchModel inSearchModel() {
        if (this.inSearchModel == null) {
            throw new IllegalStateException("No EntitySearchModel available for the IN operand");
        }
        return this.inSearchModel;
    }

    private static Operator defaultOperator(DefaultBuilder builder) {
        if (builder.inSearchModel == null) {
            return Operator.EQUAL;
        }
        boolean searchable = !builder.inSearchModel.entityDefinition().columns().searchable().isEmpty();
        return searchable ? Operator.IN : Operator.EQUAL;
    }

    static final class DefaultBuilder
    implements SwingForeignKeyConditionModel.Builder {
        private EntityComboBoxModel equalComboBoxModel;
        private EntitySearchModel inSearchModel;

        DefaultBuilder() {
        }

        @Override
        public SwingForeignKeyConditionModel.Builder equalComboBoxModel(EntityComboBoxModel equalComboBoxModel) {
            this.equalComboBoxModel = Objects.requireNonNull(equalComboBoxModel);
            return this;
        }

        @Override
        public SwingForeignKeyConditionModel.Builder equalSearchModel(EntitySearchModel equalSearchModel) {
            throw new UnsupportedOperationException(DefaultSwingForeignKeyConditionModel.EQUAL_SEARCH_MODEL_MESSAGE);
        }

        @Override
        public SwingForeignKeyConditionModel.Builder inSearchModel(EntitySearchModel inSearchModel) {
            this.inSearchModel = Objects.requireNonNull(inSearchModel);
            return this;
        }

        @Override
        public SwingForeignKeyConditionModel build() {
            return new DefaultSwingForeignKeyConditionModel(this);
        }

        private List<Operator> operators() {
            if (this.equalComboBoxModel == null && this.inSearchModel == null) {
                throw new IllegalStateException("Neither EQUAL nor IN operator specified");
            }
            if (this.equalComboBoxModel != null && this.inSearchModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.IN, Operator.NOT_IN);
            }
            if (this.equalComboBoxModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL);
            }
            return Arrays.asList(Operator.IN, Operator.NOT_IN);
        }
    }

    private final class ForeignKeyOperands
    implements ConditionModel.Operands<Entity> {
        private ForeignKeyOperands() {
        }

        public Value<Entity> equal() {
            return DefaultSwingForeignKeyConditionModel.this.equalComboBoxModel == null ? super.equal() : DefaultSwingForeignKeyConditionModel.this.equalComboBoxModel.selection().item();
        }

        public ValueSet<Entity> in() {
            return DefaultSwingForeignKeyConditionModel.this.inSearchModel == null ? super.in() : DefaultSwingForeignKeyConditionModel.this.inSearchModel.selection().entities();
        }
    }
}

