/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.proxy.ProxyBuilder;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class SwingEntityEditModel
extends AbstractEntityEditModel {
    private static final NullItemCaption NULL_ITEM_CAPTION = new NullItemCaption();
    private final Map<Attribute<?>, FilterComboBoxModel<?>> comboBoxModels = new HashMap();

    public SwingEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        super(entityType, Objects.requireNonNull(connectionProvider));
    }

    public final void initializeComboBoxModels(Attribute<?> ... attributes) {
        Objects.requireNonNull(attributes);
        for (Attribute<?> attribute : attributes) {
            if (attribute instanceof ForeignKey) {
                this.comboBoxModel((ForeignKey)attribute).items().refresh();
                continue;
            }
            if (!(attribute instanceof Column)) continue;
            this.comboBoxModel((Column)attribute).items().refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshForeignKeyComboBoxModels() {
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilterComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                if (!(comboBoxModel instanceof EntityComboBoxModel)) continue;
                comboBoxModel.items().refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshComboBoxModels() {
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilterComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                comboBoxModel.items().refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearComboBoxModels() {
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilterComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                comboBoxModel.items().clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EntityComboBoxModel comboBoxModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            EntityComboBoxModel comboBoxModel = (EntityComboBoxModel)this.comboBoxModels.get(foreignKey);
            if (comboBoxModel == null) {
                comboBoxModel = this.createComboBoxModel(foreignKey);
                this.comboBoxModels.put((Attribute<?>)foreignKey, comboBoxModel);
            }
            return comboBoxModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> FilterComboBoxModel<T> comboBoxModel(Column<T> column) {
        this.entityDefinition().columns().definition(column);
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            Object comboBoxModel = this.comboBoxModels.get(column);
            if (comboBoxModel == null) {
                comboBoxModel = this.createComboBoxModel(column);
                this.comboBoxModels.put((Attribute<?>)column, (FilterComboBoxModel<?>)comboBoxModel);
            }
            return comboBoxModel;
        }
    }

    public EntityComboBoxModel createComboBoxModel(ForeignKey foreignKey) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition().foreignKeys().definition(foreignKey);
        return EntityComboBoxModel.builder(foreignKey.referencedType(), this.connectionProvider()).attributes(foreignKeyDefinition.attributes()).includeNull(this.editor().nullable((Attribute)foreignKey)).build();
    }

    public <T> FilterComboBoxModel<T> createComboBoxModel(Column<T> column) {
        FilterComboBoxModel.Builder<T> builder = this.createColumnComboBoxModel(Objects.requireNonNull(column));
        if (this.editor().nullable(column)) {
            builder.includeNull(true);
            if (column.type().valueClass().isInterface()) {
                builder.nullItem(ProxyBuilder.builder((Class)column.type().valueClass()).method("toString", (ProxyBuilder.ProxyMethod)NULL_ITEM_CAPTION).build());
            }
        }
        FilterComboBoxModel comboBoxModel = builder.build();
        this.afterInsertUpdateOrDelete().addListener(() -> ((FilterComboBoxModel.ComboBoxItems)comboBoxModel.items()).refresh());
        return comboBoxModel;
    }

    public final void add(ForeignKey foreignKey, Collection<Entity> entities) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(entities);
        if (this.comboBoxModels.containsKey(foreignKey)) {
            entities.forEach(arg_0 -> ((FilterComboBoxModel.ComboBoxItems)this.comboBoxModel(foreignKey).items()).add(arg_0));
        }
    }

    public final void remove(ForeignKey foreignKey, Collection<Entity> entities) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(entities);
        this.clearForeignKeyReferences(foreignKey, entities);
        if (this.comboBoxModels.containsKey(foreignKey)) {
            this.comboBoxModel(foreignKey).items().remove(entities);
        }
    }

    protected void replaceForeignKey(ForeignKey foreignKey, Collection<Entity> entities) {
        super.replaceForeignKey(foreignKey, entities);
        if (this.comboBoxModels.containsKey(foreignKey)) {
            EntityComboBoxModel comboBoxModel = this.comboBoxModel(foreignKey);
            entities.forEach(foreignKeyValue -> comboBoxModel.items().replace(foreignKeyValue, foreignKeyValue));
        }
    }

    private void clearForeignKeyReferences(ForeignKey foreignKey, Collection<Entity> entities) {
        entities.forEach(entity -> {
            if (Objects.equals(entity, this.editor().value((Attribute)foreignKey).get())) {
                this.editor().value((Attribute)foreignKey).clear();
            }
        });
    }

    private <T> FilterComboBoxModel.Builder<T> createColumnComboBoxModel(Column<T> column) {
        return column.type().isEnum() ? FilterComboBoxModel.builder(Arrays.asList(column.type().valueClass().getEnumConstants())) : FilterComboBoxModel.builder(new ColumnItems<T>(this.connectionProvider(), column));
    }

    private static final class NullItemCaption
    implements ProxyBuilder.ProxyMethod<Object> {
        private final String caption = (String)FilterComboBoxModel.NULL_CAPTION.get();

        private NullItemCaption() {
        }

        public Object invoke(ProxyBuilder.ProxyMethod.Parameters<Object> parameters) throws Throwable {
            return this.caption;
        }
    }

    private static final class ColumnItems<T>
    implements Supplier<Collection<T>> {
        private final EntityConnectionProvider connectionProvider;
        private final Column<T> column;

        private ColumnItems(EntityConnectionProvider connectionProvider, Column<T> column) {
            this.connectionProvider = connectionProvider;
            this.column = column;
        }

        @Override
        public Collection<T> get() {
            return this.connectionProvider.connection().select(this.column);
        }
    }
}

